/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.hcs.db.Database;
import oracle.hcs.db.DatabaseUtils;
import oracle.hcs.db.source.Column;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;

public class DatabaseImpl
implements Database {
    private Connection conn;
    private String user;
    private String url;
    private Map<String, Object> userMap;

    public DatabaseImpl(Connection connection) {
        this.conn = connection;
        this.userMap = new HashMap<String, Object>();
    }

    public DatabaseImpl() {
        this.userMap = new HashMap<String, Object>();
    }

    @Override
    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        this.conn = DatabaseUtils.GetConnection(string3, string, string2);
        this.user = string;
        this.url = string3;
        this.conn.setAutoCommit(false);
        return this.conn;
    }

    public String getConnectionURL() {
        return this.url;
    }

    @Override
    public String getUser() throws SQLException {
        if (this.conn instanceof OracleConnection) {
            OracleConnection oracleConnection = (OracleConnection)this.conn;
            return oracleConnection.getUserName();
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public List<String> getSchemas() throws SQLException {
        List list = DatabaseUtils.GetSchemas(this.conn);
        return list;
    }

    @Override
    public List<String> getTables(String string) throws SQLException {
        List list = DatabaseUtils.GetTables(this.conn, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.contains("$")) continue;
            iterator.remove();
        }
        return list;
    }

    public List getColumns(String string, String string2) throws SQLException {
        List<Column> list = DatabaseUtils.GetTableColumns(this.conn, string, string2);
        return list;
    }

    @Override
    public List<List<String>> executeSQL(String string) throws SQLException, IOException {
        return DatabaseUtils.ExecuteSQL(this.conn, string);
    }

    @Override
    public List<List<String>> executeSQL(String string, Object[] objectArray) throws SQLException, IOException {
        return DatabaseUtils.ExecuteSQL(this.conn, string, objectArray);
    }

    public List<List<String>> executeSQL(String string, Map<String, Object> map) throws SQLException, IOException {
        return DatabaseUtils.ExecuteSQL(this.conn, string, map);
    }

    public String formatQueryToMessage(String string, String string2) throws SQLException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        List<List<String>> list = this.executeSQL(string);
        for (List<String> list2 : list) {
            Object[] objectArray = list2.toArray();
            String string3 = MessageFormat.format(string2, objectArray);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    @Override
    public Object executeStoredProc(String string, Object[] objectArray) throws SQLException, IOException {
        return DatabaseUtils.ExecuteStoredProc(this.conn, string, objectArray);
    }

    @Override
    public Object executeStoredProc(String string, List list) throws SQLException, IOException {
        return DatabaseUtils.ExecuteStoredProc(this.conn, string, list);
    }

    @Override
    public void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public Object getObject(String string) {
        return this.userMap.get(string);
    }

    public void putObject(String string, Object object) {
        this.userMap.put(string, object);
    }

    @Override
    public String convertCLOBToString(CLOB cLOB) throws SQLException, IOException {
        Reader reader = cLOB.getCharacterStream();
        char[] cArray = new char[1000];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(2000);
        while ((n = reader.read(cArray)) != -1) {
            String string = new String(cArray, 0, n);
            stringBuffer.append(string);
        }
        reader.close();
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        DatabaseImpl databaseImpl = new DatabaseImpl();
        try {
            databaseImpl.getConnection("global", "global", "stacx25:1521:rmain3");
            List<List<String>> list = databaseImpl.executeSQL("select * from channel_dim");
            for (List<String> list2 : list) {
                for (String string : list2) {
                    System.out.print(string + ",");
                }
                System.out.println();
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add("GLOBAL.TIME");
            databaseImpl.executeStoredProc("dbms_cube.build", arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            databaseImpl.close();
        }
    }
}

