/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.avviewer.AVViewerPanel;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVViewerDialog
extends JDialog {
    private OracleDatabaseImpl db;
    private AnalyticView cube;
    private List<String> languages;
    private JFrame parent;
    private JPanel panel;
    private AVViewerPanel dataPanel;
    private Action closeAction;
    private Action helpAction;

    public AVViewerDialog(JFrame jFrame, OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView, List<String> list) throws SQLException, IOException, DBException {
        this(jFrame, oracleDatabaseImpl, analyticView, list, false, null);
    }

    public AVViewerDialog(JFrame jFrame, OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView, List<String> list, boolean bl, Set<AVHierarchy> set) throws SQLException, IOException, DBException {
        super(jFrame);
        this.parent = jFrame;
        this.db = oracleDatabaseImpl;
        this.cube = analyticView;
        this.languages = list;
        String string = analyticView.getSchema().getName();
        String string2 = analyticView.getName();
        this.setTitle(HCSArb.format("AV_DATA_VIEWER_TITLE", string, string2));
        if (!bl) {
            for (AVMeasure aVMeasure : analyticView.getMeasures()) {
                aVMeasure.setSelected(true);
            }
        }
        this.panel = new JPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, "av_data_viewer");
        if (set == null) {
            set = new HashSet<AVHierarchy>();
        }
        this.dataPanel = new AVViewerPanel(this, oracleDatabaseImpl, analyticView, list, set);
        this.dataPanel.setName("dataPanel");
        Dimension dimension = Ide.getMainWindow().getSize();
        dimension.setSize(dimension.getWidth() * 0.8, dimension.getHeight() * 0.8);
        if (dimension.getWidth() < 700.0 || dimension.getHeight() < 500.0) {
            this.setSize(700, 500);
        } else {
            this.setSize(dimension);
        }
        this.setLocationRelativeTo(jFrame);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                try {
                    AVViewerDialog.this.dataPanel.cleanUp();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AVViewerDialog.this.dataPanel.cleanUp();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AVViewerDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpSystem.getHelpSystem().showHelp((JComponent)AVViewerDialog.this.panel);
            }
        };
        this.layoutComponents();
        this.registerKeyboardActions();
    }

    public void runQuery() {
        this.dataPanel.runQueryNonThreaded();
    }

    public void showViewer() {
        this.setVisible(true);
    }

    public void cleanup() {
    }

    private void layoutComponents() {
        JButton jButton = new JButton(this.closeAction);
        jButton.setName("closeButton");
        jButton.setText(StringUtils.stripMnemonic((String)HCSArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_CLOSE_BUTTON_TEXT")));
        JButton jButton2 = new JButton(this.helpAction);
        jButton2.setName("helpButton");
        jButton2.setText(StringUtils.stripMnemonic((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        jButton2.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.setName("bb");
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.panel.setName("panel");
        this.setContentPane(this.panel);
        this.panel.setLayout(new GridBagLayout());
        int n = 0;
        this.panel.add((Component)this.dataPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 5));
        this.panel.add((Component)dialogButtonBar, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 5, 5));
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this.closeAction, KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this.helpAction, KeyStroke.getKeyStroke(112, 0), 1);
    }
}

