/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.avviewer.AVViewerPanel;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.preferences.HCSPreferenceSettings;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.templateview.BaseTemplateHyperView;
import oracle.hcs.templates.templateview.TemplateContext;
import oracle.hcs.templates.templateview.TemplateGroupHyperView;
import oracle.hcs.templates.templateview.TemplateHyperContext;
import oracle.hcs.templates.templateview.TemplateHyperContextImpl;
import oracle.hcs.templates.templateview.TemplateJTree;
import oracle.hcs.templates.templateview.TemplateListHyperView;
import oracle.hcs.templates.templateview.TemplateMetadata;
import oracle.hcs.templates.templateview.TemplateViewNode;
import oracle.hcs.util.ButtonMenu;
import oracle.hcs.util.Resources;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.icons.OracleIcons;

public class AVConditionPanel
extends JPanel
implements PropertyChangeListener,
TreeSelectionListener {
    private static final Logger LOG = Logger.getLogger(AVConditionPanel.class.getName());
    private AVViewerPanel avViewerPanel;
    private TemplateListHyperView templateListHyperView;
    private TemplateJTree tree;
    private JButton runButton;
    private ButtonMenu addButton;
    private JButton removeButton;
    private JScrollPane treeScrollPane;
    private JLabel headerLabel;
    private List<PropertyChangeListener> listeners;
    private Resources resources;
    private TemplateContext templateContext;
    private TemplateHyperContextImpl thcontext;
    private ParamValue globalParamValue;
    private boolean treeStyle = true;
    private JCheckBox displayStyleCheckBox;
    private JCheckBox treeDirectSelectionCheckBox;

    public AVConditionPanel(AVViewerPanel aVViewerPanel, Resources resources) throws SQLException, IOException, DBException {
        this.avViewerPanel = aVViewerPanel;
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.resources = resources;
        OracleDatabaseImpl oracleDatabaseImpl = aVViewerPanel.getDatabase();
        this.setupTemplates(oracleDatabaseImpl);
        this.layoutComponents();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("VALUE_CHANGED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_INCLUDE") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_ADDED") || propertyChangeEvent.getPropertyName().equals("TEMPLATE_REMOVED")) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            if (this.treeStyle) {
                boolean bl;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AVConditionPanel.this.tree.startEditingAtPath(AVConditionPanel.this.tree.getSelectionPath());
                    }
                });
                if (propertyChangeEvent.getPropertyName().equals("TEMPLATE_INCLUDE") && !(bl = this.canUnselect((TemplateViewNode)this.tree.getSelectionPath().getLastPathComponent()))) {
                    PropertyChangeListener propertyChangeListener;
                    propertyChangeListener = (BaseTemplateHyperView)propertyChangeEvent.getSource();
                    ((BaseTemplateHyperView)propertyChangeListener).setIsIncluded(true);
                }
            }
        }
    }

    public String getQuery() throws SQLException, IOException {
        String string = this.templateListHyperView.getExpression();
        return string;
    }

    public int getSelectedCount() {
        return this.templateListHyperView.getSelectedCount();
    }

    public void setupTemplates(OracleDatabaseImpl oracleDatabaseImpl) throws SQLException, IOException, DBException {
        if (this.thcontext == null) {
            this.thcontext = new TemplateHyperContextImpl(oracleDatabaseImpl.getConnection(), this.resources, TemplateHyperContext.ResizeMode.LEGACY);
        }
        String string = Connections.getInstance().getConnectionName((Database)oracleDatabaseImpl);
        AnalyticView analyticView = this.avViewerPanel.getAV();
        Set<AVHierarchy> set = this.avViewerPanel.getPreselectedAVHierarchies();
        String string2 = analyticView.getSchema().getName();
        HCSSchema hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
        if (this.templateContext == null) {
            this.templateContext = new TemplateContext(new TemplateMetadata(hCSSchema, analyticView, set), (DBObjectProvider)oracleDatabaseImpl);
        } else {
            this.templateContext.reinitialize(new TemplateMetadata(hCSSchema, analyticView, set));
        }
        if (this.globalParamValue == null) {
            Preferences preferences = Preferences.getPreferences();
            HCSPreferenceSettings hCSPreferenceSettings = HCSPreferenceSettings.getInstance((PropertyStorage)preferences);
            int n = hCSPreferenceSettings.getAVDataViewerMaxHierarchies();
            int n2 = set.size();
            if (n2 > n) {
                n = n2;
            }
            final int n3 = n;
            final int n4 = hCSPreferenceSettings.getAVDataViewerMaxRows();
            this.globalParamValue = new ParamValue(){

                @Override
                public Object getValue(String string) {
                    if (string.equals("maxHiers")) {
                        return new Integer(n3);
                    }
                    if (string.equals("maxRowsDefault")) {
                        return new Integer(n4);
                    }
                    return null;
                }
            };
        }
    }

    public TemplateListHyperView getTemplateListHyperView() {
        return this.templateListHyperView;
    }

    public void refreshDataPanel() {
        this.layoutDisplay(true);
    }

    private void layoutDisplay(boolean bl) {
        this.addButton.setVisible(bl);
        this.removeButton.setVisible(bl);
        if (bl) {
            this.removeDataPanels();
            try {
                this.templateListHyperView = new TemplateListHyperView(this.templateContext, this.thcontext, bl, AVConditionPanel.class, "dimcondition.xml", this.globalParamValue);
                this.templateListHyperView.addPropertyChangeListener(this);
                this.tree = new TemplateJTree(this.templateListHyperView);
                this.tree.addTreeSelectionListener(this);
                this.treeScrollPane = new JScrollPane(this.tree);
                this.add((Component)this.treeScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AVConditionPanel.this.tree.refresh();
                    }
                });
            }
            catch (IOException | SQLException exception) {
                LOG.log(Level.SEVERE, "layoutDisplay", exception);
            }
        } else {
            this.removeDataPanels();
            this.add((Component)this.headerLabel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
            try {
                this.templateListHyperView = new TemplateListHyperView(this.templateContext, this.thcontext, bl, AVConditionPanel.class, "dimcondition.xml", this.globalParamValue);
                this.templateListHyperView.addPropertyChangeListener(this);
                JPanel jPanel = this.templateListHyperView.getPanel();
                this.add((Component)jPanel, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.5, 13, 1, new Insets(2, 2, 2, 2), 0, 0));
                jPanel.invalidate();
                jPanel.repaint();
            }
            catch (IOException | SQLException exception) {
                LOG.log(Level.SEVERE, "layoutDisplay", exception);
            }
            this.headerLabel.invalidate();
            this.headerLabel.repaint();
        }
    }

    private void removeDataPanels() {
        if (this.treeScrollPane != null) {
            this.remove(this.treeScrollPane);
            this.treeScrollPane = null;
        }
        if (this.templateListHyperView != null) {
            this.remove(this.headerLabel);
            this.remove(this.templateListHyperView.getPanel());
        }
    }

    public JButton getRunButton() {
        return this.runButton;
    }

    private void layoutComponents() {
        JToolBar jToolBar = new JToolBar();
        this.runButton = new JButton(OracleIcons.getIcon((String)"run.png"));
        jToolBar.add(this.runButton);
        this.runButton.setToolTipText(HCSArb.get("AV_DATA_VIEWER_RUN_BUTTON_TIP"));
        this.addButton = new ButtonMenu(null, OracleIcons.getIcon((String)"add.png"), null);
        this.addButton.setToolTipText(HCSArb.get("AV_DATA_VIEWER_ADD_BUTTON_TIP"));
        jToolBar.add(this.addButton);
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.get("AV_DATA_VIEWER_REMOVE_BUTTON_TIP"));
        jToolBar.add(this.removeButton);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AVConditionPanel.this.avViewerPanel.runQuery();
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 2));
        this.runButton.getActionMap().put("runAction", abstractAction);
        this.runButton.getInputMap(2).put((KeyStroke)abstractAction.getValue("AcceleratorKey"), "runAction");
        this.runButton.addActionListener(abstractAction);
        this.removeButton.addActionListener(actionEvent -> {
            Object object = this.tree.getSelectionPath().getLastPathComponent();
            if (object instanceof TemplateViewNode) {
                TemplateViewNode templateViewNode = (TemplateViewNode)object;
                TreeNode treeNode = templateViewNode.getParent();
                if (this.tree.isRoot(treeNode)) {
                    return;
                }
                BaseTemplateHyperView baseTemplateHyperView = templateViewNode.getBaseTemplateHyperView();
                if (baseTemplateHyperView != null) {
                    Object object2;
                    BaseTemplateHyperView baseTemplateHyperView2 = baseTemplateHyperView.getParentTemplateHyperView();
                    if (baseTemplateHyperView2 instanceof TemplateGroupHyperView) {
                        object2 = (TemplateGroupHyperView)baseTemplateHyperView2;
                        ((TemplateGroupHyperView)object2).removeTemplateView(baseTemplateHyperView, this.treeStyle);
                    }
                    object2 = (DefaultTreeModel)this.tree.getModel();
                    ((DefaultTreeModel)object2).removeNodeFromParent(templateViewNode);
                }
            }
        });
        this.headerLabel = new JLabel(String.format("<html><b>%s</b></html>", HCSArb.get("AV_QUERY_DIMENSION_CONDITION_LABEL")));
        this.setLayout(new GridBagLayout());
        this.add((Component)jToolBar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.layoutDisplay(true);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        boolean bl = !treeSelectionEvent.isAddedPath();
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        if (object instanceof TemplateViewNode) {
            TemplateViewNode templateViewNode = (TemplateViewNode)object;
            List<AbstractAction> list = templateViewNode.getActions();
            ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
            boolean bl2 = false;
            if (list != null) {
                for (AbstractAction abstractAction : list) {
                    Boolean bl3 = (Boolean)abstractAction.getValue("REMOVE");
                    if (bl3 == null) {
                        bl3 = false;
                    }
                    if (!bl3.booleanValue()) {
                        arrayList.add(new JMenuItem(abstractAction));
                        continue;
                    }
                    if (bl) continue;
                    bl2 = this.canRemove(templateViewNode);
                }
            }
            this.addButton.setMenuItems(arrayList);
            this.addButton.setEnabled(arrayList.size() > 0);
            this.removeButton.setEnabled(bl2);
        }
    }

    private boolean canRemove(TemplateViewNode templateViewNode) {
        TreeNode treeNode = templateViewNode.getParent();
        return this.canUnselect((TemplateViewNode)treeNode);
    }

    private boolean canUnselect(TemplateViewNode templateViewNode) {
        TreeNode treeNode = templateViewNode.getRoot();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TemplateViewNode templateViewNode2;
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (treeNode2.equals(templateViewNode) || treeNode2.getChildCount() <= 0 || !(templateViewNode2 = (TemplateViewNode)treeNode2).getBaseTemplateHyperView().isIncluded()) continue;
            return true;
        }
        return false;
    }
}

