/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.cache;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheLevelGroupNode;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupNode;
import oracle.hcs.av.model.cache.AVCacheRootNode;
import oracle.hcs.av.model.cache.AbstractAVNavigatorCacheModelNode;
import oracle.hcs.av.panels.cache.AVCacheEditorChangeManager;
import oracle.hcs.av.panels.cache.NavigatorCacheSelectionChangeHandler;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.util.ButtonMenu;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;

public class AVNavigatorCachePanel
extends JPanel
implements TreeSelectionListener,
AVCacheEditorChangeManager {
    private DBObjectProvider prov;
    private JToggleButton addButton;
    private JButton removeButton;
    private JTree cacheNavigator;
    private DefaultTreeModel cacheNavigatorModel;
    private AVCacheRootNode cacheRootNode;
    private AnalyticView analyticView;
    private NavigatorCacheSelectionChangeHandler navigationChangeHandler;
    private DefaultMutableTreeNode selectedNavigatorNode;
    private JMenuItem addLevelTupleMenuItem;
    private boolean repaintSelectedNodeProcessing = false;
    private static final String MEASURE_GROUP_CACHE = HCSArb.getString("AV_CACHE_NAVIGATOR_CACHE_MEASURE_GROUP_LABEL");
    private static final String MEASURE_GROUP = HCSArb.getString("AV_CACHE_NAVIGATOR_MEASURE_GROUP_LABEL");
    private static final String LEVELS = HCSArb.getString("AV_CACHE_NAVIGATOR_LEVELS_LABEL");
    private final int MAX_MEASURE_NAMES_TO_SHOW = 8;

    public AVNavigatorCachePanel(NavigatorCacheSelectionChangeHandler navigatorCacheSelectionChangeHandler) {
        this.navigationChangeHandler = navigatorCacheSelectionChangeHandler;
        this.layoutComponents();
    }

    public void initialisePanel(AnalyticView analyticView, DBObjectProvider dBObjectProvider) {
        this.analyticView = analyticView;
        this.prov = dBObjectProvider;
        this.cacheRootNode.removeAllChildren();
        this.cacheNavigatorModel.reload();
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups();
        for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
            Object object;
            aVCacheMeasureGroup.clearLifeCycleEditOccurred();
            AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray = aVCacheMeasureGroup.getCacheMeasureGroupMeasures();
            AVCacheLevelGroup[] aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups();
            if (aVCacheMeasureGroupMeasureArray.length == 1 && aVCacheMeasureGroupMeasureArray[0].getCacheMeasureGroupAllActive().booleanValue()) {
                aVCacheMeasureGroupMeasureArray = this.reinstateFullMeasureList();
            }
            boolean bl = false;
            if (this.analyticView.getMeasures().length == aVCacheMeasureGroupMeasureArray.length) {
                bl = true;
            }
            String string = this.getInitialEditVersionOfMeasureGroupNodeName(aVCacheMeasureGroupMeasureArray, bl);
            AVCacheMeasureGroupNode aVCacheMeasureGroupNode = new AVCacheMeasureGroupNode(analyticView, (Object)string);
            ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
            for (AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure : aVCacheMeasureGroupMeasureArray) {
                object = aVCacheMeasureGroupMeasure.getName();
                AVMeasure aVMeasure = analyticView.findMeasure((String)object);
                arrayList.add(aVMeasure);
            }
            aVCacheMeasureGroupNode.setMeasures(arrayList);
            this.cacheNavigatorModel.insertNodeInto(aVCacheMeasureGroupNode, this.cacheRootNode, this.cacheRootNode.getChildCount());
            this.cacheNavigatorModel.reload();
            for (AbstractChildDBObject abstractChildDBObject : aVCacheLevelGroupArray) {
                object = new ArrayList();
                for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : abstractChildDBObject.getCacheLevelGroupHierLevels()) {
                    object.add(aVCacheLevelGroupDimHierLevel.getName());
                }
                String string2 = this.getInitialEditVersionOfLevelGroupNodeName((List<String>)object);
                AVCacheLevelGroupNode aVCacheLevelGroupNode = new AVCacheLevelGroupNode(dBObjectProvider, string2, analyticView);
                aVCacheLevelGroupNode.setLevelTuple((List<String>)object);
                aVCacheLevelGroupNode.setLevelGroupProcessMode(abstractChildDBObject.getCacheLevelGroupProcessMode());
                this.cacheNavigatorModel.insertNodeInto(aVCacheLevelGroupNode, aVCacheMeasureGroupNode, aVCacheMeasureGroupNode.getChildCount());
                this.cacheNavigatorModel.reload();
            }
        }
        if (this.cacheRootNode.getChildCount() > 0) {
            this.setTreeExpanded();
        }
        Object[] objectArray = new Object[]{this.cacheRootNode};
        TreePath treePath = new TreePath(objectArray);
        this.cacheNavigator.setSelectionPath(treePath);
        this.cacheNavigator.repaint();
    }

    private AVCacheMeasureGroupMeasure[] reinstateFullMeasureList() {
        AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray = new AVCacheMeasureGroupMeasure[this.analyticView.getMeasures().length];
        int n = 0;
        for (AVMeasure aVMeasure : this.analyticView.getMeasures()) {
            String string = aVMeasure.getName();
            aVCacheMeasureGroupMeasureArray[n] = new AVCacheMeasureGroupMeasure(string);
            ++n;
        }
        return aVCacheMeasureGroupMeasureArray;
    }

    protected JTree getCacheNavigator() {
        return this.cacheNavigator;
    }

    @Override
    public void showObjectEditorUpdates(AbstractAVNavigatorCacheModelNode abstractAVNavigatorCacheModelNode) {
        if (abstractAVNavigatorCacheModelNode.getModelNodeType().equals("MeasureGroupNodeType")) {
            AVCacheMeasureGroupNode aVCacheMeasureGroupNode = (AVCacheMeasureGroupNode)abstractAVNavigatorCacheModelNode;
            String string = this.getUpdatedMeasureGroupNodeName(aVCacheMeasureGroupNode);
            this.selectedNavigatorNode.setUserObject(string);
        } else if (abstractAVNavigatorCacheModelNode.getModelNodeType().equals("LevelsNodeType")) {
            AVCacheLevelGroupNode aVCacheLevelGroupNode = (AVCacheLevelGroupNode)abstractAVNavigatorCacheModelNode;
            String string = this.getUpdatedLevelGroupNodeName(aVCacheLevelGroupNode);
            this.selectedNavigatorNode.setUserObject(string);
        }
        this.cacheNavigatorModel.reload();
        this.setTreeExpanded();
        this.repaintSelectedNode();
    }

    private void repaintSelectedNode() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AVNavigatorCachePanel.this.repaintSelectedNodeProcessing = true;
                Object[] objectArray = AVNavigatorCachePanel.this.selectedNavigatorNode.getPath();
                TreePath treePath = new TreePath(objectArray);
                AVNavigatorCachePanel.this.cacheNavigator.setSelectionPath(treePath);
                AVNavigatorCachePanel.this.cacheNavigator.revalidate();
                AVNavigatorCachePanel.this.cacheNavigator.repaint();
                AVNavigatorCachePanel.this.repaintSelectedNodeProcessing = false;
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void setTreeExpanded() {
        for (int i = 0; i < this.cacheNavigator.getRowCount(); ++i) {
            this.cacheNavigator.expandRow(i);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.repaintSelectedNodeProcessing) {
            return;
        }
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath != null) {
            this.selectedNavigatorNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (this.selectedNavigatorNode != null) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                String string = (String)this.selectedNavigatorNode.getUserObject();
                if (!string.equalsIgnoreCase(MEASURE_GROUP_CACHE)) {
                    this.addLevelTupleMenuItem.setEnabled(true);
                } else {
                    this.addLevelTupleMenuItem.setEnabled(false);
                }
                if (string.equalsIgnoreCase(MEASURE_GROUP_CACHE)) {
                    this.removeButton.setEnabled(false);
                } else if (string.startsWith(LEVELS)) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)this.selectedNavigatorNode.getParent();
                    if (defaultMutableTreeNode.getChildCount() == 1) {
                        this.removeButton.setEnabled(false);
                    } else {
                        this.removeButton.setEnabled(true);
                    }
                } else {
                    this.removeButton.setEnabled(true);
                }
                defaultMutableTreeNode = (AbstractAVNavigatorCacheModelNode)this.selectedNavigatorNode;
                this.navigationChangeHandler.navigatorNodeChanged((AbstractAVNavigatorCacheModelNode)defaultMutableTreeNode);
            }
        }
    }

    protected String getDefaultMeasureGroupNodeName() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MEASURE_GROUP + " - ");
        stringBuffer.append(HCSArb.getString("AV_CACHE_NAVIGATOR_ALL_MEASURES_SELECTED"));
        string = stringBuffer.toString();
        return string;
    }

    private String getInitialEditVersionOfMeasureGroupNodeName(AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray, boolean bl) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MEASURE_GROUP + " - ");
        int n = 0;
        if (bl) {
            stringBuffer.append(HCSArb.getString("AV_CACHE_NAVIGATOR_ALL_MEASURES_SELECTED"));
            string = stringBuffer.toString();
        } else {
            for (AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure : aVCacheMeasureGroupMeasureArray) {
                String string2 = this.prov.getExternalName(aVCacheMeasureGroupMeasure.getName());
                stringBuffer.append(string2 + ", ");
                if (++n == 8) break;
            }
            string = n > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 2) : MEASURE_GROUP;
        }
        return string;
    }

    private String getUpdatedMeasureGroupNodeName(AVCacheMeasureGroupNode aVCacheMeasureGroupNode) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MEASURE_GROUP + " - ");
        int n = 0;
        List<AVBaseMeasure> list = aVCacheMeasureGroupNode.getMeasures();
        if (list.size() == 1 && list.get(0).isALLMeasure().booleanValue()) {
            stringBuffer.append(HCSArb.getString("AV_CACHE_NAVIGATOR_ALL_MEASURES_SELECTED"));
            string = stringBuffer.toString();
        } else {
            for (AVBaseMeasure aVBaseMeasure : list) {
                stringBuffer.append(this.prov.getExternalName(aVBaseMeasure.getName()) + ", ");
                if (++n != 8) continue;
                break;
            }
            string = n > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 2) : MEASURE_GROUP;
        }
        return string;
    }

    private String getInitialEditVersionOfLevelGroupNodeName(List<String> list) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LEVELS + " - ");
        int n = 0;
        for (String string2 : list) {
            stringBuffer.append(AVCacheLevelGroupNode.getDimensionHierarchyAlias(string2) + ".");
            stringBuffer.append(AVCacheLevelGroupNode.getLevelName(string2) + ", ");
            ++n;
        }
        string = n > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 2) : LEVELS;
        return string;
    }

    protected String getUpdatedLevelGroupNodeName(AVCacheLevelGroupNode aVCacheLevelGroupNode) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LEVELS + " - ");
        int n = 0;
        List<String> list = aVCacheLevelGroupNode.getLevelTuple();
        for (String string2 : list) {
            stringBuffer.append(AVCacheLevelGroupNode.getDimensionHierarchyAlias(string2) + ".");
            stringBuffer.append(AVCacheLevelGroupNode.getLevelName(string2) + ", ");
            ++n;
        }
        string = n > 0 ? stringBuffer.toString().substring(0, stringBuffer.length() - 2) : LEVELS;
        return string;
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(HCSArb.getString("AV_CACHE_NAVIGATOR_HEADER_LABEL")), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        this.add((Component)this.getAddRemoveButtonPanel(), gridBagConstraints);
        this.cacheRootNode = new AVCacheRootNode(MEASURE_GROUP_CACHE);
        this.cacheNavigatorModel = new DefaultTreeModel(this.cacheRootNode);
        this.cacheNavigator = new JTree(this.cacheNavigatorModel);
        this.cacheNavigator.setCellRenderer(new MyTreeCellRenderer());
        Object[] objectArray = new Object[]{this.cacheRootNode};
        TreePath treePath = new TreePath(objectArray);
        this.cacheNavigator.setSelectionPath(treePath);
        this.cacheNavigator.addTreeSelectionListener(this);
        JPanel jPanel = this.getCacheNavigatorTreePanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    private JPanel getAddRemoveButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        JMenuItem jMenuItem = new JMenuItem(HCSArb.getString("AV_CACHE_NAVIGATOR_MENU_ADD_MEASURE_GROUP"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = AVNavigatorCachePanel.this.cacheNavigator.getSelectionPath();
                TreePath treePath2 = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    AVCacheMeasureGroupNode aVCacheMeasureGroupNode = new AVCacheMeasureGroupNode(AVNavigatorCachePanel.this.analyticView, (Object)AVNavigatorCachePanel.this.getDefaultMeasureGroupNodeName());
                    AVNavigatorCachePanel.this.cacheNavigatorModel.insertNodeInto(aVCacheMeasureGroupNode, AVNavigatorCachePanel.this.cacheRootNode, AVNavigatorCachePanel.this.cacheRootNode.getChildCount());
                    AVNavigatorCachePanel.this.cacheNavigatorModel.reload();
                    Object[] objectArray = new Object[]{AVNavigatorCachePanel.this.cacheRootNode, aVCacheMeasureGroupNode};
                    treePath2 = new TreePath(objectArray);
                    AVNavigatorCachePanel.this.setTreeExpanded();
                    if (treePath2 != null) {
                        AVNavigatorCachePanel.this.setNewSelectedNode(treePath2);
                    }
                    treePath = AVNavigatorCachePanel.this.cacheNavigator.getSelectionPath();
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    AVCacheLevelGroupNode aVCacheLevelGroupNode = new AVCacheLevelGroupNode(AVNavigatorCachePanel.this.prov, LEVELS, AVNavigatorCachePanel.this.analyticView);
                    String string = AVNavigatorCachePanel.this.getUpdatedLevelGroupNodeName(aVCacheLevelGroupNode);
                    aVCacheLevelGroupNode.setUserObject(string);
                    AVNavigatorCachePanel.this.cacheNavigatorModel.insertNodeInto(aVCacheLevelGroupNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    AVNavigatorCachePanel.this.cacheNavigatorModel.reload();
                    AVNavigatorCachePanel.this.setTreeExpanded();
                    if (treePath2 != null) {
                        AVNavigatorCachePanel.this.setNewSelectedNode(treePath2);
                    }
                }
            }
        });
        arrayList.add(jMenuItem);
        this.addLevelTupleMenuItem = new JMenuItem(HCSArb.getString("AV_CACHE_NAVIGATOR_MENU_ADD_LEVEL_TUPLE"));
        this.addLevelTupleMenuItem.setEnabled(false);
        this.addLevelTupleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = AVNavigatorCachePanel.this.cacheNavigator.getSelectionPath();
                TreePath treePath2 = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    String string = (String)defaultMutableTreeNode.getUserObject();
                    if (string.startsWith(MEASURE_GROUP)) {
                        AVCacheLevelGroupNode aVCacheLevelGroupNode = new AVCacheLevelGroupNode(AVNavigatorCachePanel.this.prov, LEVELS, AVNavigatorCachePanel.this.analyticView);
                        String string2 = AVNavigatorCachePanel.this.getUpdatedLevelGroupNodeName(aVCacheLevelGroupNode);
                        aVCacheLevelGroupNode.setUserObject(string2);
                        AVNavigatorCachePanel.this.cacheNavigatorModel.insertNodeInto(aVCacheLevelGroupNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                        AVNavigatorCachePanel.this.cacheNavigatorModel.reload();
                        Object[] objectArray = new Object[]{AVNavigatorCachePanel.this.cacheRootNode, defaultMutableTreeNode, aVCacheLevelGroupNode};
                        treePath2 = new TreePath(objectArray);
                        AVNavigatorCachePanel.this.setTreeExpanded();
                        if (treePath2 != null) {
                            AVNavigatorCachePanel.this.setNewSelectedNode(treePath2);
                        }
                    } else if (string.startsWith(LEVELS)) {
                        AVCacheLevelGroupNode aVCacheLevelGroupNode = new AVCacheLevelGroupNode(AVNavigatorCachePanel.this.prov, LEVELS, AVNavigatorCachePanel.this.analyticView);
                        String string3 = AVNavigatorCachePanel.this.getUpdatedLevelGroupNodeName(aVCacheLevelGroupNode);
                        aVCacheLevelGroupNode.setUserObject(string3);
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        AVNavigatorCachePanel.this.cacheNavigatorModel.insertNodeInto(aVCacheLevelGroupNode, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                        AVNavigatorCachePanel.this.cacheNavigatorModel.reload();
                        Object[] objectArray = new Object[]{AVNavigatorCachePanel.this.cacheRootNode, defaultMutableTreeNode2, aVCacheLevelGroupNode};
                        treePath2 = new TreePath(objectArray);
                        AVNavigatorCachePanel.this.setTreeExpanded();
                        if (treePath2 != null) {
                            AVNavigatorCachePanel.this.setNewSelectedNode(treePath2);
                        }
                    }
                }
            }
        });
        arrayList.add(this.addLevelTupleMenuItem);
        this.addButton = ButtonMenu.createButtonMenu(null, OracleIcons.getIcon((String)"add.png"), arrayList);
        this.addButton.setToolTipText(HCSArb.getString("AV_CACHE_NAVIGATOR_ADD_BUTTON_TOOLTIP"));
        this.removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setToolTipText(HCSArb.getString("AV_CACHE_NAVIGATOR_REMOVE_BUTTON_TOOLTIP"));
        this.removeButton.setEnabled(false);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add(Box.createRigidArea(new Dimension(5, 16)), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreePath treePath = AVNavigatorCachePanel.this.cacheNavigator.getSelectionPath();
                TreePath treePath2 = null;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode != null) {
                    String string = (String)defaultMutableTreeNode.getUserObject();
                    if (!string.equalsIgnoreCase(MEASURE_GROUP_CACHE)) {
                        if (defaultMutableTreeNode.getNextSibling() != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode.getNextSibling();
                            treePath2 = new TreePath(defaultMutableTreeNode2.getPath());
                        } else if (defaultMutableTreeNode.getPreviousSibling() != null) {
                            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode.getPreviousSibling();
                            treePath2 = new TreePath(defaultMutableTreeNode3.getPath());
                        } else {
                            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                            treePath2 = new TreePath(defaultMutableTreeNode4.getPath());
                        }
                        AVNavigatorCachePanel.this.cacheNavigatorModel.removeNodeFromParent(defaultMutableTreeNode);
                        AVNavigatorCachePanel.this.cacheNavigatorModel.reload();
                    }
                    AVNavigatorCachePanel.this.setTreeExpanded();
                    if (treePath2 != null) {
                        AVNavigatorCachePanel.this.setNewSelectedNode(treePath2);
                    }
                }
            }
        });
        return jPanel;
    }

    private void setNewSelectedNode(TreePath treePath) {
        this.cacheNavigator.setSelectionPath(treePath);
        this.cacheNavigator.repaint();
    }

    private JPanel getCacheNavigatorTreePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.cacheNavigator, gridBagConstraints);
        return jPanel;
    }

    protected class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon folderIcon = HCSNavigatorResource.getIcon("AV_CACHE_MEASURE_GROUP_ICON");

        protected MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            AbstractAVNavigatorCacheModelNode abstractAVNavigatorCacheModelNode = (AbstractAVNavigatorCacheModelNode)object;
            if (!abstractAVNavigatorCacheModelNode.getModelNodeType().startsWith(LEVELS)) {
                this.setIcon(this.folderIcon);
            }
            return this;
        }
    }
}

