/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.aggregation;

import java.io.Reader;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.tree.TreeNode;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSpec;
import oracle.hcs.syntaxbuilder.spec.FilterIterator;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.templatedialog.TemplateHelper;
import oracle.hcs.templates.templatedialog.TemplateHelperFactory;
import oracle.hcs.templates.templatedialog.TemplateHelperFactoryImpl;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateGroup;
import oracle.hcs.util.ErrorDisplay;
import oracle.hcs.util.FetchIcon;
import oracle.hcs.util.Resources;

public class HCSAggregationSpec
extends HCSSpec {
    private static final String CONTEXT = "cube";
    private Properties props;
    private FetchIcon fetchIcon;

    public HCSAggregationSpec(Properties properties, Reader reader, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, ErrorDisplay errorDisplay, Resources resources, FetchIcon fetchIcon, Connection connection) {
        super(properties, reader, syntaxParser, templateHelperFactory, errorDisplay, resources, fetchIcon, connection);
        this.props = properties;
        this.fetchIcon = fetchIcon;
    }

    @Override
    protected void processTemplates(SpecTreeNode specTreeNode, List<Template> list, TemplateGroup templateGroup) {
        if (templateGroup != null && templateGroup.getContext() != null && templateGroup.getContext().equalsIgnoreCase(CONTEXT) && templateGroup.isContainer()) {
            TemplateHelperFactoryImpl templateHelperFactoryImpl = (TemplateHelperFactoryImpl)this.getTemplateHelperFactory();
            HCSSchema hCSSchema = templateHelperFactoryImpl.getSchema();
            String string = this.props.getProperty("CUBE");
            AnalyticView analyticView = hCSSchema.findAV(string);
            for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                for (Template template : new FilterIterator<Template>(list, this.getTemplateFilter())) {
                    String string2 = template.getMenu().replace("{dimension}", aVDimensionality.getName());
                    SpecTreeNode specTreeNode2 = new SpecTreeNode(string2, template.getExpression(), template.getType(), true, template.getDoc(), this.fetchIcon.getIcon(template.getIcon()));
                    if (this.getTemplateHelperFactory() != null) {
                        this.props.setProperty("DIMENSION", aVDimensionality.getName());
                        TemplateHelper templateHelper = this.getTemplateHelperFactory().getInstance("DIMENSION", template, templateGroup);
                        if (templateHelper != null) {
                            specTreeNode2.setTemplateHelper(templateHelper);
                            this.addHelper(specTreeNode2);
                        }
                    }
                    specTreeNode.add(specTreeNode2);
                    if (template.isButton()) {
                        this.getButtonNodes().add(specTreeNode2);
                    }
                    if (!template.isDefault()) continue;
                    this.setDefaultSelection(specTreeNode2);
                }
            }
        } else {
            super.processTemplates(specTreeNode, list, templateGroup);
        }
    }

    @Override
    public SpecTreeNode findMatchingNode(ParseNode parseNode) {
        this.setCheckNameTrue(parseNode);
        return super.findMatchingNode(parseNode);
    }

    private void setCheckNameTrue(ParseNode parseNode) {
        if (parseNode.getChildren().isEmpty()) {
            String string = parseNode.getType();
            if (string.equalsIgnoreCase("dimension")) {
                parseNode.setCheckName(true);
            }
        } else {
            List<TreeNode> list = parseNode.getChildren();
            for (TreeNode treeNode : list) {
                this.setCheckNameTrue((ParseNode)treeNode);
            }
        }
    }
}

