/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.HCSArb;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.util.SelectionNode;
import oracle.javatools.db.DBObjectProvider;

public class AttributeDimensionNode
implements SelectionNode {
    private List<Object> children;
    private AttributeDimension dimension;
    private String schemaName;
    private boolean isRoot;
    private DBObjectProvider prov;

    public AttributeDimensionNode() {
        this(null, null, "");
    }

    public AttributeDimensionNode(DBObjectProvider dBObjectProvider, AttributeDimension attributeDimension, String string) {
        this.prov = dBObjectProvider;
        this.dimension = attributeDimension;
        this.schemaName = string;
        this.children = new ArrayList<Object>();
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public void setIsRoot(boolean bl) {
        this.isRoot = bl;
    }

    public AttributeDimensionNode addHierarchyDimensionNode(String string) {
        AttributeDimensionNode attributeDimensionNode = new AttributeDimensionNode(this.prov, null, string);
        this.children.add(attributeDimensionNode);
        return attributeDimensionNode;
    }

    public void addHierarchyDimensionNode(AttributeDimension attributeDimension) {
        AttributeDimensionNode attributeDimensionNode = new AttributeDimensionNode(this.prov, attributeDimension, attributeDimension.getSchema().getName());
        this.children.add(attributeDimensionNode);
    }

    public String getName() {
        String string = "";
        if (this.dimension != null) {
            string = this.dimension.getName();
            if (this.prov != null) {
                string = this.prov.getExternalName(string);
            }
        }
        return string;
    }

    public String getDescription() {
        if (this.dimension != null) {
            return this.dimension.getDescription();
        }
        return "";
    }

    protected Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    public boolean isParent() {
        return this.children.size() > 0;
    }

    @Override
    public boolean isRoot() {
        return this.isRoot;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String toString() {
        if (this.dimension != null) {
            return this.dimension.getName();
        }
        if (this.schemaName != null && !this.schemaName.equalsIgnoreCase("")) {
            return HCSArb.format("ATTRIBUTE_DIMENSION_NODE_SCHEMA_LABEL", this.schemaName);
        }
        return "";
    }

    public void clearChildren() {
        this.children.clear();
    }
}

