/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import oracle.hcs.av.panels.HierarchyNode;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.util.TreeSelectionRenderer;

public class AVHierarchiesTreeRenderer
extends TreeSelectionRenderer {
    private int visibleRow;
    private Icon m_dimensionIcon = HCSNavigatorResource.getIcon("DIMENSION_ICON");
    private Icon m_hierarchyIcon = HCSNavigatorResource.getIcon("HIERARCHY_ICON");
    private HCSSchema schema;

    public void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        HierarchyNode hierarchyNode = (HierarchyNode)object;
        if (hierarchyNode.isRoot() || hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.DIMENSION_NODE)) {
            this.setIcon(this.m_dimensionIcon);
        } else if (hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.HIERARCHY_NODE)) {
            if (this.schema != null) {
                String string = hierarchyNode.getHierarchyName();
                Hierarchy hierarchy = this.schema.findHierarchy(string);
                boolean bl5 = false;
                if (hierarchy != null) {
                    bl5 = hierarchy.isValid();
                }
                if (!bl5) {
                    Icon icon = HCSNavigatorResource.getIcon("NAMECONFLICTERROR");
                    this.setIcon(icon);
                } else {
                    this.setIcon(this.m_hierarchyIcon);
                }
            } else {
                this.setIcon(this.m_hierarchyIcon);
            }
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.visibleRow = n;
        return this;
    }
}

