/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.aggregation.AggregationBuilder;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntaxbuilder.SyntaxBuilderPanel;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVAggregationPanel
extends BaseEditorPanel<AnalyticView> {
    private static final Logger LOG = Logger.getLogger(AVAggregationPanel.class.getName());
    protected static final int USE_BUILDER = 2;
    protected SyntaxBuilderPanel syntaxBuilder;
    private AggregationBuilder aggBuilder;

    public AVAggregationPanel() {
        this.setLayout(new GridBagLayout());
        int n = this.getBuilderSetting();
        if (n == 2) {
            this.aggBuilder = new AggregationBuilder();
            try {
                this.syntaxBuilder = this.aggBuilder.createBuilder();
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error instantiating AggregationBuilder", exception);
            }
        }
        this.layoutComponents(0);
    }

    protected int getBuilderSetting() {
        return 2;
    }

    protected void initialisePanel() {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        int n = this.getBuilderSetting();
        if (n == 2) {
            Object object = this.getDataContext().get("dimensions");
            this.aggBuilder.initialize(oracleDatabaseImpl, analyticView, object);
            this.syntaxBuilder.setEnabled(false);
            this.syntaxBuilder.setBottomMarginEnabled(true);
        }
    }

    protected void commitPanel() throws TraversalException {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        AnalyticView analyticView2 = (AnalyticView)this.getOriginalObject();
        String string = null;
        String string2 = null;
        if (analyticView2 != null) {
            string2 = analyticView2.getConsistentSolveSpec();
        }
        string = this.getConsistentSolveSpec(string2);
        analyticView.setConsistentSolveSpec(string);
    }

    protected String getConsistentSolveSpec(String string) throws TraversalException {
        Object object;
        int n = this.getBuilderSetting();
        String string2 = null;
        if (n == 2 && (object = this.syntaxBuilder.getSyntax()) != null && ((String)object).trim().length() > 0) {
            string2 = object;
        }
        if (string != null) {
            object = SyntaxObject.fromSyntax(String.format("AGGREGATE BY %s", string), null);
            SyntaxObject syntaxObject = SyntaxObject.fromSyntax(String.format("AGGREGATE BY %s", string2), null);
            if (((SyntaxObject)object).toSyntax().equals(syntaxObject.toSyntax())) {
                string2 = string;
            }
        }
        return string2;
    }

    protected void layoutComponents(int n) {
        int n2 = this.getBuilderSetting();
        JLabel jLabel = new JLabel(HCSArb.get("AGGREGATION_RULES_DESC"));
        jLabel.setName("aggOperatorLabel");
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)jLabel, "consistentSolveSpec");
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (n2 == 2) {
            this.add(this.syntaxBuilder, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        }
    }
}

