/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.calcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcs.NewCalcMeasurePanel;
import oracle.hcs.av.model.AnalyticView;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBObjectProvider;

public class NewCalculatedMeasureDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private NewCalcMeasurePanel calcMeasPanel;
    private DBObjectProvider provider;

    public NewCalculatedMeasureDialog(AnalyticView analyticView, DBObjectProvider dBObjectProvider) {
        super((Frame)Ide.getMainWindow(), HCSArb.getString("CALC_MEASURE_CREATE_DIALOG_TITLE"), true);
        this.provider = dBObjectProvider;
        this.init(analyticView);
    }

    private void init(AnalyticView analyticView) {
        this.setMinimumSize(new Dimension(410, 245));
        this.setLayout(new BorderLayout());
        this.calcMeasPanel = new NewCalcMeasurePanel(analyticView, this.provider);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.calcMeasPanel, "av_create_calc_measure");
        this.add((Component)this.calcMeasPanel, "North");
        JButton jButton = new JButton(HCSArb.get("DIALOG_OK_BUTTON_TEXT"));
        jButton.setName("btnOK");
        jButton.setActionCommand("OK_ID");
        jButton.addActionListener(this);
        jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_OK_BUTTON_TEXT")));
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        JButton jButton2 = new JButton(HCSArb.get("DIALOG_CANCEL_BUTTON_TEXT"));
        jButton2.setName("btnCancel");
        jButton2.setActionCommand("CANCEL_ID");
        jButton2.addActionListener(this);
        jButton2.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        JButton jButton3 = new JButton(StringUtils.stripMnemonic((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        jButton3.setName("btnHelp");
        jButton3.setActionCommand("HELP_ID");
        jButton3.addActionListener(this);
        jButton3.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("DIALOG_HELP_BUTTON_TEXT")));
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.setBorder((Border)new EmptyBorder(10, 4, 5, 5));
        dialogButtonBar.add((Component)jButton3, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)jButton2, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)dialogButtonBar, "South");
        this.registerKeyboardActions();
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.calcMeasPanel.validateMeasureName()) {
                this.isOK = true;
                this.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.isOK = false;
            this.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.calcMeasPanel);
        }
    }

    public String getMeasureName() {
        return this.calcMeasPanel.getMeasureName();
    }

    public String getDescription() {
        return this.calcMeasPanel.getDescription();
    }

    public String getCaption() {
        return this.calcMeasPanel.getCaption();
    }

    public String getMeasureFormat() {
        return this.calcMeasPanel.getMeasureFormat();
    }

    public boolean isOKSelected() {
        return this.isOK;
    }
}

