/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.db.AttributeDimensionList;
import oracle.hcs.db.HierarchyList;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AttributeDimensionListRunnable
extends BaseRunnable {
    private OracleDatabaseImpl db;
    private HCSSchema schema;
    private List<AttributeDimension> dimensions;
    private List<Hierarchy> hierarchies;
    private boolean isGetAVHierarchies;
    private String dimensionName;

    public AttributeDimensionListRunnable(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema) {
        this(oracleDatabaseImpl, hCSSchema, true);
    }

    public AttributeDimensionListRunnable(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema, boolean bl) {
        this(oracleDatabaseImpl, hCSSchema, bl, null);
    }

    public AttributeDimensionListRunnable(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema, boolean bl, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = hCSSchema;
        this.dimensions = new ArrayList<AttributeDimension>();
        this.isGetAVHierarchies = bl;
        this.dimensionName = string;
    }

    @Override
    public void run() {
        try {
            AttributeDimensionList attributeDimensionList = new AttributeDimensionList(this.db, this.schema, this.dimensionName);
            this.dimensions = attributeDimensionList.getHierarchyDimensions();
            HierarchyList hierarchyList = new HierarchyList(this.db, this.schema);
            if (this.isGetAVHierarchies) {
                this.hierarchies = hierarchyList.getHierarchies();
            }
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }

    public List<AttributeDimension> getAttributeDimensions() {
        return this.dimensions;
    }

    public List<Hierarchy> getAVHierarchies() {
        return this.hierarchies;
    }
}

