/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.DBObjectProvider;

public abstract class XMLQueryBasedActionHelper
implements AlterHCSObjectHelper {
    private DBObject dbObject;
    private DBObjectProvider dbProvider;
    private Logger Log = Logger.getLogger(XMLQueryBasedActionHelper.class.getName());
    private Queries queries;
    private static final String XMLFILE = "actionsQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";

    public XMLQueryBasedActionHelper() {
    }

    public XMLQueryBasedActionHelper(DBObject dBObject) {
        this.dbObject = dBObject;
        this.dbProvider = dBObject.getDatabase();
    }

    protected String getQueryName() {
        return "";
    }

    protected DBObject getDBObject() {
        return this.dbObject;
    }

    protected DBObjectProvider getProvider() {
        return this.dbProvider;
    }

    protected String getXMLFile() {
        return XMLFILE;
    }

    protected String getPackageName() {
        return QUERIES_PACKAGE;
    }

    protected String getQuery(String string) {
        if (this.queries == null) {
            try {
                String string2 = this.getPackageName();
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), this.getXMLFile());
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                this.Log.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return this.queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        this.queries = queries;
    }

    @Override
    public String getSQL() {
        String string = this.dbObject.getSchemaName();
        String string2 = this.dbObject.getObjectName();
        String string3 = this.dbObject.getObjectType();
        String string4 = String.format(this.getQuery(this.getQueryName()), string3, string, string2);
        return string4;
    }

    @Override
    public void commitChanges() throws Exception {
        String string = this.getSQL();
        if (string != null && string != "") {
            Connection connection = this.dbObject.getConnection();
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.execute(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }
}

