/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyObjectsPropertiesAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmModifyObjectsPropertiesPanel;
import oracle.hcs.actions.DescriptionParentObjects;
import oracle.hcs.actions.ModifyObjectsPropertiesHelper;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.panels.HCSObjectDependenciesGenerator;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class ModifyAttributeDimensionsPropertiesAction
extends AbstractModifyObjectsPropertiesAction {
    private final String DIFF_PROPERTY = "dimensions";
    private static final String ATTRIBUTE_DIMENSION_TYPE = "ATTRIBUTE DIMENSION";
    private Map<String, List<Descriptions>> attributesDescObjectsMap;
    private Map<String, List<Descriptions>> levelsDescObjectsMap;
    private static final String HELP_ID = "obj_properties";

    @Override
    protected Map<String, DescriptionParentObjects> createOriginalAndUpdatedTopDescObjects() {
        HashMap<String, DescriptionParentObjects> hashMap = new HashMap<String, DescriptionParentObjects>();
        for (DBObject dBObject : this.getSelection()) {
            DescriptionParentObjects descriptionParentObjects = new DescriptionParentObjects();
            AttributeDimension attributeDimension = this.getSchema().findDimension(dBObject.getObjectName());
            this.initForceCreateOption(attributeDimension);
            AttributeDimension attributeDimension2 = (AttributeDimension)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)attributeDimension);
            descriptionParentObjects.setOriginalDescParentObj(attributeDimension);
            descriptionParentObjects.setUpdatedDescParentObj(attributeDimension2);
            hashMap.put(dBObject.getObjectName(), descriptionParentObjects);
        }
        return hashMap;
    }

    @Override
    protected void initChildrenDescriptionObjects() {
        this.initDimensionAttributes();
        this.initDimensionLevels();
    }

    private void initDimensionAttributes() {
        this.attributesDescObjectsMap = new HashMap<String, List<Descriptions>>();
        ArrayList<DimensionAttribute> arrayList = new ArrayList<DimensionAttribute>();
        for (String string : this.getOriginalAndUpdatedTopDescObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getOriginalAndUpdatedTopDescObjects().get(string);
            AttributeDimension attributeDimension = (AttributeDimension)descriptionParentObjects.getUpdatedDescParentObj();
            for (DimensionAttribute dimensionAttribute : attributeDimension.getAttributes()) {
                if (this.attributesDescObjectsMap.containsKey(string)) {
                    this.attributesDescObjectsMap.get(string).add(dimensionAttribute);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(dimensionAttribute);
                this.attributesDescObjectsMap.put(attributeDimension.getName(), arrayList);
            }
        }
    }

    private void initDimensionLevels() {
        this.levelsDescObjectsMap = new HashMap<String, List<Descriptions>>();
        ArrayList<DimensionLevel> arrayList = new ArrayList<DimensionLevel>();
        for (String string : this.getOriginalAndUpdatedTopDescObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getOriginalAndUpdatedTopDescObjects().get(string);
            AttributeDimension attributeDimension = (AttributeDimension)descriptionParentObjects.getUpdatedDescParentObj();
            for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
                if (this.levelsDescObjectsMap.containsKey(string)) {
                    this.levelsDescObjectsMap.get(string).add(dimensionLevel);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(dimensionLevel);
                this.levelsDescObjectsMap.put(attributeDimension.getName(), arrayList);
            }
        }
    }

    @Override
    protected AlterHCSObjectHelper createModifyObjectsPropertiesHelper() {
        return new ModifyObjectsPropertiesHelper(this.getSchema(), this.getOriginalAndUpdatedTopDescObjects(), this.getDatabase(), this.getDiffProperty(), HCSSyntaxType.DIMENSION){

            @Override
            public String getTitle() {
                return HCSArb.get("MODIFY_ATTR_DIMENSION_PROPERTIES_TITLE");
            }

            @Override
            protected void setOriginalDescParentObjects(Map<String, DescriptionParentObjects> map) {
                for (String string : map.keySet()) {
                    DescriptionParentObjects descriptionParentObjects = map.get(string);
                    AttributeDimension attributeDimension = (AttributeDimension)descriptionParentObjects.getOriginalDescParentObj();
                    descriptionParentObjects.setOriginalDescParentObj((Descriptions)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)attributeDimension));
                }
            }

            @Override
            protected List<AbstractSchemaObjectWithDesc> getCompileDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
                return HCSObjectDependenciesGenerator.getDimensionDependencies(string, oracleDatabaseImpl, string2);
            }
        };
    }

    @Override
    protected String getParentDescObjectName() {
        return null;
    }

    @Override
    protected Icon getTopObjectIcon() {
        return HCSNavigatorResource.getIcon("DIMENSION_ICON");
    }

    @Override
    protected String getTableTitle() {
        if (this.getSelection().size() == 1) {
            return HCSArb.get("MODIFY_ATTR_DIMENSION_TABLE_TITLE_LABEL");
        }
        return HCSArb.get("MODIFY_ATTR_DIMENSIONS_TABLE_TITLE_LABEL");
    }

    @Override
    protected String getDiffProperty() {
        return "dimensions";
    }

    @Override
    protected String getParentObjectType() {
        return ATTRIBUTE_DIMENSION_TYPE;
    }

    @Override
    protected String getProgressMessage() {
        return HCSArb.get("MODIFY_OBJS_PROPS_ATTR_DIMS_PROGRESS_MSSG");
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        return new ConfirmModifyObjectsPropertiesPanel(this.getParentDescObjects(), this.getProvider(), this.tableTitle, this.getObjectTypesForView()){

            @Override
            protected Icon getRendererIcon(String string) {
                if (string.equals(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_ATTRIBUTES_VIEW"))) {
                    return HCSNavigatorResource.getIcon("ATTRIBUTE_ICON");
                }
                if (string.equals(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_LEVELS_VIEW"))) {
                    return HCSNavigatorResource.getIcon("LEVEL_ICON");
                }
                return ModifyAttributeDimensionsPropertiesAction.this.getTopObjectIcon();
            }

            @Override
            protected Map<String, List<Descriptions>> getDescObjectsToPopulateModel(String string) {
                if (string.equals(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_ATTRIBUTES_VIEW"))) {
                    return ModifyAttributeDimensionsPropertiesAction.this.attributesDescObjectsMap;
                }
                if (string.equals(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_LEVELS_VIEW"))) {
                    return ModifyAttributeDimensionsPropertiesAction.this.levelsDescObjectsMap;
                }
                return ModifyAttributeDimensionsPropertiesAction.this.getParentDescObjects();
            }
        };
    }

    @Override
    protected List<String> getObjectTypesForView() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getSelection().size() == 1) {
            arrayList.add(HCSArb.get("MODIFY_ATTR_DIMENSION_PROPS_DIM_VIEW"));
        } else {
            arrayList.add(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_DIMS_VIEW"));
        }
        arrayList.add(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_ATTRIBUTES_VIEW"));
        arrayList.add(HCSArb.get("MODIFY_ATTR_DIMENSIONS_PROPS_LEVELS_VIEW"));
        return arrayList;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }
}

