/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.privs.PrivAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.ide.help.HelpSystem;

public class HCSPrivAction
extends PrivAction {
    private static final String GRANT_ALL = "grantAll";
    private static final String REVOKE_ALL = "revokeAll";
    private static final String USERS = "users";
    private static final String OBJECT = "object";
    private static final String WITH_GRANT = "withGrant";
    private static final String SCHEMA = "schema";
    private static final String SHUTTLE = "shuttle";
    private static final String ADDED = "added";
    private static final String REMOVED = "removed";
    private static final String SELECTED = "selected";
    private static final String TRUE = "true";
    private Connection connection;
    private String op;

    private void loadArgs() {
        String string = this.getArgs();
        String[] stringArray = string.split(",");
        this.op = stringArray[0];
    }

    private Operation getOperation() {
        try {
            Operation operation = Operation.valueOf(this.op);
            return operation;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected List<ActionControl> getCustomControls(Connection connection) {
        this.connection = connection;
        this.loadArgs();
        return null;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getOperation() == Operation.GRANT) {
            stringBuilder.append(this.getCustomSql(values));
        }
        if (this.getOperation() == Operation.REVOKE) {
            stringBuilder.append(this.getCustomSql(values));
        }
        return stringBuilder.toString();
    }

    protected String getCustomSql(ActionDialog.Values values) {
        Operation operation = this.getOperation();
        if (operation == Operation.GRANT) {
            return this.getGrantCommands(values);
        }
        if (operation == Operation.REVOKE) {
            return this.getRevokeCommands(values);
        }
        return "";
    }

    private String getGrantCommands(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = values.getList(SHUTTLE, ADDED);
        boolean bl = values.get(GRANT_ALL) != null && values.get(GRANT_ALL).equals(TRUE);
        String string = this.getDbObjectType();
        if (values.getList(SHUTTLE, ADDED).size() > 0 || bl) {
            stringBuilder.append("grant ");
            if (bl) {
                stringBuilder.append("all ");
            } else {
                for (String string2 : list) {
                    stringBuilder.append(string2 + ", ");
                }
                if (stringBuilder.lastIndexOf(",") > -1) {
                    stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
                }
            }
            Object object = null;
            object = string.equalsIgnoreCase("ATTRIBUTE DIMENSION") ? String.format("on attribute dimension \"%s\".\"%s\" to \"%s\"", values.get(SCHEMA), this.getDBObjectName(), values.get(USERS)) : String.format("on \"%s\".\"%s\" to \"%s\"", values.get(SCHEMA), this.getDBObjectName(), values.get(USERS));
            if (values.get(WITH_GRANT).equals(TRUE)) {
                object = (String)object + " with grant option";
            }
            stringBuilder.append((String)object);
            stringBuilder.append(";\r");
        }
        if (stringBuilder.toString() == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    private String getRevokeCommands(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        List list = values.getList(SHUTTLE, SELECTED);
        boolean bl = values.get(REVOKE_ALL) != null && values.get(REVOKE_ALL).equals(TRUE);
        String string = this.getDbObjectType();
        if (values.getList(SHUTTLE, ADDED).size() > 0 || bl) {
            stringBuilder.append("revoke ");
            if (bl) {
                stringBuilder.append("all ");
            } else {
                for (String string2 : list) {
                    stringBuilder.append(string2 + ", ");
                }
                if (stringBuilder.lastIndexOf(",") > -1) {
                    stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
                }
            }
            Object object = null;
            object = string.equalsIgnoreCase("ATTRIBUTE DIMENSION") ? String.format("on attribute dimension \"%s\".\"%s\" from \"%s\"", values.get(SCHEMA), this.getDBObjectName(), values.get(USERS)) : String.format("on \"%s\".\"%s\" from \"%s\"", values.get(SCHEMA), this.getDBObjectName(), values.get(USERS));
            stringBuilder.append((String)object);
            stringBuilder.append(";\r");
        }
        if (stringBuilder.toString() == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    protected void initializeValues(JEWTDialog jEWTDialog) {
        int n = jEWTDialog.getButtonMask();
        jEWTDialog.setButtonMask(n |= 4);
        String string = this.getDbObjectType();
        Operation operation = this.getOperation();
        String string2 = null;
        if (operation == Operation.GRANT) {
            if (string.equalsIgnoreCase("HIERARCHY")) {
                string2 = "av_perform_grant_action";
            } else if (string.equalsIgnoreCase("ATTRIBUTE DIMENSION")) {
                string2 = "av_perform_grant_action";
            } else if (string.equalsIgnoreCase("ANALYTIC VIEW")) {
                string2 = "av_perform_grant_action";
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string2);
        } else if (operation == Operation.REVOKE) {
            if (string.equalsIgnoreCase("HIERARCHY")) {
                string2 = "av_perform_revoke_action";
            } else if (string.equalsIgnoreCase("ATTRIBUTE DIMENSION")) {
                string2 = "av_perform_revoke_action";
            } else if (string.equalsIgnoreCase("ANALYTIC VIEW")) {
                string2 = "av_perform_revoke_action";
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)jEWTDialog.getContent(), string2);
        }
    }

    private static enum Operation {
        GRANT,
        REVOKE;

    }
}

