/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmDropMeasurePanel;
import oracle.hcs.actions.DropCalcMeasureAction;
import oracle.hcs.actions.DropMeasuresHelper;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.CalcReferences;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;

public class DropCalculatedMeasuresAction
extends DropCalcMeasureAction {
    private HCSSchema schema = null;
    private List<DBObject> selection;
    private String analyticViewName;
    private AnalyticView analyticView;
    private List<AVBaseMeasure> measures;
    private static final String HELP_ID = "av_drop_measures";
    private String owner;

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        ConfirmDropMeasurePanel confirmDropMeasurePanel = null;
        if (this.measures != null && this.actionHelper != null) {
            confirmDropMeasurePanel = new ConfirmDropMeasurePanel(this.measures, (List)this.actionHelper.getDependencies(), this.owner);
        }
        return confirmDropMeasurePanel;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    @Override
    protected void actionPostProcess() {
        for (AVBaseMeasure aVBaseMeasure : this.measures) {
            String string = String.format("%s.%s", this.analyticViewName, aVBaseMeasure.getName());
            this.closeEditorForDroppedObjects(string);
        }
        this.refreshNavigator(this.selection.get(0), this.analyticViewName);
    }

    public void setSelection(List<DBObject> list) {
        this.selection = list;
    }

    @Override
    protected AlterHCSObjectHelper getHelper() {
        Database database = null;
        this.initMeasureSelection();
        DBObject dBObject = this.selection.get(0);
        database = dBObject.getDatabase();
        this.actionHelper = this.measures != null ? new DropMultipleMeasuresHelper(this.schema, this.analyticView, this.measures, database) : null;
        return this.actionHelper;
    }

    private void initMeasureSelection() {
        this.measures = new ArrayList<AVBaseMeasure>();
        if (this.selection != null && this.selection.size() > 0) {
            this.schema = this.getSchema();
            for (DBObject dBObject : this.selection) {
                this.owner = dBObject.getSchemaName();
                if (!(dBObject.getNode() instanceof CalculatedMeasureNode)) continue;
                CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)dBObject.getNode();
                this.analyticViewName = calculatedMeasureNode.getAVName();
                this.analyticView = this.schema.findAV(this.analyticViewName);
                String string = calculatedMeasureNode.getMeasureName();
                AVCalculatedMeasure aVCalculatedMeasure = this.analyticView.findCalculatedMeasure(string);
                if (aVCalculatedMeasure == null) continue;
                this.measures.add(aVCalculatedMeasure);
            }
        }
    }

    private class DropMultipleMeasuresHelper
    extends DropMeasuresHelper {
        private final List<AVBaseMeasure> measures;

        public DropMultipleMeasuresHelper(HCSSchema hCSSchema, AnalyticView analyticView, List<AVBaseMeasure> list, Database database) {
            super(database, hCSSchema);
            this.analyticViewName = analyticView.getName();
            this.measures = list;
            AnalyticView analyticView2 = (AnalyticView)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)analyticView);
            this.setOriginalAv(analyticView);
            this.setUpdatedAv(analyticView2);
            this.initParser(this.analyticViewName);
            this.setDatabase(database);
            this.setChangedMeasures(new ArrayList<String>());
        }

        @Override
        public String getTitle() {
            return HCSArb.get("DROP_MULTIPLE_CALCULATED_MEASURES_TITLE");
        }

        @Override
        protected void doRemoveMeasures() {
            for (AVBaseMeasure aVBaseMeasure : this.measures) {
                AVCalculatedMeasure aVCalculatedMeasure = this.getUpdatedAv().findCalculatedMeasure(aVBaseMeasure.getName());
                this.processObjectChanges(aVCalculatedMeasure);
                this.getUpdatedAv().removeBaseMeasure(aVCalculatedMeasure);
            }
            this.removeDependencies();
        }

        @Override
        public Object getDependencies() {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
                for (AVBaseMeasure aVBaseMeasure : this.measures) {
                    String string = aVBaseMeasure.getName();
                    List<AVBaseMeasure> list = CalcReferences.getDependencies(this.getSchema(), this.analyticViewName, string, this.getParser());
                    for (AVBaseMeasure aVBaseMeasure2 : list) {
                        if (arrayList.contains(aVBaseMeasure2)) continue;
                        arrayList.add(aVBaseMeasure2);
                    }
                }
                this.dependencies = arrayList;
            }
            return this.dependencies;
        }
    }
}

