/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorMultiTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.ddl.DbmsMetadataDDLGenerator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.thirdparty.copy.CopyToOracle;
import oracle.dbtools.thirdparty.copy.DDLGeneratorTask;
import oracle.dbtools.thirdparty.copy.ElementDbObject;
import oracle.ide.model.Element;

public class CopyToOracleOracle
extends CopyToOracle {
    private static String NL = "\n";
    private StringBuilder preScript = new StringBuilder();
    private StringBuilder postScript = new StringBuilder();
    private boolean initDDL = false;
    private DbmsMetadataDDLGenerator generator;
    private ScriptRunnerContext context;
    private DDLTypes _ddlTypes;

    @Override
    public String quoteMe(String string) {
        return string;
    }

    @Override
    public boolean isSupportedType(String string) {
        if (this._ddlTypes == null) {
            this._ddlTypes = new DDLTypes();
            this._ddlTypes.setSynonymn(false);
            this._ddlTypes.setShowSynonymn(false);
        }
        return this._ddlTypes.isSupportedType(string);
    }

    private boolean checkObjectExists(ElementDbObject elementDbObject, DBUtil dBUtil) {
        boolean bl = false;
        String string = "select table_name from user_tables where table_name = :TABLE_NAME";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TABLE_NAME", elementDbObject.getObjectName());
        String string2 = dBUtil.executeOracleReturnOneCol(string, hashMap);
        if (string2 != null) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected String getPreScript(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Element[] elementArray) {
        String string2;
        switch (string2 = new ElementDbObject(elementArray[0], this).getObjectType()) {
            case "TABLE": {
                return this.getTablePreScript(string, bl, bl2, bl3, bl4, elementArray);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTablePreScript(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Element[] elementArray) {
        DBObject dBObject = new DBObject(elementArray[0]);
        Connection connection = dBObject.getConnection();
        Connections.getInstance().lock(connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        try {
            String string3 = ConnectionResolver.getQualifiedConnectionName((String)this.getTargetConnection().getShortName());
            StringBuffer stringBuffer = new StringBuffer();
            RaptorMultiTask raptorMultiTask = new RaptorMultiTask("Generating DDL", IRaptorTaskRunMode.TASKVIEWER);
            for (Element element : elementArray) {
                ElementDbObject elementDbObject = new ElementDbObject(element, this);
                boolean bl5 = false;
                if (bl3 || bl4 || !bl5) {
                    arrayList.add(elementDbObject.getObjectName());
                    if (bl4) {
                        if (bl5) {
                            stringBuffer.append(MessageFormat.format("drop table {0} cascade constraints;\n", elementDbObject.getObjectName()));
                        }
                        raptorMultiTask.addTask((RaptorTask)this.createDDLGeneratorTask(element, bl3, bl4, bl5));
                        continue;
                    }
                    raptorMultiTask.addTask((RaptorTask)this.createDDLGeneratorTask(element, bl3, bl4, bl5));
                    continue;
                }
                System.out.println(MessageFormat.format("Skipping this table {0} as it exists in {1}", elementDbObject.getObjectName(), this.getTargetConnection()));
                this.preScript.append(MessageFormat.format("REM Skipping this table {0} as it exists in {1}", elementDbObject.getObjectName(), this.getTargetConnection()));
            }
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorMultiTask);
            raptorMultiTask.getResult();
            this.preScript = this.preScript.append(stringBuffer.toString());
            string2 = this.generateTableString(arrayList);
            if (arrayList.size() > 0) {
                String string4 = ConnectionResolver.getConnection((String)string3).getMetaData().getUserName();
                this.preScript.append("begin" + NL);
                this.preScript.append("  for cur in (select owner, constraint_name , table_name" + NL);
                this.preScript.append("    from all_constraints" + NL);
                this.preScript.append("     where owner = '");
                this.preScript.append(string4);
                this.preScript.append("' and" + NL);
                this.preScript.append("           TABLE_NAME IN (" + string2 + ") AND CONSTRAINT_TYPE='R' ORDER by CONSTRAINT_TYPE DESC" + NL);
                this.preScript.append("    ) loop" + NL);
                this.preScript.append("     execute immediate 'ALTER TABLE '||cur.owner||'.'||cur.table_name||' MODIFY CONSTRAINT \"'|| cur.constraint_name ||'\" DISABLE ';" + NL);
                this.preScript.append("  end loop;" + NL);
                this.preScript.append("end;" + NL);
                this.preScript.append("/" + NL);
                this.postScript.append("begin" + NL);
                this.postScript.append("  for cur in (select owner, constraint_name , table_name" + NL);
                this.postScript.append("    from all_constraints" + NL);
                this.postScript.append("     where owner = '" + string4 + "' and" + NL);
                this.postScript.append("           TABLE_NAME IN (" + string2 + ") AND CONSTRAINT_TYPE='R'" + NL);
                this.postScript.append("    ) loop" + NL);
                this.postScript.append("     execute immediate 'ALTER TABLE '||cur.owner||'.'||cur.table_name||' MODIFY CONSTRAINT \"'|| cur.constraint_name ||'\" DISABLE ';" + NL);
                this.postScript.append("  end loop;" + NL);
                this.postScript.append("end;" + NL);
                this.postScript.append("/" + NL);
            }
            System.out.println("----------------------");
            System.out.println(this.preScript.toString());
            System.out.println("----------------------");
            System.out.println(this.postScript.toString());
            System.out.println("----------------------");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
        return this.preScript.toString();
    }

    private DDLGeneratorTask createDDLGeneratorTask(Element element, boolean bl, boolean bl2, boolean bl3) {
        final DDLGeneratorTask dDLGeneratorTask = new DDLGeneratorTask(element, this);
        RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                CopyToOracleOracle.this.preScript.append(dDLGeneratorTask.getDDL());
            }
        };
        dDLGeneratorTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        return dDLGeneratorTask;
    }

    private String generateTableString(ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("'" + iterator.next() + "'");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getPostScript(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Element[] elementArray) {
        if (this.postScript.length() > 0) {
            return this.postScript.toString();
        }
        return null;
    }
}

