/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.models.ExtractConnectionAccess;
import oracle.dbtools.extract.models.ExtractConnectionAccessCatalog;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.ddl.DDLTypesHelper;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.thirdparty.copy.ConnectionNames;
import oracle.dbtools.thirdparty.copy.Copy2OracleCopyApi;
import oracle.dbtools.thirdparty.copy.CopyToOracle;
import oracle.dbtools.thirdparty.copy.CopyToOracleAccessTable;
import oracle.dbtools.thirdparty.copy.CopyToOracleDB2;
import oracle.dbtools.thirdparty.copy.CopyToOracleLog;
import oracle.dbtools.thirdparty.copy.CopyToOracleMongoDB;
import oracle.dbtools.thirdparty.copy.CopyToOracleMySQL;
import oracle.dbtools.thirdparty.copy.CopyToOraclePostgreSQL;
import oracle.dbtools.thirdparty.copy.CopyToOracleResources;
import oracle.dbtools.thirdparty.copy.CopyToOracleSPostgreSQL;
import oracle.dbtools.thirdparty.copy.CopyToOracleSQLServer;
import oracle.dbtools.thirdparty.copy.CopyToOracleSybase;
import oracle.dbtools.thirdparty.copy.CopyToOracleTeradata;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;

public class CopyToOracleDropHelper
implements DropHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CANNOT_DROP_MSG = CopyToOracleResources.getString("CANNOT_DROP") + LINE_SEPARATOR + LINE_SEPARATOR;
    private CopyToOracleLog _log;
    private String _destConnUser;

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        return true;
    }

    private String getConnectionQualName(Element element) {
        String string = null;
        try {
            if (!(element instanceof DatabaseConnection)) {
                DBObject dBObject = new DBObject(element);
                return dBObject == null ? null : dBObject.getConnectionName();
            }
            DatabaseConnection databaseConnection = (DatabaseConnection)element;
            string = databaseConnection.getQualifiedConnectionName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        Element[] elementArray;
        String string;
        Object object3;
        Object object4;
        DBObject dBObject;
        Object object5;
        Context context;
        Element element = DBObjectNodeUtil.getTreeNodeElement((Object)object);
        String string2 = this.getConnectionQualName(element);
        DatabaseConnection databaseConnection = null;
        try {
            if (string2 != null) {
                databaseConnection = DatabaseConnection.findConnectionNode((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string2));
                context = ObjectFactoryRegistry.getDatabaseNavigatorRegistry().getFactory(string2, (Connection)databaseConnection.getConnection());
                this._destConnUser = context.getSchema();
            }
            if (databaseConnection == null || !Connections.getInstance().isOracle((Connection)databaseConnection.getConnection())) {
                return false;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
        context = Context.newIdeContext();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NavigatorTreeNode navigatorTreeNode = null;
        try {
            object5 = RaptorDnD.getTransferableNodes((Transferable[])transferableArray);
            dBObject = object5.iterator();
            while (dBObject.hasNext()) {
                object4 = dBObject.next();
                if (object4 instanceof MultiTransferable) {
                    navigatorTreeNode = (NavigatorTreeNode)((MultiTransferable)object4).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
                } else if (object4 instanceof DefaultMutableTreeNode) {
                    navigatorTreeNode = (NavigatorTreeNode)object4;
                }
                if ((object3 = navigatorTreeNode.getElement()) == null) continue;
                arrayList.add((Element)object3);
            }
        }
        catch (Exception exception) {
            Logger.severe(this.getClass(), (Throwable)exception);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        object5 = databaseConnection.getConnectionName();
        dBObject = new DBObject((Element)arrayList.get(arrayList.size() - 1));
        object4 = new DBObject(element);
        object3 = null;
        try {
            string = this.getConnectionQualName(DBObjectNodeUtil.getTreeNodeElement(RaptorDnD.getTransferableNodes((Transferable[])transferableArray).get(0)));
            elementArray = Connections.getInstance().getDatabase(string);
            String string3 = elementArray.getDatabaseType();
            if (string2.equals(string) && dBObject.getObjectType().equals(object4.getObjectType()) && dBObject.getSchemaName().equals(object4.getSchemaName()) && (dBObject.getObjectName() == null ? object4.getObjectName() == null : object4.getObjectName() != null && dBObject.getObjectName().equals(object4.getObjectName()))) {
                return true;
            }
            if (string3.equals("Generic JDBC")) {
                string3 = elementArray.getConnection().getMetaData().getDatabaseProductName();
            }
            if ((object3 = this.getCopyToOracle(string, string3)) == null) {
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.format("NO_BRIDGE", Connections.getDisplayName((String)string), string3));
                return true;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
        if (element instanceof SchemaFolder) {
            string = new MessageDetailsDialog();
            string.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("NO_OTHER_USER"));
            return true;
        }
        if (object4.getObjectType() != "CONNECTION" && object4.getSchemaName() != null && !object4.getSchemaName().equals(this._destConnUser)) {
            string = new MessageDetailsDialog();
            string.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("NO_OTHER_USER"));
            return true;
        }
        string = new ObjectAction();
        string.setReloadParent(false);
        string.setReload(false);
        ((CopyToOracle)((Object)object3)).setTargetConnection(new ConnectionNames((String)object5, databaseConnection.getQualifiedConnectionName()));
        object3.setObjectAction((ObjectAction)string);
        elementArray = new Element[arrayList.size()];
        int n2 = 0;
        boolean bl = false;
        for (Object object22 : arrayList) {
            elementArray[n2++] = (Element)object22;
            dBObject = new DBObject((Element)object22);
            if (!this.validateType(dBObject, (CopyToOracle)((Object)object3))) {
                return true;
            }
            if (bl) continue;
            bl = "TABLE".equals(dBObject.getObjectType()) || dBObject.getObjectFolderType().equals("TABLE");
        }
        ExtractListModel extractListModel = ((CopyToOracle)((Object)object3)).getListModel(elementArray);
        ExtractConnectionAccessCatalog extractConnectionAccessCatalog = new ExtractConnectionAccessCatalog(extractListModel.getList(0));
        for (ExtractConnectionAccess extractConnectionAccess : extractConnectionAccessCatalog.getExtractConnectionAccessCatalog()) {
            if (!Connections.getInstance().isOracle(extractConnectionAccess.getConnection()) && extractConnectionAccessCatalog.size() != 1) {
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SINGLE_ACCESS"));
                return true;
            }
            if (this.validateDbConnections(extractConnectionAccess, element, databaseConnection, (CopyToOracle)((Object)object3))) continue;
            return true;
        }
        context.setSelection(elementArray);
        context.setBoolean("CONTAINS_DATA_OBJECT", bl);
        context.setProperty("CONNECTION_SCHEMA_CAT", (Object)extractConnectionAccessCatalog);
        context.setProperty("IS_DNS", (Object)true);
        this._log = new CopyToOracleLog();
        this._log.openLog();
        object3.setContext(context);
        ((CopyToOracle)((Object)object3)).launch();
        this._log.closeLog();
        return true;
    }

    private CopyToOracle getCopyToOracle(String string, String string2) {
        try {
            if (string2 == null) {
                return new CopyToOracleSQLServer();
            }
            if (string2.toLowerCase().startsWith("oracle")) {
                return new Copy2OracleCopyApi();
            }
            if (string2.toLowerCase().startsWith("mysql")) {
                return new CopyToOracleMySQL();
            }
            if (string2.toLowerCase().startsWith("sybase")) {
                return new CopyToOracleSybase();
            }
            if (string2.toLowerCase().startsWith("sqlserver")) {
                return new CopyToOracleSQLServer();
            }
            if (string2.toLowerCase().startsWith("postgresql")) {
                return new CopyToOraclePostgreSQL();
            }
            if (string2.toLowerCase().startsWith("sdpostgres")) {
                return new CopyToOracleSPostgreSQL();
            }
            if (string2.toLowerCase().startsWith("access")) {
                return new CopyToOracleAccessTable();
            }
            if (string2.toLowerCase().startsWith("db2")) {
                return new CopyToOracleDB2();
            }
            if (string2.toLowerCase().startsWith("mongo")) {
                return new CopyToOracleMongoDB();
            }
            if (string2.toLowerCase().startsWith("teradata")) {
                return new CopyToOracleTeradata();
            }
            return null;
        }
        catch (Exception exception) {
            return new CopyToOracleSQLServer();
        }
    }

    public float getWeight() {
        return 10.0f;
    }

    private boolean validateDbConnections(ExtractConnectionAccess extractConnectionAccess, Element element, DatabaseConnection databaseConnection, CopyToOracle copyToOracle) {
        try {
            String string;
            String string2;
            String string3 = extractConnectionAccess.getConnection().getMetaData().getURL();
            String string4 = ((Connection)databaseConnection.getConnection()).getMetaData().getURL();
            String string5 = extractConnectionAccess.getConnectionName();
            String string6 = this.getConnectionQualName(element);
            String string7 = extractConnectionAccess.getSchemaName().replace("\"", "");
            String string8 = "select SYS_CONTEXT ('USERENV', 'SERVER_HOST')||'.'||SYS_CONTEXT ('USERENV', 'DB_DOMAIN')||':'||SYS_CONTEXT ('USERENV', 'DB_UNIQUE_NAME') from dual";
            if (string3.indexOf("@") != -1) {
                string3 = string3.substring(string3.indexOf("@") + 1, string3.length());
            }
            if (string4.indexOf("@") != -1) {
                string4 = string4.substring(string4.indexOf("@") + 1, string4.length());
            }
            if (copyToOracle.getSchemaName() != null) {
                this._destConnUser = copyToOracle.getSchemaName();
            }
            String string9 = "Source Connection :" + string3 + " : " + string7;
            String string10 = "Target Connection :" + string4 + " : " + this._destConnUser;
            String string11 = string9 + LINE_SEPARATOR + string10 + LINE_SEPARATOR;
            if (string6.equals(string5) && this._destConnUser.equals(string7)) {
                if (copyToOracle.getSchemaName() == null) {
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SAME_CONNECTION"), string11);
                    return false;
                }
                if (copyToOracle.getSchemaName().equals(string7)) {
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SAME_CONNECTION"), string11);
                    return false;
                }
            }
            if (string3.equals(string4)) {
                if (string7.equals(this._destConnUser)) {
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SAME_CONNECTION"), string11);
                    return false;
                }
                if (copyToOracle.getSchemaName() != null && copyToOracle.getSchemaName().equals(string7)) {
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SAME_CONNECTION"), string11);
                    return false;
                }
            }
            if (string7.equals(this._destConnUser) && (string2 = DBUtil.getInstance((Connection)extractConnectionAccess.getConnection()).executeReturnOneCol(string8)).equals(string = DBUtil.getInstance((Connection)((Connection)databaseConnection.getConnection())).executeReturnOneCol(string8))) {
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.getString("SAME_CONNECTION"), string11);
                return false;
            }
            if (!Connections.getInstance().isOracle(extractConnectionAccess.getConnection())) {
                return true;
            }
            string2 = RaptorVersionTracker.getDbVersion((Connection)Connections.getInstance().getConnection(string5));
            if (string2.compareTo((Version)(string = RaptorVersionTracker.getDbVersion((Connection)((Connection)databaseConnection.getConnection())))) > 0) {
                Object[] objectArray = new Object[]{Connections.getDisplayName((String)string5), string2.toCanonicalString(), Connections.getDisplayName((String)string6), string.toCanonicalString()};
                String string12 = CopyToOracleResources.format("DATABASE_COMPATIBILITY", objectArray);
                MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                return messageDetailsDialog.confirmWarning(string12, string11);
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return true;
    }

    private boolean validateType(DBObject dBObject, CopyToOracle copyToOracle) {
        if (!copyToOracle.isSupportedType(dBObject.getObjectType())) {
            MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
            messageDetailsDialog.showErrorDialog(CANNOT_DROP_MSG + CopyToOracleResources.format("OBJTYPE_NOT_SUPPORTED", dBObject.getElement() instanceof ObjectFolder ? DDLTypesHelper.getFolderLabel((String)dBObject.getObjectType()) : dBObject.getObjectType()));
            return false;
        }
        return true;
    }
}

