/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.access;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.ODBCConnectionCreator;

public class AccessConnectionCreator
extends ODBCConnectionCreator {
    public static final String ODBC_DRIVER_CLASS = "sun.jdbc.odbc.JdbcOdbcDriver";
    public static final String SUBTYPE_ODBC_BRIDGE = "ODBCBridge";

    public Connection getConnection(Properties properties) throws SQLException {
        Connection connection;
        block17: {
            Serializable serializable;
            String string;
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            if (!this.hasLength(string3) && !this.allowNullPassword()) {
                throw new SQLException(this.getBundle().getString("ERROR_MISSING_PASS"), "");
            }
            String string4 = properties.getProperty("driver");
            if (!this.hasLength(string4)) {
                string4 = this.getDriverClassName(properties);
            }
            if (!this.hasLength(string = properties.getProperty("customUrl"))) {
                string = this.getConnectionURL(properties);
            }
            Driver driver = null;
            try {
                serializable = Class.forName(string4, true, null).asSubclass(Driver.class);
                driver = ((Class)serializable).newInstance();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(this.getBundle().getString("ERROR_DRIVER_CLASS_NOT_FOUND"));
            }
            catch (Throwable throwable) {
                SQLException sQLException = new SQLException(throwable.getLocalizedMessage());
                sQLException.initCause(throwable);
                throw sQLException;
            }
            serializable = new Properties();
            String string5 = properties.getProperty("role");
            if (this.hasLength(string5)) {
                ((Properties)serializable).put("internal_logon", string5);
            }
            if (this.hasLength(string2)) {
                ((Properties)serializable).put("user", string2);
            }
            if (this.hasLength(string3)) {
                ((Properties)serializable).put("password", string3);
            }
            this.setCustomProperties(properties, (Properties)serializable);
            connection = null;
            try {
                try {
                    connection = driver.connect(string, (Properties)serializable);
                }
                catch (Exception exception) {
                    if (((Properties)serializable).containsKey("access.alternate.url")) {
                        string = ((Properties)serializable).getProperty("access.alternate.url");
                        connection = driver.connect(string, (Properties)serializable);
                        break block17;
                    }
                    throw new SQLException(exception);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new SQLException(unsatisfiedLinkError.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!(driver instanceof OracleDriver)) break block17;
                throw new SQLException(this.getBundle().getString("ERROR_UNSUPPORTED_ORACLE_VERSION"));
            }
        }
        if (connection == null) {
            throw new SQLException(this.getBundle().getString("ERROR_INVALID_URL"));
        }
        return connection;
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        String[] stringArray;
        super.setCustomProperties(properties, properties2);
        for (String string : stringArray = new String[]{"access.alternate.url"}) {
            String string2 = null;
            string2 = properties.getProperty(string);
            if (string2 == null) continue;
            properties2.setProperty(string, string2);
        }
    }
}

