/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class OrderByObject
extends AbstractSQLFragment {
    public static final String TYPE = "ORDER BY";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";
    public static final String NULLS_FIRST = "NULLS FIRST";
    public static final String NULLS_LAST = "NULLS LAST";

    public OrderByObject() {
    }

    public OrderByObject(SQLFragment sQLFragment) {
        this.setExpression(sQLFragment);
    }

    public OrderByObject(SQLFragment sQLFragment, String string) {
        this.setExpression(sQLFragment);
        this.setOrder(string);
    }

    public OrderByObject(SQLFragment sQLFragment, String string, String string2) {
        this.setExpression(sQLFragment);
        this.setOrder(string);
        this.setNullOrdering(string2);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getOrder() {
        return (String)this.getProperty("order");
    }

    public void setOrder(String string) {
        if (ModelUtil.hasLength((String)string) && !string.equalsIgnoreCase(ASC) && !string.equalsIgnoreCase(DESC)) {
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_ORDERING", string));
        }
        this.setProperty("order", string);
    }

    public String getNullOrdering() {
        return (String)this.getProperty("nullOrdering");
    }

    public void setNullOrdering(String string) {
        if (ModelUtil.hasLength((String)string)) {
            string = string.replaceAll("\\s+", " ");
        }
        if (ModelUtil.hasLength((String)string) && !string.equalsIgnoreCase(NULLS_FIRST) && !string.equalsIgnoreCase(NULLS_LAST)) {
            throw new IllegalArgumentException(APIBundle.format("SQL_INVALID_NULL_ORDERING", string));
        }
        this.setProperty("nullOrdering", string);
    }

    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment sQLFragment) {
        this.setProperty("expression", sQLFragment);
    }

    @Override
    public String getSQLText() {
        SQLFragment sQLFragment = this.getExpression();
        String string = this.getOrder();
        String string2 = this.getNullOrdering();
        return this.getTextOrNull(sQLFragment) + (String)(string == null ? "" : " " + string) + (String)(string2 == null ? "" : " " + string2);
    }
}

