/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.sql.AbstractAliasFragment;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.db.sql.XMLFunctionUsage;

public class FromObject
extends AbstractAliasFragment {
    public static final String TYPE = "FROM";

    public FromObject() {
    }

    public FromObject(SQLFragment sQLFragment, String string) {
        super(sQLFragment, string);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setExpression(SQLFragment sQLFragment) {
        if (!(sQLFragment == null || sQLFragment instanceof SimpleSQLFragment || sQLFragment instanceof RelationUsage || sQLFragment instanceof SynonymUsage || sQLFragment instanceof SQLQuery || sQLFragment instanceof JoinObject || sQLFragment instanceof Function || sQLFragment instanceof XMLFunctionUsage || sQLFragment instanceof WithClauseUsage)) {
            throw new IllegalArgumentException("FromObject expression " + sQLFragment + " must be a RelationUsage, SQLQuery or JoinObject.");
        }
        super.setExpression(sQLFragment);
    }

    public void setPivotExpression(SQLFragment sQLFragment) {
        this.setProperty("pivotExpression", sQLFragment);
    }

    public SQLFragment getPivotExpression() {
        return (SQLFragment)this.getProperty("pivotExpression");
    }

    @Override
    public boolean canHaveAlias() {
        return !(this.getExpression() instanceof JoinObject);
    }

    public void setWith(boolean bl) {
        this.setProperty("with", bl);
    }

    public boolean isWith() {
        return (Boolean)this.getProperty("with", Boolean.FALSE);
    }

    public void setSubqueryFactoringClause(SQLFragment sQLFragment) {
        this.setProperty("subqueryFactoringClause", sQLFragment);
    }

    public SQLFragment getSubqueryFactoringClause() {
        SQLFragment sQLFragment = (SQLFragment)this.getProperty("subqueryFactoringClause");
        return sQLFragment;
    }

    @Override
    public String getSQLText() {
        String string;
        String string2 = "";
        SQLFragment sQLFragment = this.getPivotExpression();
        SQLFragment sQLFragment2 = this.getExpression();
        String string3 = this.getAlias();
        if (this.isWith()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3).append(" ").append("AS").append(" ");
            stringBuilder.append(this.getTextOrNull(sQLFragment2));
            string = stringBuilder.toString();
        } else if (sQLFragment2 == null) {
            string = string3;
        } else if (sQLFragment == null) {
            string = super.getSQLText();
        } else {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            SQLFragment sQLFragment3 = this.getExpression();
            boolean bl2 = bl = !(sQLFragment3 instanceof RelationUsage);
            if (bl) {
                stringBuilder.append("(");
            }
            stringBuilder.append("\n");
            stringBuilder.append(this.getExpression().getSQLText());
            stringBuilder.append("\n");
            if (bl) {
                stringBuilder.append(")");
            }
            string2 = sQLFragment.getSQLText();
            stringBuilder.append(" ").append(string2);
            if (this.getAlias() != null) {
                stringBuilder.append(" ").append(this.getAlias());
            }
            string = stringBuilder.toString();
        }
        return string;
    }
}

