/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.WhereObject;

public class FKUsage
extends AbstractProviderUsageSQLFragment
implements DBObjectUsage {
    public FKUsage() {
    }

    public FKUsage(DBObjectID dBObjectID, DBObjectID dBObjectID2, DBObjectID dBObjectID3) {
        this.setObjectID(dBObjectID);
        this.setLeftFromObjectID(dBObjectID2);
        this.setRightFromObjectID(dBObjectID3);
    }

    @Override
    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    @Override
    public void setObjectID(DBObjectID dBObjectID) {
        this.setProperty("objectID", dBObjectID);
    }

    @Deprecated
    @Transient
    public FromObject getLeftFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setLeftFromObject(FromObject fromObject) {
        this.setLeftFromObjectID(fromObject != null ? fromObject.getID() : null);
    }

    public DBObjectID getLeftFromObjectID() {
        return (DBObjectID)this.getProperty("leftFromObjectID");
    }

    public void setLeftFromObjectID(DBObjectID dBObjectID) {
        this.setProperty("leftFromObjectID", dBObjectID);
    }

    public DBObjectID getRightFromObjectID() {
        return (DBObjectID)this.getProperty("rightFromObjectID");
    }

    public void setRightFromObjectID(DBObjectID dBObjectID) {
        this.setProperty("rightFromObjectID", dBObjectID);
    }

    @Deprecated
    @Transient
    public FromObject getRightFromObject() {
        return null;
    }

    @Deprecated
    @Transient
    public void setRightFromObject(FromObject fromObject) {
        this.setRightFromObjectID(fromObject != null ? fromObject.getID() : null);
    }

    public FromObject resolveLeftFromObject() {
        return this.resolveFromObject(this.getLeftFromObjectID());
    }

    public FromObject resolveRightFromObject() {
        return this.resolveFromObject(this.getRightFromObjectID());
    }

    private FromObject resolveFromObject(DBObjectID dBObjectID) {
        FromObject fromObject = null;
        try {
            if (dBObjectID != null) {
                fromObject = (FromObject)dBObjectID.resolveID();
            }
        }
        catch (DBException dBException) {
            DBLog.getLogger(this).warning(dBException.getMessage());
        }
        return fromObject;
    }

    @Override
    public String getSQLText() {
        StringBuilder stringBuilder = new StringBuilder();
        DBObjectID dBObjectID = this.getObjectID();
        if (dBObjectID != null) {
            try {
                DBObjectID[] dBObjectIDArray;
                DBObjectID[] dBObjectIDArray2;
                DBObjectID dBObjectID2;
                FKConstraint fKConstraint = (FKConstraint)dBObjectID.resolveID();
                FromObject fromObject = this.resolveLeftFromObject();
                FromObject fromObject2 = this.resolveRightFromObject();
                if (fKConstraint == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve id " + dBObjectID);
                }
                if (fromObject == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve left from id " + this.getLeftFromObjectID());
                }
                if (fromObject2 == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve right from id " + this.getRightFromObjectID());
                }
                DBObjectID dBObjectID3 = fKConstraint.getReferenceID();
                UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID3.resolveID();
                if (uniqueConstraint == null) {
                    DBLog.getLogger(this).fine("FKUsage: Cannot resolve referenced id " + dBObjectID + " on fk " + fKConstraint.getName());
                }
                DBObjectID dBObjectID4 = uniqueConstraint.getRelation().getID();
                SQLFragment sQLFragment = fromObject.getExpression();
                DBObjectID dBObjectID5 = dBObjectID2 = sQLFragment instanceof RelationUsage ? ((RelationUsage)sQLFragment).getObjectID() : null;
                if (dBObjectID2 != null && dBObjectID4 != null && dBObjectID2.equals(dBObjectID4)) {
                    dBObjectIDArray2 = uniqueConstraint.getColumnIDs();
                    dBObjectIDArray = fKConstraint.getColumnIDs();
                } else {
                    dBObjectIDArray2 = fKConstraint.getColumnIDs();
                    dBObjectIDArray = uniqueConstraint.getColumnIDs();
                }
                for (int i = 0; i < dBObjectIDArray2.length; ++i) {
                    stringBuilder.append(fromObject.getUsableAlias());
                    stringBuilder.append(".");
                    String string = DBUtil.getDBObjectName(dBObjectIDArray2[i]);
                    string = this.getExternalName(string, "COLUMN");
                    stringBuilder.append(string);
                    stringBuilder.append(" ");
                    stringBuilder.append(Comparison.Comparator.EQUAL.getSQLText());
                    stringBuilder.append(" ");
                    stringBuilder.append(fromObject2.getUsableAlias());
                    stringBuilder.append(".");
                    String string2 = DBUtil.getDBObjectName(dBObjectIDArray[i]);
                    string2 = this.getExternalName(string2, "COLUMN");
                    stringBuilder.append(string2);
                    if (i >= dBObjectIDArray2.length - 1) continue;
                    stringBuilder.append(" ");
                    stringBuilder.append(WhereObject.WhereOperator.AND.getSQLText());
                    stringBuilder.append(" ");
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
        } else {
            stringBuilder.append(dBObjectID);
        }
        return stringBuilder.toString();
    }
}

