/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectID;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ProviderUsage;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.plsql.PlSqlDatatype;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractAliasFragment;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.AbstractProviderUsageSQLFragment;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.AliasInUseException;
import oracle.javatools.db.sql.AmbiguousColumnException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.IDException;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.PlSqlUsage;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentFactory;
import oracle.javatools.db.sql.SQLFragmentUtils;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryCancelledException;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WithClauseUsage;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.db.util.SynchronizedBuildCache;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSQLQueryBuilder
extends DerivedPropertyBuilder<SQLQuery>
implements SQLQueryBuilder {
    protected static final SQLFragment[] EMPTY_ARRAY = AbstractSQLFragment.EMPTY_ARRAY;
    private static final Iterator<String> s_tsKeyGen = DBUtil.getTimestampKeyGenerator(SQLQueryBuilder.class.getSimpleName());
    private static final SynchronizedBuildCache<SQLQuery> s_currentQueries = new SynchronizedBuildCache();
    private SQLQuery m_query;
    private QueryCache m_cache;
    private Schema m_defaultSchema;
    private Collection<SQLQueryClauseException> m_clauseErrors;
    private final List<SQLFragmentFactory> m_sqlFragFactories = new ArrayList<SQLFragmentFactory>();
    private Collection<? extends SystemObject> m_extraObjects;

    protected AbstractSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema) {
        super((AbstractDBObjectProvider)dBObjectProvider, "SQLQuery");
        this.m_defaultSchema = schema;
    }

    @Override
    protected final Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected final Schema getDefaultSchema() {
        return this.m_defaultSchema;
    }

    final void setDefaultSchema(Schema schema) {
        this.m_defaultSchema = schema;
    }

    protected final SQLQuery getQuery() {
        return this.m_query;
    }

    private synchronized QueryCache getCache() {
        if (this.m_cache == null && this.m_query != null && this.m_query.isDeclarative()) {
            this.m_cache = new QueryCache();
            this.loadQuery();
        }
        if (this.m_cache == null) {
            throw new IllegalStateException("You cannot query the cache if the query hasn't been succesfully built.");
        }
        return this.m_cache;
    }

    protected void checkCancelled() throws SQLQueryCancelledException {
        if (this.m_query != null && this.isCurrentBuildCancelled(this.m_query) || Thread.currentThread().isInterrupted()) {
            throw new SQLQueryCancelledException(this.m_query);
        }
    }

    @Override
    protected boolean canCacheBuildFailure(SQLQuery sQLQuery, String string) {
        return false;
    }

    @Override
    public final void buildQuery(String string) throws SQLQueryException {
        this.buildQuery(string, null);
    }

    @Override
    public final void buildQuery(String string, SQLQueryOwner sQLQueryOwner) throws SQLQueryException {
        SQLQuery sQLQuery = new SQLQuery(string);
        sQLQuery.setParent(sQLQueryOwner);
        this.buildQuery(sQLQuery);
    }

    protected final void setSQLQuery(SQLQuery sQLQuery) {
        if (this.m_query != null && this.m_query != sQLQuery) {
            throw new IllegalStateException("The query we are building cannot be changed");
        }
        this.m_query = sQLQuery;
    }

    private void buildQuery(String string, SQLQuery sQLQuery, SQLQueryOwner sQLQueryOwner) throws SQLQueryException {
        long l = System.currentTimeMillis();
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        String string2 = "buildQuery." + s_tsKeyGen.next();
        this.m_clauseErrors = new ArrayList<SQLQueryClauseException>();
        boolean bl = false;
        try {
            DBUtil.suspendTimestampChecking(abstractDBObjectProvider, string2);
            this.setSQLQuery(sQLQuery);
            this.m_cache = new QueryCache();
            this.notifyBuildStart();
            sQLQuery.setQueryString(string);
            Collection<String> collection = this.getDerivedProperties("queryString");
            for (String charSequence : collection) {
                sQLQuery.setProperty(charSequence, null);
            }
            sQLQuery.setDeclarative(true);
            this.buildQueryImpl(string, sQLQuery, sQLQueryOwner);
            this.markAsBuilt(sQLQuery, collection.toArray(new String[collection.size()]));
            bl = true;
        }
        catch (SQLQueryCancelledException sQLQueryCancelledException) {
            throw sQLQueryCancelledException;
        }
        catch (SQLQueryException sQLQueryException) {
            this.checkCancelled();
            throw sQLQueryException;
        }
        finally {
            sQLQuery.setQueryString(string);
            sQLQuery.setDeclarative(bl);
            this.ensureNames(sQLQuery);
            if (sQLQueryOwner != null && sQLQueryOwner.getID() instanceof BaseObjectID) {
                abstractDBObjectProvider.getObjectFactory().ensureID(sQLQuery, true, true);
            }
            this.notifyBuildEnd();
            DBUtil.resumeTimestampChecking(abstractDBObjectProvider, string2);
            long l2 = System.currentTimeMillis() - l;
            if (this.getLogger().isLoggable(Level.FINER) && l2 > 10L) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("buildQuery took: ");
                stringBuilder.append(Long.toString(l2));
                stringBuilder.append(" ms.");
                this.getLogger().exiting("oracle.javatools.db.sql.AbstractSQLQueryBuilder", "buildQuery", stringBuilder.toString());
            }
        }
    }

    protected abstract void buildQueryImpl(String var1, SQLQuery var2, SQLQueryOwner var3) throws SQLQueryException;

    private void notifyBuildStart() throws SQLQueryException {
        try {
            if (this.m_query != null && !s_currentQueries.add(this.m_query)) {
                throw new SQLQueryException(this.m_query, APIBundle.get("SQL_BUILD_CIRCULAR"));
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.checkCancelled();
        }
    }

    private void notifyBuildEnd() {
        if (!s_currentQueries.remove(this.m_query)) {
            this.getLogger().warning("Unable to remove query from cache.");
        }
    }

    @Override
    public Collection<String> clearDerivedProperties(SQLQuery sQLQuery, String string, DBObjectChange dBObjectChange) {
        Collection<String> collection;
        if (!(!"queryString".equals(string) || s_currentQueries.contains(sQLQuery) || dBObjectChange.getPropertyChange("declarative") != null && Boolean.TRUE.equals(dBObjectChange.getPropertyChange("declarative").getNewValue()) || dBObjectChange.getPropertyChange(string).getNewValue() == null && sQLQuery.isDeclarative())) {
            collection = super.clearDerivedProperties(sQLQuery, string, dBObjectChange);
            sQLQuery.setDeclarative(false);
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    @Override
    public final void buildQuery(SQLQuery sQLQuery) throws SQLQueryException {
        boolean bl = this.getProvider().getObjectFactory().setDerivedPropertyBuilder(sQLQuery, this);
        if (!bl) {
            throw new IllegalStateException("SQLQueryBuilder cannot build a SQLQuery which has a different builder.");
        }
        if (sQLQuery.isDeclarative()) {
            this.setSQLQuery(sQLQuery);
        } else {
            try {
                Collection<SQLQueryClauseException> collection;
                DBUtil.ensureDerivedPropertiesBuilt(sQLQuery, this.getProvider());
                if (this.m_query == null) {
                    this.setSQLQuery(sQLQuery);
                }
                if ((collection = this.m_clauseErrors) != null && collection.size() > 0) {
                    SQLQueryClauseException sQLQueryClauseException = null;
                    for (SQLQueryClauseException sQLQueryClauseException2 : collection) {
                        sQLQueryClauseException = DBException.append(sQLQueryClauseException, sQLQueryClauseException2);
                    }
                    if (sQLQueryClauseException != null) {
                        throw sQLQueryClauseException;
                    }
                }
            }
            catch (SQLQueryException sQLQueryException) {
                throw sQLQueryException;
            }
            catch (CancelledException cancelledException) {
                throw new SQLQueryCancelledException(this.m_query);
            }
            catch (DBException dBException) {
                throw new SQLQueryException(sQLQuery, dBException.getMessage(), dBException);
            }
        }
        this.validateQuery();
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"queryString"}, derived=true)
    public final void buildDeclarativeProperties(SQLQuery sQLQuery) throws SQLQueryException, CancelledException {
        DBObject dBObject = sQLQuery.getParent();
        Schema schema = DBUtil.getSchema(dBObject);
        if (schema != null) {
            this.m_defaultSchema = schema;
        }
        if (sQLQuery.isDeclarative()) {
            this.setSQLQuery(sQLQuery);
        } else {
            String string = sQLQuery.getSQLText();
            if (string == null || string.equals("SELECT \n    \nFROM \n    \n")) {
                string = "";
            }
            try {
                this.buildQuery(string, sQLQuery, dBObject instanceof SQLQueryOwner ? (SQLQueryOwner)dBObject : null);
            }
            catch (SQLParseException sQLParseException) {
                if (this.matchesProvider()) {
                    throw sQLParseException;
                }
                this.getLogger().info(sQLParseException.getMessage());
            }
            catch (SQLQueryCancelledException sQLQueryCancelledException) {
                throw new CancelledException(sQLQueryCancelledException.getMessage());
            }
            catch (SQLQueryException sQLQueryException) {
                throw sQLQueryException;
            }
            catch (Exception exception) {
                this.getLogger().log(DBLog.getExceptionLogLevel(), "Query builder failed unexpectedly", exception);
                String string2 = APIBundle.format("SQL_CANT_BUILD_QUERY", exception.getMessage());
                throw new SQLQueryException(null, string2, exception);
            }
        }
    }

    @Override
    protected void derivePropertiesForTempCopy(SQLQuery sQLQuery, SQLQuery sQLQuery2, String string) throws DBException {
        super.derivePropertiesForTempCopy(sQLQuery, sQLQuery2, string);
        sQLQuery.setDeclarative(sQLQuery2.isDeclarative());
    }

    public <T extends SQLQueryException> void throwException(T t) throws T {
        if (this.m_clauseErrors == null || !(t instanceof SQLQueryClauseException)) {
            throw t;
        }
        this.addClauseException((SQLQueryClauseException)t);
    }

    public void addClauseException(SQLQueryClauseException sQLQueryClauseException) {
        if (sQLQueryClauseException != null) {
            if (this.m_clauseErrors == null) {
                throw new IllegalStateException("Cannot cache clause exceptions if we are not building");
            }
            this.m_clauseErrors.add(sQLQueryClauseException);
        }
    }

    @Override
    public void validateQuery() throws SQLQueryException {
        AliasFragment[] aliasFragmentArray = this.listAllFromObjects();
        this.checkAliases(aliasFragmentArray);
        AliasFragment[] aliasFragmentArray2 = this.m_query.getSelectObjects();
        this.checkAliases(aliasFragmentArray2);
    }

    private void checkAliases(AliasFragment[] aliasFragmentArray) throws SQLQueryException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; aliasFragmentArray != null && i < aliasFragmentArray.length; ++i) {
            String string = aliasFragmentArray[i].getAlias();
            if (!ModelUtil.hasLength((String)string)) continue;
            if (this.containsAliasIC(string, hashSet)) {
                this.throwException(new AliasInUseException(aliasFragmentArray[i]));
                continue;
            }
            this.validateAlias(aliasFragmentArray[i], "COLUMN", string);
            hashSet.add(string);
        }
    }

    private void loadQuery() {
        String string = "loadQuery." + s_tsKeyGen.next();
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        try {
            DBUtil.suspendTimestampChecking(abstractDBObjectProvider, string);
            this.loadObject(this.m_query);
        }
        finally {
            DBUtil.resumeTimestampChecking(abstractDBObjectProvider, string);
        }
    }

    protected void ensureIDs(SQLFragment ... sQLFragmentArray) {
        for (SQLFragment sQLFragment : sQLFragmentArray) {
            this.ensureID(sQLFragment);
        }
    }

    public DBObjectID ensureID(DBObject dBObject) {
        DBObjectID dBObjectID;
        DBObjectID dBObjectID2;
        SQLQuery sQLQuery = this.m_query;
        DBObjectID dBObjectID3 = dBObjectID2 = sQLQuery == null ? null : sQLQuery.getID();
        if (sQLQuery != null && dBObjectID2 == null) {
            dBObjectID2 = TemporaryObjectID.createID(this.m_query);
            this.m_query.setID(dBObjectID2);
        }
        if ((dBObjectID = dBObject.getID()) == null) {
            dBObject.setID(TemporaryObjectID.createID(dBObject));
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            this.ensureID(dBObject2);
        }
        return dBObject.getID();
    }

    private void ensureNames(DBObject dBObject) {
        Map<String, Object> map = dBObject.getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof DBObject) {
                if (this.needsName(object)) {
                    ((DBObject)object).setName(string);
                }
                this.ensureNames((DBObject)object);
                continue;
            }
            if (!(object instanceof DBObject[])) continue;
            for (int i = 0; i < ((DBObject[])object).length; ++i) {
                DBObject dBObject2 = ((DBObject[])object)[i];
                if (this.needsName(dBObject2)) {
                    dBObject2.setName(string + i);
                }
                this.ensureNames(dBObject2);
            }
        }
    }

    private boolean needsName(Object object) {
        boolean bl = false;
        if (object instanceof AliasFragment) {
            if (((AliasFragment)object).getAlias() == null) {
                SQLFragment sQLFragment = ((AliasFragment)object).getExpression();
                bl = !(sQLFragment instanceof DBObjectUsage) && !(sQLFragment instanceof SimpleSQLFragment);
            }
        } else if (object instanceof DBObject) {
            bl = ((DBObject)object).getName() == null;
        }
        return bl;
    }

    private boolean containsAliasIC(String string, Collection<String> collection) {
        if (ModelUtil.hasLength((String)string)) {
            for (String string2 : collection) {
                if (!this.areExternalNamesEqual(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    private void addDependency(FromObject fromObject, SQLFragment sQLFragment) {
        SQLQuery sQLQuery = fromObject.findParent(SQLQuery.class);
        if (sQLQuery != this.m_query) {
            return;
        }
        QueryCache queryCache = this.getCache();
        Collection<SQLFragment> collection = queryCache.m_fromDeps.get(fromObject);
        if (collection == null) {
            collection = new IdentitySet<SQLFragment>();
            queryCache.m_fromDeps.put(fromObject, collection);
        }
        collection.add(sQLFragment);
        queryCache.m_rFromDeps.put(sQLFragment, fromObject);
    }

    private void removeDependency(DBObject dBObject) {
        Collection<SQLFragment> collection;
        FromObject fromObject;
        QueryCache queryCache = this.m_cache;
        if (queryCache != null && (fromObject = queryCache.m_rFromDeps.get(dBObject)) != null && (collection = queryCache.m_fromDeps.get(fromObject)) != null) {
            collection.remove(dBObject);
        }
    }

    protected void loadObjects(DBObject[] dBObjectArray) {
        for (int i = 0; i < dBObjectArray.length; ++i) {
            this.loadObject(dBObjectArray[i]);
        }
    }

    protected void loadObject(DBObject dBObject) {
        if (dBObject != null) {
            Object object;
            QueryCache queryCache = this.getCache();
            if (dBObject instanceof ProviderUsage) {
                ((ProviderUsage)((Object)dBObject)).setProvider(this.getProvider());
            }
            if (dBObject instanceof UsingJoinCondition) {
                queryCache.m_usings.add((UsingJoinCondition)dBObject);
            }
            if (dBObject instanceof JoinObject && ((JoinObject)dBObject).isNatural()) {
                queryCache.m_naturalJoins.add((JoinObject)dBObject);
            }
            if (dBObject instanceof FromObjectUsage) {
                object = ((FromObjectUsage)dBObject).resolveFromObject();
                if (object != null) {
                    this.addDependency((FromObject)object, (FromObjectUsage)dBObject);
                }
            } else if (dBObject instanceof FKUsage) {
                FromObject fromObject;
                object = ((FKUsage)dBObject).resolveLeftFromObject();
                if (object != null) {
                    this.addDependency((FromObject)object, (FKUsage)dBObject);
                }
                if ((fromObject = ((FKUsage)dBObject).resolveRightFromObject()) != null) {
                    this.addDependency(fromObject, (FKUsage)dBObject);
                }
            }
            object = dBObject.getOwnedObjects();
            for (int i = 0; object != null && i < ((DBObject[])object).length; ++i) {
                this.loadObject(object[i]);
            }
        }
    }

    protected void unloadObject(DBObject dBObject) {
        if (dBObject != null) {
            QueryCache queryCache = this.getCache();
            DBObject[] dBObjectArray = dBObject.getOwnedObjects();
            for (int i = 0; dBObjectArray != null && i < dBObjectArray.length; ++i) {
                if (!(dBObjectArray[i] instanceof SQLFragment)) continue;
                this.unloadObject(dBObjectArray[i]);
            }
            if (dBObject instanceof UsingJoinCondition) {
                queryCache.m_usings.remove(dBObject);
            }
            if (dBObject instanceof JoinObject) {
                queryCache.m_naturalJoins.remove(dBObject);
            }
            this.removeDependency(dBObject);
        }
    }

    protected List<DBObjectID> getIDs(DBObject[] dBObjectArray) throws SQLQueryException {
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>(dBObjectArray.length);
        for (int i = 0; i < dBObjectArray.length; ++i) {
            DBObjectID dBObjectID = dBObjectArray[i].getID();
            if (dBObjectID == null) {
                this.throwException(new IDException(dBObjectArray[i]));
            }
            arrayList.add(dBObjectID);
        }
        return arrayList;
    }

    protected Map<DBObjectID, FromObject> getRelIDs(FromObject[] fromObjectArray) {
        HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
        for (int i = 0; fromObjectArray != null && i < fromObjectArray.length; ++i) {
            this.addRelIDs(hashMap, fromObjectArray[i]);
        }
        return hashMap;
    }

    private void addRelIDs(Map<DBObjectID, FromObject> map, FromObject fromObject) {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2 = sQLFragment = fromObject == null ? null : fromObject.getExpression();
        if (sQLFragment instanceof AbstractSchemaObjectUsage) {
            DBObjectID dBObjectID;
            SchemaObject schemaObject;
            DBObjectID dBObjectID2 = ((AbstractSchemaObjectUsage)sQLFragment).getObjectID();
            if (dBObjectID2 != null) {
                map.put(dBObjectID2, fromObject);
            }
            if (sQLFragment instanceof SynonymUsage && (schemaObject = ((SynonymUsage)sQLFragment).getReferencedObject()) != null && (dBObjectID = schemaObject.getID()) != null) {
                map.put(dBObjectID, fromObject);
            }
        } else if (sQLFragment instanceof JoinObject) {
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            this.addRelIDs(map, fromObject2);
            this.addRelIDs(map, fromObject3);
        }
    }

    protected void setNewFromObject(DBObject dBObject, FromObject fromObject, FromObject fromObject2) {
        if (dBObject instanceof FromObjectUsage) {
            if (fromObject.equals(((FromObjectUsage)dBObject).resolveFromObject())) {
                ((FromObjectUsage)dBObject).setFromObjectID(fromObject2.getID());
            }
        } else if (dBObject instanceof FKUsage) {
            if (fromObject.equals(((FKUsage)dBObject).resolveLeftFromObject())) {
                ((FKUsage)dBObject).setLeftFromObjectID(fromObject2.getID());
            }
            if (fromObject.equals(((FKUsage)dBObject).resolveRightFromObject())) {
                ((FKUsage)dBObject).setRightFromObjectID(fromObject2.getID());
            }
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        for (int i = 0; dBObjectArray != null && i < dBObjectArray.length; ++i) {
            this.setNewFromObject(dBObjectArray[i], fromObject, fromObject2);
        }
    }

    private List<String> getAliases(List<? extends AliasFragment> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (AliasFragment aliasFragment : list) {
                arrayList.add(aliasFragment.getUsableAlias());
            }
        }
        return arrayList;
    }

    private List<String> getAliases(AliasFragment[] aliasFragmentArray) {
        return aliasFragmentArray == null ? new ArrayList() : this.getAliases(Arrays.asList(aliasFragmentArray));
    }

    protected boolean areExternalNamesEqual(String string, String string2) {
        boolean bl = false;
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        bl = abstractDBObjectProvider == null ? ModelUtil.areEqual((Object)this.getInternalName(string), (Object)this.getInternalName(string2)) : abstractDBObjectProvider.getDescriptor().areNamesEqual(string, string2, "SQLFragment", true);
        return bl;
    }

    protected String getInternalName(String string) {
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        if (abstractDBObjectProvider != null) {
            return abstractDBObjectProvider.getInternalName(string);
        }
        return string;
    }

    protected String getExternalName(String string) {
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        if (abstractDBObjectProvider != null) {
            return abstractDBObjectProvider.getExternalName(string);
        }
        return string;
    }

    protected boolean isValidName(String string, String string2) {
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        if (abstractDBObjectProvider != null) {
            return abstractDBObjectProvider.isValidName(string, string2);
        }
        return true;
    }

    protected void validateAlias(AliasFragment aliasFragment, String string, String string2) throws InvalidAliasException {
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        try {
            if (ModelUtil.hasLength((String)string2)) {
                abstractDBObjectProvider.validateName(string, string2);
            }
        }
        catch (InvalidNameException invalidNameException) {
            throw new InvalidAliasException(aliasFragment, invalidNameException.getMessage());
        }
    }

    @Override
    public SQLQuery getSQLQuery() {
        return this.m_query;
    }

    @Override
    public void addSelectObject(SelectObject selectObject) throws SQLQueryException {
        this.addSelectObject(this.m_query.getSelectObjects().length, selectObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectObject(int n, SelectObject selectObject) throws SQLQueryException {
        String string;
        if (this.m_query.getParent() instanceof SQLQueryOwner && !this.isUniqueSelectAlias(string = selectObject.getUsableAlias())) {
            this.throwException(new AliasInUseException(selectObject));
        }
        boolean bl = true;
        try {
            this.m_query.addSelectObject(n, selectObject);
            this.loadObject(selectObject);
            this.checkSelectObject(selectObject);
            this.ensureID(selectObject);
            bl = false;
        }
        finally {
            if (bl) {
                this.m_query.removeSelectObject(selectObject);
            }
        }
    }

    @Override
    public boolean isUniqueSelectAlias(String string) {
        return this.isUniqueSelectAlias(string, null);
    }

    protected boolean isUniqueSelectAlias(String string, List<String> list) {
        List<String> list2 = this.getAliases(this.m_query.getSelectObjects());
        if (list != null) {
            list2.addAll(list);
        }
        return !this.containsAliasIC(string, list2);
    }

    @Override
    public String createUniqueSelectAlias(String string) {
        return this.createUniqueSelectAlias(string, null);
    }

    protected String createUniqueSelectAlias(String string, List<String> list) {
        String string2 = null;
        List<String> list2 = this.getAliases(this.m_query.getSelectObjects());
        if (list != null) {
            list2.addAll(list);
        }
        int n = this.getProvider().getDescriptor().getMaxNameLength("SELECT");
        int n2 = -1;
        while ((string2 = DBUtil.getUniqueName(list2, string = string.substring(0, string.length() - ++n2), false)).length() > n) {
        }
        return string2;
    }

    @Override
    public SelectObject getSelectObject(String string) {
        SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
        for (int i = 0; selectObjectArray != null && i < selectObjectArray.length; ++i) {
            if (!this.areExternalNamesEqual(selectObjectArray[i].getName(), string)) continue;
            return selectObjectArray[i];
        }
        return null;
    }

    @Override
    public SelectObject constructSelectObject(String string, String string2) throws SQLQueryException {
        SelectObject selectObject = new SelectObject();
        selectObject.setAlias(string2);
        selectObject.setExpression(this.parseSelectExpression(string, selectObject));
        this.validateAlias(selectObject, "COLUMN", string2);
        this.checkSelectObject(selectObject);
        this.addSelectObject(selectObject);
        return selectObject;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObject(Column column, FromObject fromObject) throws SQLQueryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<DBObjectID, FromObject> map = this.getRelIDs(new FromObject[]{fromObject});
        HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
        SelectObject selectObject = this.doConstructSelectObject(column, map, hashMap, arrayList, null);
        FromObject[] fromObjectArray = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray);
        this.checkSelectObject(selectObject);
        this.addSelectObject(selectObject);
        return new SQLQueryObjectSetImpl(new SelectObject[]{selectObject}, fromObjectArray, selectObject);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructSelectObjects(Column[] columnArray, FromObject[] fromObjectArray) throws SQLQueryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Map<DBObjectID, FromObject> map = this.getRelIDs(fromObjectArray);
        HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
        SelectObject[] selectObjectArray = new SelectObject[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            selectObjectArray[i] = this.doConstructSelectObject(columnArray[i], map, hashMap, arrayList, arrayList2);
        }
        FromObject[] fromObjectArray2 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray2);
        this.addSelectObjects(selectObjectArray);
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2, null);
    }

    protected SelectObject doConstructSelectObject(Column column, Map<DBObjectID, FromObject> map, Map<DBObjectID, FromObject> map2, List<String> list, List<String> list2) throws SQLQueryException {
        FromObject fromObject;
        DBObjectID dBObjectID;
        Relation relation;
        DBObjectID dBObjectID2 = column.getID();
        if (dBObjectID2 == null) {
            this.throwException(new IDException(column));
        }
        if ((relation = column.getRelation()) == null) {
            this.throwException(new SQLQueryException(APIBundle.format("SQL_COL_NO_REL", column.getName())));
        }
        if ((dBObjectID = relation.getID()) == null) {
            this.throwException(new IDException(relation));
        }
        if ((fromObject = map.get(dBObjectID)) == null) {
            fromObject = map2.get(dBObjectID);
        }
        if (fromObject == null) {
            fromObject = this.createFromObject(relation, list);
            map2.put(dBObjectID, fromObject);
            list.add(relation.getName());
        }
        String string = this.getExternalName(this.createUniqueSelectAlias(column.getName(), list2));
        if (list2 != null) {
            list2.add(string);
        }
        return this.createSelectObject(dBObjectID2, fromObject, string);
    }

    protected SelectObject createSelectObject(DBObjectID dBObjectID, FromObject fromObject, String string) {
        ColumnUsage columnUsage = new ColumnUsage(dBObjectID, fromObject);
        columnUsage.setProvider(this.getProvider());
        SelectObject selectObject = new SelectObject();
        selectObject.setAlias(string);
        selectObject.setExpression(columnUsage);
        this.addDependency(fromObject, columnUsage);
        return selectObject;
    }

    protected void addSelectObjects(SelectObject[] selectObjectArray) {
        SelectObject[] selectObjectArray2 = this.m_query.getSelectObjects();
        int n = (selectObjectArray2 == null ? 0 : selectObjectArray2.length) + selectObjectArray.length;
        SelectObject[] selectObjectArray3 = new SelectObject[n];
        System.arraycopy(selectObjectArray2, 0, selectObjectArray3, 0, selectObjectArray2.length);
        System.arraycopy(selectObjectArray, 0, selectObjectArray3, selectObjectArray2.length, selectObjectArray.length);
        this.m_query.setSelectObjects(selectObjectArray3);
        this.loadObjects(selectObjectArray);
    }

    @Override
    public boolean removeSelectObject(SelectObject selectObject) {
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(selectObject);
        for (int i = 0; i < sQLFragmentArray.length; ++i) {
            if (sQLFragmentArray[i] instanceof WhereObject) {
                this.removeWhereObject(sQLFragmentArray[i]);
                continue;
            }
            if (!(sQLFragmentArray[i] instanceof GroupByObject)) continue;
            this.m_query.setGroupByObject(null);
            this.unloadObject(sQLFragmentArray[i]);
        }
        if (this.m_query.removeSelectObject(selectObject)) {
            this.removeDependency(selectObject);
            return true;
        }
        return false;
    }

    @Override
    public void replaceSelectObject(SelectObject selectObject, SelectObject selectObject2) throws SQLQueryException {
        this.checkSelectObject(selectObject2);
        String string = selectObject.getAlias();
        String string2 = selectObject2.getAlias();
        if (ModelUtil.hasLength((String)string2)) {
            if (!this.areExternalNamesEqual(string2, string) && !this.isUniqueSelectAlias(string2)) {
                this.throwException(new AliasInUseException(selectObject2));
            }
            this.validateAlias(selectObject2, "COLUMN", this.getExternalName(string2));
        }
        selectObject.setAlias(string2);
        SQLFragment sQLFragment = selectObject.getExpression();
        SQLFragment sQLFragment2 = selectObject2.getExpression();
        if (ModelUtil.areDifferent((Object)sQLFragment, (Object)sQLFragment2)) {
            this.removeDependency(selectObject);
            selectObject.setExpression(sQLFragment2);
            this.loadObject(sQLFragment2);
            this.checkSelectObject(selectObject);
        }
    }

    @Override
    public boolean isUniqueFromAlias(String string) {
        return this.isUniqueFromAlias(string, null);
    }

    protected boolean isUniqueFromAlias(String string, List<String> list) {
        List<String> list2 = this.getAliases(this.listAllFromObjects());
        if (list != null) {
            list2.addAll(list);
        }
        return !this.containsAliasIC(string, list2);
    }

    @Override
    public String createUniqueFromAlias(String string) {
        return this.createUniqueFromAlias(string, null);
    }

    protected String createUniqueFromAlias(String string, List<String> list) {
        String string2 = null;
        List<String> list2 = this.getAliases(this.listAllFromObjects());
        if (list != null) {
            list2.addAll(list);
        }
        int n = this.getProvider().getDescriptor().getMaxNameLength("FROM");
        int n2 = -1;
        while ((string2 = DBUtil.getUniqueName(list2, string = string.substring(0, string.length() - ++n2), false)).length() > n) {
        }
        return string2;
    }

    @Override
    public FromObject[] listAllFromObjects() {
        return this.listAllFromObjects(false);
    }

    @Override
    public FromObject[] listAllFromObjects(boolean bl) {
        return this.listAllFromObjects(bl, false);
    }

    private FromObject[] listAllFromObjects(boolean bl, boolean bl2) {
        ArrayList<FromObject> arrayList = new ArrayList<FromObject>();
        FromObject[] fromObjectArray = this.m_query.getFromObjects();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            this.addFromObjects(fromObjectArray[i], arrayList, bl, bl2);
        }
        return arrayList.toArray(new FromObject[arrayList.size()]);
    }

    private void addFromObjects(DBObject dBObject, List<FromObject> list, boolean bl, boolean bl2) {
        DBObject[] dBObjectArray;
        if (dBObject instanceof FromObject) {
            dBObjectArray = ((FromObject)dBObject).getExpression();
            if (!(!bl && dBObjectArray instanceof JoinObject || !bl2 && ((FromObject)dBObject).isWith())) {
                list.add((FromObject)dBObject);
            }
        }
        if (!(dBObject instanceof SQLQuery)) {
            dBObjectArray = dBObject.getOwnedObjects();
            for (int i = 0; dBObjectArray != null && i < dBObjectArray.length; ++i) {
                this.addFromObjects(dBObjectArray[i], list, bl, bl2);
            }
        }
    }

    @Override
    public FromObject getFromObject(String string) {
        return this.getFromObject(string, null);
    }

    public FromObject getFromObject(String string, FromObject fromObject) {
        FromObject[] fromObjectArray;
        ArrayList<FromObject> arrayList = new ArrayList<FromObject>();
        if (fromObject != null) {
            this.addFromObjects(fromObject, arrayList, false, true);
        }
        if ((fromObjectArray = this.listAllFromObjects(true, true)) != null) {
            arrayList.addAll(Arrays.asList(fromObjectArray));
        }
        ArrayList<FromObject> arrayList2 = new ArrayList<FromObject>();
        for (FromObject fromObject2 : arrayList) {
            String string2;
            String string3 = fromObject2.getUsableAlias();
            if (string3 == null) continue;
            if (this.areExternalNamesEqual(string3, string)) {
                return fromObject2;
            }
            if (!string3.contains(".") || !this.areExternalNamesEqual(string2 = string3.substring(string3.indexOf(".") + 1), string)) continue;
            arrayList2.add(fromObject2);
        }
        return arrayList2.size() == 1 ? (FromObject)arrayList2.get(0) : null;
    }

    @Override
    public FromObject constructFromObject(String string, String string2) throws SQLQueryException {
        SQLFragment sQLFragment = this.parseFromExpression(string);
        FromObject fromObject = new FromObject(sQLFragment, string2);
        this.validateAlias(fromObject, "COLUMN", string2);
        this.addFromObject(fromObject);
        return fromObject;
    }

    protected FromObject createFromObject(SchemaObject schemaObject, List<String> list) throws SQLQueryException {
        Object object;
        DBObjectID dBObjectID = schemaObject.getID();
        if (dBObjectID == null) {
            this.throwException(new IDException(schemaObject));
        }
        Object object2 = schemaObject.getName();
        boolean bl = false;
        if (dBObjectID instanceof BaseObjectID) {
            bl = ((BaseObjectID)dBObjectID).getDatabaseName() != null;
        }
        boolean bl2 = true;
        if (bl) {
            object = ((BaseObjectID)dBObjectID).getDatabaseName().split("\\.")[0];
            object2 = (String)object2 + "_" + (String)object;
            bl2 = false;
        } else if (this.m_defaultSchema != null && (object = schemaObject.getSchema()) != null && !((AbstractDBObject)object).getName().equalsIgnoreCase(this.m_defaultSchema.getName())) {
            object2 = ((AbstractDBObject)object).getName() + "_" + (String)object2;
            bl2 = false;
        }
        if (bl2 && this.isUniqueFromAlias((String)object2, list)) {
            object2 = null;
        } else {
            object2 = this.createUniqueFromAlias((String)object2, list);
            object2 = this.getExternalName((String)object2);
        }
        if (schemaObject instanceof Relation) {
            object = new RelationUsage(dBObjectID);
        } else if (schemaObject instanceof Synonym) {
            object = new SynonymUsage(dBObjectID);
        } else {
            throw new SQLQueryException("Cannot reference " + schemaObject.getType() + " " + schemaObject.getName() + " in FROM clause.");
        }
        ((AbstractProviderUsageSQLFragment)object).setProvider(this.getProvider());
        FromObject fromObject = new FromObject((SQLFragment)object, (String)object2);
        fromObject.setParent(this.m_query);
        this.ensureID(fromObject);
        return fromObject;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObject(SchemaObject schemaObject, boolean bl, boolean bl2, FromObject[] fromObjectArray) throws SQLQueryException {
        List<DBObjectID> list = this.getIDs(new SchemaObject[]{schemaObject});
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
        ArrayList<Column> arrayList2 = bl ? new ArrayList<Column>() : null;
        ArrayList<FKConstraint> arrayList3 = bl2 ? new ArrayList<FKConstraint>() : null;
        FromObject fromObject = this.doConstructFromObject(schemaObject, list, arrayList, hashMap, arrayList2, arrayList3);
        FromObject[] fromObjectArray2 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray2);
        SelectObject[] selectObjectArray = null;
        if (bl) {
            selectObjectArray = this.constructSelectObjects(arrayList2.toArray(new Column[arrayList2.size()]), new FromObject[]{fromObject}).getSelectObjects();
        }
        FromObject[] fromObjectArray3 = new FromObject[]{fromObject};
        if (bl2 && fromObjectArray != null) {
            fromObjectArray3 = new FromObject[fromObjectArray.length + 1];
            fromObjectArray3[0] = fromObject;
            System.arraycopy(fromObjectArray, 0, fromObjectArray3, 1, fromObjectArray.length);
        }
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2, fromObject);
    }

    protected FromObject doConstructFromObject(SchemaObject schemaObject, List<DBObjectID> list, List<String> list2, Map<DBObjectID, FromObject> map, List<Column> list3, List<FKConstraint> list4) throws SQLQueryException {
        FromObject fromObject = this.createFromObject(schemaObject, list2);
        map.put(schemaObject.getID(), fromObject);
        list2.add(schemaObject.getName());
        if (list3 != null && schemaObject instanceof Relation) {
            AbstractChildBuildableObject[] abstractChildBuildableObjectArray = ((Relation)schemaObject).getColumns();
            list3.addAll(Arrays.asList(abstractChildBuildableObjectArray));
        }
        if (list4 != null && schemaObject instanceof Relation) {
            for (AbstractChildBuildableObject abstractChildBuildableObject : ((Relation)schemaObject).getConstraints()) {
                DBObjectID dBObjectID;
                DBObjectID dBObjectID2;
                if (!(abstractChildBuildableObject instanceof FKConstraint) || (dBObjectID2 = this.getParentRelation(dBObjectID = ((FKConstraint)abstractChildBuildableObject).getReferenceID()).getID()) == null || !list.contains(dBObjectID2)) continue;
                list4.add((FKConstraint)abstractChildBuildableObject);
            }
        }
        return fromObject;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFromObjects(Relation[] relationArray, boolean bl, boolean bl2, FromObject[] fromObjectArray) throws SQLQueryException {
        List<DBObjectID> list = this.getIDs(relationArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<DBObjectID, FromObject> hashMap = new HashMap<DBObjectID, FromObject>();
        FromObject[] fromObjectArray2 = new FromObject[relationArray.length];
        ArrayList<Column> arrayList2 = bl ? new ArrayList<Column>() : null;
        ArrayList<FKConstraint> arrayList3 = bl2 ? new ArrayList<FKConstraint>() : null;
        for (int i = 0; i < relationArray.length; ++i) {
            fromObjectArray2[i] = this.doConstructFromObject(relationArray[i], list, arrayList, hashMap, arrayList2, arrayList3);
        }
        FromObject[] fromObjectArray3 = hashMap.values().toArray(new FromObject[hashMap.size()]);
        this.addFromObjects(fromObjectArray3);
        SelectObject[] selectObjectArray = null;
        if (bl) {
            selectObjectArray = this.constructSelectObjects(arrayList2.toArray(new Column[arrayList2.size()]), fromObjectArray2).getSelectObjects();
        }
        if (bl2) {
            FromObject[] fromObjectArray4 = null;
            if (fromObjectArray == null) {
                fromObjectArray4 = fromObjectArray2;
            } else {
                fromObjectArray4 = new FromObject[fromObjectArray2.length + fromObjectArray.length];
                System.arraycopy(fromObjectArray2, 0, fromObjectArray4, 0, fromObjectArray2.length);
                System.arraycopy(fromObjectArray, 0, fromObjectArray4, fromObjectArray2.length, fromObjectArray.length);
            }
        }
        return new SQLQueryObjectSetImpl(selectObjectArray, fromObjectArray2);
    }

    @Override
    public void addFromObject(FromObject fromObject) throws SQLQueryException {
        fromObject.setParent(this.m_query);
        String string = fromObject.getUsableAlias();
        if (string != null && !this.isUniqueFromAlias(string)) {
            this.throwException(new AliasInUseException(fromObject));
        } else {
            string = fromObject.getAlias();
            this.validateAlias(fromObject, "TABLE", string);
        }
        this.m_query.addFromObject(fromObject);
        this.ensureID(fromObject);
        this.loadObject(fromObject);
        this.checkUsageQualifications();
    }

    protected void addFromObjects(FromObject[] fromObjectArray) {
        if (fromObjectArray != null && fromObjectArray.length > 0) {
            FromObject[] fromObjectArray2 = this.m_query.getFromObjects();
            int n = (fromObjectArray2 == null ? 0 : fromObjectArray2.length) + fromObjectArray.length;
            FromObject[] fromObjectArray3 = new FromObject[n];
            System.arraycopy(fromObjectArray2, 0, fromObjectArray3, 0, fromObjectArray2.length);
            System.arraycopy(fromObjectArray, 0, fromObjectArray3, fromObjectArray2.length, fromObjectArray.length);
            this.m_query.setFromObjects(fromObjectArray3);
            this.ensureIDs(fromObjectArray);
            this.loadObjects(fromObjectArray);
            this.checkUsageQualifications();
        }
    }

    protected void addJoinObject(FromObject fromObject) {
        FromObject fromObject2;
        JoinObject joinObject;
        FromObject fromObject3;
        List<FromObject> list = Arrays.asList(this.m_query.getFromObjects());
        if (list.contains(fromObject3 = (joinObject = (JoinObject)fromObject.getExpression()).getLeftExpression())) {
            this.m_query.removeFromObject(fromObject3);
        }
        if (list.contains(fromObject2 = joinObject.getRightExpression())) {
            this.m_query.removeFromObject(fromObject2);
        }
        this.m_query.addFromObject(fromObject);
        this.loadObject(fromObject);
        this.checkUsageQualifications();
    }

    @Override
    public void replaceFromObject(FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2;
        boolean bl;
        String string = fromObject.getAlias();
        String string2 = fromObject2.getAlias();
        if (ModelUtil.hasLength((String)string2)) {
            if (!this.areExternalNamesEqual(string2, string) && !this.isUniqueFromAlias(string2)) {
                this.throwException(new AliasInUseException(fromObject2));
            }
            this.validateAlias(fromObject2, "TABLE", string2);
        }
        if ((bl = ModelUtil.areDifferent((Object)(sQLFragment2 = fromObject.getExpression()), (Object)(sQLFragment = fromObject2.getExpression()))) && sQLFragment2 instanceof RelationUsage) {
            this.removeFromObject(fromObject);
            this.addFromObject(fromObject2);
        } else {
            if (bl) {
                this.unloadObject(sQLFragment2);
                this.loadObject(sQLFragment);
                fromObject.setExpression(sQLFragment);
            }
            fromObject.setAlias(fromObject2.getAlias());
        }
        this.checkUsageQualifications();
    }

    @Override
    public boolean removeJoinObject(FromObject fromObject) {
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof JoinObject) {
            QueryCache queryCache = this.getCache();
            queryCache.m_naturalJoins.remove(sQLFragment);
            boolean bl = false;
            FromObject fromObject2 = ((JoinObject)sQLFragment).getLeftExpression();
            FromObject fromObject3 = ((JoinObject)sQLFragment).getRightExpression();
            DBObject dBObject = fromObject.getParent();
            JoinCondition joinCondition = ((JoinObject)sQLFragment).getCondition();
            if (joinCondition instanceof UsingJoinCondition) {
                queryCache.m_usings.remove(joinCondition);
            }
            if (dBObject == this.m_query) {
                int n = this.m_query.indexOf(fromObject);
                if (n >= 0) {
                    this.m_query.addFromObject(n, fromObject3);
                    this.m_query.addFromObject(n, fromObject2);
                    this.m_query.removeFromObject(fromObject);
                    bl = true;
                }
            } else if (dBObject instanceof JoinObject) {
                FromObject fromObject4 = fromObject2;
                FromObject fromObject5 = fromObject3;
                JoinCondition joinCondition2 = ((JoinObject)dBObject).getCondition();
                if (joinCondition2 instanceof UsingJoinCondition) {
                    FromObject fromObject6;
                    FromObjectUsage[] fromObjectUsageArray = ((UsingJoinCondition)joinCondition2).getColumns();
                    for (int i = 0; i < fromObjectUsageArray.length && (fromObject6 = fromObjectUsageArray[i].resolveFromObject()) != fromObject2; ++i) {
                        if (fromObject6 != fromObject3) continue;
                        fromObject4 = fromObject3;
                        fromObject5 = fromObject2;
                        break;
                    }
                } else if (this.usedInChildren(fromObject3, joinCondition2)) {
                    fromObject4 = fromObject3;
                    fromObject5 = fromObject2;
                }
                if (((JoinObject)dBObject).getLeftExpression() == fromObject) {
                    ((JoinObject)dBObject).setLeftExpression(fromObject4);
                    this.m_query.addFromObject(fromObject5);
                } else {
                    ((JoinObject)dBObject).setRightExpression(fromObject4);
                    this.m_query.addFromObject(fromObject5);
                }
                bl = true;
            }
            if (bl) {
                this.checkUsageQualifications();
                return true;
            }
        }
        return false;
    }

    private boolean usedInChildren(FromObject fromObject, DBObject dBObject) {
        if (dBObject instanceof FromObjectUsage) {
            return ((FromObjectUsage)dBObject).resolveFromObject() == fromObject;
        }
        if (dBObject instanceof FKUsage) {
            return ((FKUsage)dBObject).resolveLeftFromObject() == fromObject || ((FKUsage)dBObject).resolveRightFromObject() == fromObject;
        }
        DBObject[] dBObjectArray = dBObject.getOwnedObjects();
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (!this.usedInChildren(fromObject, dBObjectArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromObject(FromObject fromObject) {
        DBObject dBObject;
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(fromObject);
        block0: for (int i = 0; i < sQLFragmentArray.length; ++i) {
            if (!(sQLFragmentArray[i] instanceof FromObjectUsage)) continue;
            boolean bl = false;
            for (dBObject = sQLFragmentArray[i].getParent(); dBObject != null; dBObject = dBObject.getParent()) {
                if (dBObject instanceof SelectObject) {
                    this.removeSelectObject((SelectObject)dBObject);
                    continue block0;
                }
                if (dBObject instanceof OrderByObject) {
                    this.removeOrderByObject((OrderByObject)dBObject);
                    continue block0;
                }
                if (dBObject instanceof WhereObject) {
                    bl = true;
                    if (!(dBObject.getParent() instanceof SQLQuery)) continue;
                    this.removeWhereObject((WhereObject)dBObject);
                    continue block0;
                }
                if (!(dBObject instanceof GroupByObject)) continue;
                if (bl) {
                    this.setHavingObject(null);
                    continue block0;
                }
                this.removeGroupByColumn(sQLFragmentArray[i]);
                continue block0;
            }
        }
        DBObject dBObject2 = fromObject.getParent();
        if (dBObject2 instanceof JoinObject) {
            FromObject fromObject2 = null;
            fromObject2 = fromObject == ((JoinObject)dBObject2).getLeftExpression() ? ((JoinObject)dBObject2).getRightExpression() : ((JoinObject)dBObject2).getLeftExpression();
            dBObject = (FromObject)dBObject2.getParent();
            DBObject dBObject3 = ((AbstractDBObject)dBObject).getParent();
            if (dBObject3 instanceof JoinObject) {
                if (dBObject == ((JoinObject)dBObject3).getLeftExpression()) {
                    ((JoinObject)dBObject3).setLeftExpression(fromObject2);
                } else {
                    ((JoinObject)dBObject3).setRightExpression(fromObject2);
                }
            } else {
                FromObject[] fromObjectArray = this.m_query.getFromObjects();
                for (int i = 0; i < fromObjectArray.length; ++i) {
                    if (fromObjectArray[i] != dBObject) continue;
                    fromObjectArray[i] = fromObject2;
                }
                this.m_query.setFromObjects(fromObjectArray);
            }
            this.unloadObject(fromObject);
            return true;
        }
        if (this.m_query.removeFromObject(fromObject)) {
            this.unloadObject(fromObject);
            return true;
        }
        return false;
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoin(FKConstraint fKConstraint, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        FromObject fromObject3 = this.doConstructJoin(fKConstraint, null, null, fromObject, fromObject2);
        if (fromObject3.getParent() == null) {
            this.addJoinObject(fromObject3);
        }
        return new SQLQueryObjectSetImpl(null, new FromObject[]{fromObject3}, fromObject3);
    }

    @Override
    public SQLQueryBuilder.SQLQueryObjectSet constructFKJoins(FKConstraint[] fKConstraintArray, FromObject[] fromObjectArray) throws SQLQueryException {
        Map<DBObjectID, FromObject> map = this.getRelIDs(fromObjectArray);
        FromObject[] fromObjectArray2 = new FromObject[fKConstraintArray.length];
        ArrayList<FromObject> arrayList = new ArrayList<FromObject>();
        for (int i = fKConstraintArray.length - 1; i >= 0; --i) {
            fromObjectArray2[i] = this.doConstructJoin(fKConstraintArray[i], map, arrayList, null, i < fKConstraintArray.length - 1 ? fromObjectArray2[i + 1] : null);
        }
        this.addJoinObject(fromObjectArray2[0]);
        return new SQLQueryObjectSetImpl(null, fromObjectArray2, null);
    }

    protected FromObject doConstructJoin(FKConstraint fKConstraint, Map<DBObjectID, FromObject> map, List<FromObject> list, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        Object object;
        Copyable copyable;
        DBObjectID dBObjectID = fKConstraint.getID();
        if (dBObjectID == null) {
            this.throwException(new IDException(fKConstraint));
        }
        if (fromObject == null) {
            copyable = fKConstraint.getRelation();
            object = copyable.getID();
            if (map.containsKey(object)) {
                fromObject = map.get(object);
            } else {
                fromObject = this.createFromObject((SchemaObject)copyable, this.getAliases(list));
                list.add(fromObject);
            }
        }
        if (fromObject2 == null) {
            copyable = fKConstraint.getReferenceID();
            object = this.getParentRelation((DBObjectID)copyable);
            DBObjectID dBObjectID2 = ((AbstractDBObject)object).getID();
            if (map.containsKey(dBObjectID2) && (fromObject2 = map.get(dBObjectID2)) == fromObject) {
                fromObject2 = null;
            }
            if (fromObject2 == null) {
                fromObject2 = this.createFromObject((SchemaObject)object, this.getAliases(list));
                list.add(fromObject2);
            }
        }
        return this.createJoinObject(fKConstraint, fromObject, fromObject2);
    }

    @Override
    public FromObject createJoinObject(FKConstraint fKConstraint, FromObject fromObject, FromObject fromObject2) throws SQLQueryException {
        if (fromObject.getParent() instanceof JoinObject && fromObject.getParent() == fromObject2.getParent()) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_JOIN_JOIN")));
        }
        JoinObject joinObject = new JoinObject();
        FromObject fromObject3 = new FromObject(joinObject, null);
        DBObject dBObject = fromObject.getParent();
        if (dBObject == this.m_query) {
            this.m_query.removeFromObject(fromObject);
        } else if (dBObject instanceof JoinObject) {
            if (fromObject == ((JoinObject)dBObject).getLeftExpression()) {
                ((JoinObject)dBObject).setLeftExpression(fromObject3);
            } else {
                ((JoinObject)dBObject).setRightExpression(fromObject3);
            }
        }
        DBObject dBObject2 = fromObject2.getParent();
        if (dBObject2 == this.m_query) {
            this.m_query.removeFromObject(fromObject2);
        } else if (dBObject2 instanceof JoinObject) {
            if (fromObject2 == ((JoinObject)dBObject2).getLeftExpression()) {
                ((JoinObject)dBObject2).setLeftExpression(fromObject3);
            } else {
                ((JoinObject)dBObject2).setRightExpression(fromObject3);
            }
        }
        joinObject.setLeftExpression(fromObject);
        joinObject.setRightExpression(fromObject2);
        this.createJoinCondition(fKConstraint, joinObject);
        this.ensureID(fromObject3);
        return fromObject3;
    }

    private void logResolveIDException(DBException dBException) {
        this.getLogger().warning("ID failed to resolve: " + dBException.getMessage());
    }

    protected JoinCondition createJoinCondition(FKConstraint fKConstraint, JoinObject joinObject) {
        AbstractSQLFragment abstractSQLFragment = null;
        ArrayList<DBObjectID> arrayList = new ArrayList<DBObjectID>();
        DBObjectID[] dBObjectIDArray = fKConstraint.getColumnIDs();
        DBObjectID[] dBObjectIDArray2 = null;
        DBObjectID dBObjectID = fKConstraint.getReferenceID();
        try {
            UniqueConstraint uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
            if (uniqueConstraint != null) {
                dBObjectIDArray2 = uniqueConstraint.getColumnIDs();
            }
        }
        catch (DBException dBException) {
            this.logResolveIDException(dBException);
        }
        if (dBObjectIDArray == null || dBObjectIDArray2 == null || dBObjectIDArray.length < 1 || dBObjectIDArray.length != dBObjectIDArray2.length) {
            arrayList = null;
        } else {
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                if (!ModelUtil.areEqual((Object)DBUtil.getDBObjectName(dBObjectIDArray[i]), (Object)DBUtil.getDBObjectName(dBObjectIDArray2[i]))) {
                    arrayList = null;
                    break;
                }
                arrayList.add(dBObjectIDArray[i]);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            FromObjectUsage[] fromObjectUsageArray = new FromObjectUsage[arrayList.size()];
            for (int i = 0; i < fromObjectUsageArray.length; ++i) {
                fromObjectUsageArray[i] = new ColumnUsage((DBObjectID)arrayList.get(i), joinObject.getLeftExpression());
            }
            abstractSQLFragment = new UsingJoinCondition(fromObjectUsageArray);
            this.getCache().m_usings.add((UsingJoinCondition)abstractSQLFragment);
        } else {
            FKUsage fKUsage = this.createFKUsage(fKConstraint.getID(), joinObject.getLeftExpression(), joinObject.getRightExpression());
            abstractSQLFragment = new OnJoinCondition(fKUsage);
        }
        joinObject.setCondition((JoinCondition)((Object)abstractSQLFragment));
        return abstractSQLFragment;
    }

    private Relation getParentRelation(DBObjectID dBObjectID) throws SQLQueryException {
        Relation relation;
        UniqueConstraint uniqueConstraint = null;
        try {
            uniqueConstraint = (UniqueConstraint)dBObjectID.resolveID();
        }
        catch (DBException dBException) {
            this.throwException(new IDException(dBObjectID, dBException));
        }
        Relation relation2 = relation = uniqueConstraint == null ? null : uniqueConstraint.getRelation();
        if (relation == null) {
            this.throwException(new IDException(uniqueConstraint));
        }
        return relation;
    }

    protected FKUsage doConstructFKUsage(FKConstraint fKConstraint, Map map, List<FromObject> list) throws SQLQueryException {
        DBObjectID dBObjectID = fKConstraint.getID();
        if (dBObjectID == null) {
            this.throwException(new IDException(fKConstraint));
        }
        FromObject fromObject = null;
        DBObjectID dBObjectID2 = fKConstraint.getReferenceID();
        Relation relation = this.getParentRelation(dBObjectID2);
        DBObjectID dBObjectID3 = relation.getID();
        if (map.containsKey(dBObjectID3)) {
            fromObject = (FromObject)map.get(dBObjectID3);
        } else {
            fromObject = this.createFromObject(relation, this.getAliases(list));
            list.add(fromObject);
        }
        FromObject fromObject2 = null;
        Relation relation2 = fKConstraint.getRelation();
        DBObjectID dBObjectID4 = relation2.getID();
        if (map.containsKey(dBObjectID4)) {
            fromObject2 = (FromObject)map.get(dBObjectID4);
        } else {
            fromObject2 = this.createFromObject(relation2, this.getAliases(list));
            list.add(fromObject2);
        }
        return this.createFKUsage(dBObjectID, fromObject, fromObject2);
    }

    protected FKUsage createFKUsage(DBObjectID dBObjectID, FromObject fromObject, FromObject fromObject2) {
        DBObjectID dBObjectID2 = fromObject != null ? fromObject.getID() : null;
        DBObjectID dBObjectID3 = fromObject2 != null ? fromObject2.getID() : null;
        FKUsage fKUsage = new FKUsage(dBObjectID, dBObjectID2, dBObjectID3);
        fKUsage.setProvider(this.getProvider());
        return fKUsage;
    }

    @Override
    public void setWhereObject(WhereObject whereObject) {
        WhereObject whereObject2 = this.m_query.getWhereObject();
        if (whereObject2 != null && !whereObject2.equals(whereObject)) {
            this.unloadObject(whereObject2);
        }
        this.m_query.setWhereObject(whereObject);
        if (whereObject != null) {
            this.loadObject(whereObject);
        }
    }

    protected boolean removeWhereObject(SQLFragment sQLFragment) {
        WhereObject whereObject = this.m_query.getWhereObject();
        if (whereObject != null) {
            if (whereObject.equals(sQLFragment)) {
                this.unloadObject(sQLFragment);
                this.m_query.setWhereObject(null);
                return true;
            }
            SQLFragment[] sQLFragmentArray = whereObject.getArguments();
            for (int i = 0; sQLFragmentArray != null && i < sQLFragmentArray.length; ++i) {
                SQLFragment sQLFragment2;
                if (sQLFragmentArray[i] != sQLFragment) continue;
                SQLFragment[] sQLFragmentArray2 = new SQLFragment[sQLFragmentArray.length - 1];
                System.arraycopy(sQLFragmentArray, 0, sQLFragmentArray2, 0, i);
                System.arraycopy(sQLFragmentArray, i + 1, sQLFragmentArray2, i, sQLFragmentArray.length - i - 1);
                whereObject.setArguments(sQLFragmentArray2);
                this.unloadObject(sQLFragment);
                if (whereObject.getArgumentCount() < 1) {
                    this.m_query.setWhereObject(null);
                } else if (whereObject.getArgumentCount() == 1 && (sQLFragment2 = whereObject.getArguments()[0]) instanceof WhereObject) {
                    this.m_query.setWhereObject((WhereObject)sQLFragment2);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public RelationUsage[] getRelationUsages() {
        FromObject[] fromObjectArray = this.listAllFromObjects();
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        for (int i = 0; i < fromObjectArray.length; ++i) {
            SQLFragment sQLFragment = fromObjectArray[i].getExpression();
            if (!(sQLFragment instanceof RelationUsage)) continue;
            arrayList.add(sQLFragment);
        }
        return arrayList.toArray(new RelationUsage[arrayList.size()]);
    }

    @Override
    public SQLFragment[] getDependentObjects(FromObject fromObject) {
        QueryCache queryCache = this.getCache();
        Collection<SQLFragment> collection = queryCache.m_fromDeps.get(fromObject);
        if (collection != null) {
            ArrayList arrayList = new ArrayList();
            for (SQLFragment sQLFragment : collection) {
                this.findEquivalentObjects(sQLFragment, this.m_query, arrayList);
            }
            return arrayList.toArray(new SQLFragment[arrayList.size()]);
        }
        return EMPTY_ARRAY;
    }

    private void findEquivalentObjects(DBObject dBObject, DBObject dBObject2, Collection collection) {
        DBObject[] dBObjectArray = dBObject2.getOwnedObjects();
        for (int i = 0; i < dBObjectArray.length; ++i) {
            if (dBObjectArray[i] == null) continue;
            if (dBObjectArray[i].equals(dBObject)) {
                collection.add(dBObjectArray[i]);
            }
            this.findEquivalentObjects(dBObject, dBObjectArray[i], collection);
        }
    }

    @Override
    public SQLFragment[] getDependentObjects(SelectObject selectObject) {
        SQLFragment sQLFragment;
        ArrayList<GroupByObject> arrayList = new ArrayList<GroupByObject>();
        if (this.supportsGroupBy() && (sQLFragment = selectObject.getExpression()) instanceof Function && ((Function)sQLFragment).isGrouping()) {
            boolean bl = true;
            SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
            for (int i = 0; i < selectObjectArray.length; ++i) {
                SQLFragment sQLFragment2;
                if (selectObjectArray[i].equals(selectObject) || !((sQLFragment2 = selectObjectArray[i].getExpression()) instanceof Function) || !((Function)sQLFragment2).isGrouping()) continue;
                bl = false;
                break;
            }
            GroupByObject groupByObject = this.m_query.getGroupByObject();
            if (bl && groupByObject != null) {
                arrayList.add(groupByObject);
            }
        }
        return arrayList.toArray(new SQLFragment[arrayList.size()]);
    }

    @Override
    public boolean canMergeRelationUsages(RelationUsage relationUsage, RelationUsage relationUsage2) {
        DBObjectID dBObjectID = relationUsage.getObjectID();
        DBObjectID dBObjectID2 = relationUsage2.getObjectID();
        return dBObjectID != null && ModelUtil.areEqual((Object)dBObjectID, (Object)dBObjectID2);
    }

    @Override
    public void mergeRelationUsages(RelationUsage relationUsage, RelationUsage relationUsage2) throws SQLQueryException {
        DBObjectID dBObjectID = relationUsage.getObjectID();
        DBObjectID dBObjectID2 = relationUsage.getObjectID();
        if (dBObjectID == null || ModelUtil.areDifferent((Object)dBObjectID, (Object)dBObjectID2)) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_RELU_MERGE_ERR")));
        }
        FromObject fromObject = (FromObject)relationUsage.getParent();
        FromObject fromObject2 = (FromObject)relationUsage2.getParent();
        if (!(fromObject2.getParent() instanceof SQLQuery)) {
            this.throwException(new SQLQueryException(APIBundle.get("SQL_MERGE_JOIN")));
        }
        SQLFragment[] sQLFragmentArray = this.getDependentObjects(fromObject2);
        for (int i = 0; i < sQLFragmentArray.length; ++i) {
            this.setNewFromObject(sQLFragmentArray[i], fromObject2, fromObject);
        }
    }

    @Override
    public FKUsage[] listAvailableFKs() {
        Object object;
        ArrayList<FKUsage> arrayList = new ArrayList<FKUsage>();
        RelationUsage[] relationUsageArray = this.getRelationUsages();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < relationUsageArray.length; ++i) {
            Map.Entry entry = relationUsageArray[i].getObjectID();
            if (entry == null) continue;
            object = (List)hashMap.get(entry);
            if (object == null) {
                object = new ArrayList();
                hashMap.put(entry, object);
            }
            object.add((FromObject)relationUsageArray[i].getParent());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (DBObjectID)entry.getKey();
            if (object == null) continue;
            for (FromObject fromObject : (List)entry.getValue()) {
                Relation relation = (Relation)this.resolveID((DBObjectID)object);
                if (relation == null) continue;
                for (Constraint constraint : relation.getConstraints()) {
                    if (!(constraint instanceof FKConstraint)) continue;
                    try {
                        DBObjectID dBObjectID = ((FKConstraint)constraint).getReferenceID();
                        DBObjectID dBObjectID2 = this.getParentRelation(dBObjectID).getID();
                        List list = (List)hashMap.get(dBObjectID2);
                        for (int i = 0; list != null && i < list.size(); ++i) {
                            FromObject fromObject2 = (FromObject)list.get(i);
                            if (fromObject2 == null) continue;
                            DBObjectID dBObjectID3 = fromObject != null ? fromObject.getID() : null;
                            DBObjectID dBObjectID4 = fromObject2 != null ? fromObject2.getID() : null;
                            FKUsage fKUsage = new FKUsage(constraint.getID(), dBObjectID3, dBObjectID4);
                            if (arrayList.contains(fKUsage)) continue;
                            arrayList.add(fKUsage);
                        }
                    }
                    catch (SQLQueryException sQLQueryException) {
                        this.getLogger().warning("Error listing FKs: " + sQLQueryException.getMessage());
                    }
                }
            }
        }
        return arrayList.toArray(new FKUsage[arrayList.size()]);
    }

    @Override
    @Deprecated
    public ColumnUsage[] getColumnUsages() {
        Collection<ColumnUsage> collection = DBUtil.findChildren(this.m_query, ColumnUsage.class);
        return collection.toArray(new ColumnUsage[collection.size()]);
    }

    public FromObjectUsage findColumnInFromObjects(String string, boolean bl, SQLFragment sQLFragment, FromObject ... fromObjectArray) throws SQLQueryException {
        Object object;
        FromObject[] fromObjectArray2 = this.m_query.getFromObjects();
        if ((fromObjectArray = DBUtil.stripNulls(fromObjectArray)) != null && fromObjectArray.length > 0) {
            object = fromObjectArray2;
            fromObjectArray2 = new FromObject[((FromObject[])object).length + fromObjectArray.length];
            System.arraycopy(object, 0, fromObjectArray2, 0, ((Object)object).length);
            System.arraycopy(fromObjectArray, 0, fromObjectArray2, ((Object)object).length, fromObjectArray.length);
        }
        this.replaceWithAliases(fromObjectArray2);
        object = this.findColumnInFromObjects(string, bl, fromObjectArray2, false, false, sQLFragment);
        if (object != null) {
            object.setQualified(false);
        }
        return object;
    }

    protected void replaceWithAliases(FromObject[] fromObjectArray) {
    }

    protected FromObjectUsage findColumnInFromObjects(String string, boolean bl, FromObject[] fromObjectArray, boolean bl2, boolean bl3, SQLFragment sQLFragment) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        FromObjectUsage fromObjectUsage = null;
        for (int i = 0; i < fromObjectArray.length; ++i) {
            this.checkCancelled();
            FromObject fromObject = fromObjectArray[i];
            if (fromObject == null) continue;
            this.ensureID(fromObject);
            SQLFragment sQLFragment2 = fromObject.getExpression();
            FromObjectUsage fromObjectUsage2 = this.findColumnInFromExpression(string, bl, sQLFragment2, bl2, fromObject, sQLFragment);
            if (fromObjectUsage2 != null) {
                if (fromObjectUsage != null && !bl2) {
                    this.throwException(new AmbiguousColumnException(sQLFragment, string));
                }
                fromObjectUsage = fromObjectUsage2;
                continue;
            }
            if (!bl3) continue;
            this.throwException(new SQLQueryException(APIBundle.format("SQL_MISSING_COL", string, fromObjectArray[i].getName())));
        }
        return fromObjectUsage;
    }

    public FromObjectUsage findColumnInFromExpression(String string, boolean bl, SQLFragment sQLFragment, boolean bl2, FromObject fromObject, SQLFragment sQLFragment2) throws SQLQueryException {
        FromObjectUsage fromObjectUsage = null;
        if (sQLFragment instanceof RelationUsage) {
            fromObjectUsage = this.findColumnInRelation(string, bl, (RelationUsage)sQLFragment);
        } else if (sQLFragment instanceof SynonymUsage) {
            SchemaObject schemaObject = ((SynonymUsage)sQLFragment).getReferencedObject();
            if (schemaObject instanceof Relation && (fromObjectUsage = this.findColumnInRelation(string, bl, (Relation)schemaObject)) != null) {
                fromObjectUsage.setFromObjectID(fromObject.getID());
            }
        } else if (sQLFragment instanceof SQLQuery) {
            SQLQuery sQLQuery = (SQLQuery)sQLFragment;
            fromObjectUsage = this.isSelectStar(sQLQuery) ? this.findColumnInFromObjects(string, bl, sQLQuery.getFromObjects(), false, false, null) : this.findColumnInSubQuery(string, bl, sQLQuery);
        } else if (sQLFragment instanceof JoinObject) {
            fromObjectUsage = this.findColumnInJoin(string, bl, (JoinObject)sQLFragment, bl2, sQLFragment2);
        } else if (sQLFragment instanceof ColumnUsage) {
            fromObjectUsage = this.findColumnInColumnUsage(string, bl, (ColumnUsage)sQLFragment, fromObject);
        } else if (sQLFragment instanceof Function && "TABLE".equals(((Function)sQLFragment).getFunction())) {
            fromObjectUsage = this.findColumnInTableFunction(string, bl, (Function)sQLFragment, fromObject);
        }
        return fromObjectUsage;
    }

    protected FromObjectUsage findColumnInColumnUsage(String string, boolean bl, ColumnUsage columnUsage, FromObject fromObject) {
        DataTypeUsage dataTypeUsage;
        DBObjectID dBObjectID = columnUsage.getObjectID();
        Column column = (Column)this.resolveID(dBObjectID);
        if (column != null && (dataTypeUsage = column.getDataTypeUsage()) != null) {
            DBObjectID dBObjectID2;
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dataTypeUsage, false);
            }
            catch (DBException dBException) {
                this.logResolveIDException(dBException);
            }
            if (dataType != null && (dBObjectID2 = this.getTypeMemberID(dataType, string, bl)) != null) {
                return new PlSqlUsage(dBObjectID2, fromObject.getID());
            }
        }
        return null;
    }

    protected FromObjectUsage findColumnInTableFunction(String string, boolean bl, Function function, FromObject fromObject) {
        DBObjectID dBObjectID;
        if (function != null && (dBObjectID = function.getDataTypeID()) != null) {
            DBObjectID dBObjectID2;
            DBObject dBObject = null;
            try {
                dBObject = dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                this.logResolveIDException(dBException);
            }
            if (dBObject instanceof DataType && (dBObjectID2 = this.getTypeMemberID((DataType)dBObject, string, bl)) != null) {
                return new PlSqlUsage(dBObjectID2, fromObject.getID());
            }
        }
        return null;
    }

    private DBObjectID getTypeMemberID(DataType dataType, String string, boolean bl) {
        PlSqlDatatype.Structure structure;
        String string2;
        DBObjectID dBObjectID = null;
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        String string3 = string2 = bl ? abstractDBObjectProvider.getInternalName(string) : string;
        if (dataType instanceof Type) {
            Object object;
            AbstractDBObject abstractDBObject;
            Type type = (Type)dataType;
            if ("COLLECTION".equals(type.getTypeCode()) && (abstractDBObject = type.getOfTypeUsage()) != null && (object = ((DataTypeUsage)abstractDBObject).getDataTypeID()) != null) {
                try {
                    DataType dataType2 = (DataType)object.resolveID();
                    if (dataType2 instanceof Type) {
                        type = (Type)dataType2;
                    }
                }
                catch (DBException dBException) {
                    this.logResolveIDException(dBException);
                }
            }
            if ((abstractDBObject = type.getAttribute(string2)) != null) {
                dBObjectID = abstractDBObject.getID();
                if (dBObjectID == null) {
                    dBObjectID = new ReferenceID((DBObject)abstractDBObject, (DBObjectProvider)abstractDBObjectProvider);
                }
            } else {
                object = type.getMethod(string2);
                if (object != null && (dBObjectID = ((AbstractDBObject)object).getID()) == null) {
                    dBObjectID = new ReferenceID((DBObject)object, (DBObjectProvider)abstractDBObjectProvider);
                }
            }
        } else if (dataType instanceof PlSqlDatatype && (structure = ((PlSqlDatatype)dataType).getStructure()) != PlSqlDatatype.Structure.SCALAR) {
            ReferenceID referenceID = new ReferenceID("TypeAttribute", (Schema)null, string2);
            referenceID.setProvider(abstractDBObjectProvider);
            dBObjectID = referenceID;
        }
        return dBObjectID;
    }

    protected FromObjectUsage findColumnInJoin(String string, boolean bl, JoinObject joinObject, boolean bl2, SQLFragment sQLFragment) throws SQLQueryException {
        if ((joinObject.isNatural() || joinObject.getCondition() instanceof UsingJoinCondition) && ModelUtil.hasLength((String)string)) {
            try {
                FromObject fromObject;
                FromObjectUsage fromObjectUsage;
                FromObject fromObject2 = joinObject.getLeftExpression();
                FromObjectUsage fromObjectUsage2 = this.findColumnInFromObjects(string, bl, new FromObject[]{fromObject2}, true, false, null);
                if (fromObjectUsage2 != null && (fromObjectUsage = this.findColumnInFromObjects(string, bl, new FromObject[]{fromObject = joinObject.getLeftExpression()}, true, false, null)) != null) {
                    bl2 = true;
                }
            }
            catch (SQLQueryException sQLQueryException) {
                this.getLogger().warning("Error checking usages: " + sQLQueryException.getMessage());
            }
        }
        return this.findColumnInFromObjects(string, bl, new FromObject[]{joinObject.getLeftExpression(), joinObject.getRightExpression()}, bl2, false, sQLFragment);
    }

    public FromObjectUsage findColumnInRelation(String string, boolean bl, RelationUsage relationUsage) throws SQLQueryException {
        this.checkCancelled();
        DBObjectID dBObjectID = relationUsage.getObjectID();
        Relation relation = (Relation)this.resolveID(dBObjectID);
        FromObjectUsage fromObjectUsage = this.findColumnInRelation(string, bl, relation);
        if (fromObjectUsage != null) {
            fromObjectUsage.setFromObjectID(relationUsage.getParent().getID());
        }
        return fromObjectUsage;
    }

    public FromObjectUsage findColumnInRelation(String string, boolean bl, Relation relation) throws SQLQueryException {
        this.checkCancelled();
        if (relation != null) {
            AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
            String string2 = bl ? this.getInternalName(string) : string;
            Column column = (Column)DBUtil.findChildByName(relation, "columns", string2, true, abstractDBObjectProvider);
            this.checkCancelled();
            if (column != null) {
                DBObjectID dBObjectID = column.getID();
                if (dBObjectID == null) {
                    this.throwException(new IDException(column));
                }
                ColumnUsage columnUsage = new ColumnUsage(dBObjectID);
                columnUsage.setProvider(abstractDBObjectProvider);
                return columnUsage;
            }
        }
        return null;
    }

    private boolean isSelectStar(SQLQuery sQLQuery) {
        boolean bl = false;
        SelectObject[] selectObjectArray = sQLQuery.getSelectObjects();
        if (selectObjectArray.length == 1 && "*".equals(selectObjectArray[0].getSQLText())) {
            bl = true;
        }
        return bl;
    }

    public SelectObjectUsage findColumnInSubQuery(String string, boolean bl, SQLQuery sQLQuery) throws SQLQueryException {
        SelectObject[] selectObjectArray = SQLFragmentUtils.getSelectObjects(sQLQuery);
        for (int i = 0; i < selectObjectArray.length; ++i) {
            String string2;
            String string3 = selectObjectArray[i].getUsableAlias();
            if (string3 == null) continue;
            int n = string3.lastIndexOf(".");
            if (n > -1) {
                string3 = string3.substring(n + 1);
            }
            DatabaseDescriptor databaseDescriptor = this.getProvider().getDescriptor();
            String string4 = string2 = bl ? string : databaseDescriptor.getExternalName(string, "COLUMN");
            if (!databaseDescriptor.areNamesEqual(string2, string3, "COLUMN", true)) continue;
            return new SelectObjectUsage(selectObjectArray[i], (FromObject)sQLQuery.getParent());
        }
        return null;
    }

    public ColumnUsage findColumnInStarSubQuery(String string, boolean bl, FromObject fromObject) throws SQLQueryException {
        AbstractSQLFragment abstractSQLFragment;
        SQLFragment sQLFragment = fromObject.getExpression();
        if (sQLFragment instanceof WithClauseUsage) {
            abstractSQLFragment = ((WithClauseUsage)sQLFragment).resolveFromObject();
            sQLFragment = ((AbstractAliasFragment)abstractSQLFragment).getExpression();
        }
        abstractSQLFragment = (SQLQuery)sQLFragment;
        SelectObject[] selectObjectArray = ((SQLQuery)abstractSQLFragment).getSelectObjects();
        for (int i = 0; i < selectObjectArray.length; ++i) {
            FromObjectUsage fromObjectUsage;
            String string2 = selectObjectArray[i].getExpression().getSQLText();
            int n = string2.lastIndexOf(".");
            if (n > -1) {
                string2 = string2.substring(n + 1);
            }
            if (!string2.equals("*") || !((fromObjectUsage = this.findColumnInFromObjects(string, bl, ((SQLQuery)abstractSQLFragment).getFromObjects(), true, false, null)) instanceof ColumnUsage)) continue;
            ColumnUsage columnUsage = (ColumnUsage)fromObjectUsage;
            columnUsage.setFromObjectID(fromObject.getID());
            return columnUsage;
        }
        return null;
    }

    @Override
    public void setHierarchicalQueryObject(HierarchicalQueryObject hierarchicalQueryObject) {
        HierarchicalQueryObject hierarchicalQueryObject2 = this.m_query.getHierarchicalQueryObject();
        this.unloadObject(hierarchicalQueryObject2);
        this.m_query.setHierarchicalQueryObject(hierarchicalQueryObject);
        if (hierarchicalQueryObject != null) {
            SQLFragment sQLFragment = hierarchicalQueryObject.getConnectBy();
            SQLFragment sQLFragment2 = hierarchicalQueryObject.getStartWith();
            this.loadObject(sQLFragment);
            this.loadObject(sQLFragment2);
        }
    }

    @Override
    public void setGroupByObject(GroupByObject groupByObject) {
        GroupByObject groupByObject2 = this.m_query.getGroupByObject();
        this.unloadObject(groupByObject2);
        this.m_query.setGroupByObject(groupByObject);
        if (groupByObject != null) {
            SQLFragment[] sQLFragmentArray = groupByObject.getExpressions();
            for (int i = 0; sQLFragmentArray != null && i < sQLFragmentArray.length; ++i) {
                this.loadObject(sQLFragmentArray[i]);
            }
            WhereObject whereObject = groupByObject.getHaving();
            if (whereObject != null) {
                this.loadObject(whereObject);
            }
        }
    }

    private boolean isGroupingFunction(SQLFragment sQLFragment) {
        boolean bl = false;
        if (sQLFragment instanceof Function) {
            DBObject[] dBObjectArray = (DBObject[])sQLFragment;
            bl = dBObjectArray.isGrouping();
        }
        if (!bl) {
            for (DBObject dBObject : sQLFragment.getOwnedObjects("SQLFragment")) {
                if (!(dBObject instanceof SQLFragment) || !this.isGroupingFunction((SQLFragment)dBObject)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean canSetGroupBy() {
        if (this.supportsGroupBy()) {
            SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
            for (int i = 0; selectObjectArray != null && i < selectObjectArray.length; ++i) {
                SQLFragment sQLFragment = selectObjectArray[i].getExpression();
                if (!this.isGroupingFunction(sQLFragment)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addGroupByColumn(SQLFragment sQLFragment) {
        this.addGroupByColumn(-1, sQLFragment);
    }

    @Override
    public void addGroupByColumn(int n, SQLFragment sQLFragment) {
        FromObjectUsage fromObjectUsage;
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        if (groupByObject == null) {
            groupByObject = new GroupByObject();
            this.m_query.setGroupByObject(groupByObject);
        }
        if (sQLFragment instanceof FromObjectUsage && (this.isUsedInUsing(fromObjectUsage = (FromObjectUsage)sQLFragment) || this.isUsedInNatural(fromObjectUsage))) {
            fromObjectUsage.setQualified(false);
        }
        if (n == -1) {
            groupByObject.addExpression(sQLFragment);
        } else {
            groupByObject.addExpression(n, sQLFragment);
        }
        this.loadObject(sQLFragment);
    }

    @Override
    public boolean removeGroupByColumn(SQLFragment sQLFragment) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        if (groupByObject != null && groupByObject.removeExpression(sQLFragment)) {
            this.unloadObject(sQLFragment);
            return true;
        }
        return false;
    }

    @Override
    public SQLFragment parseHavingExpression(String string) throws SQLQueryException {
        return this.parseWhereExpression(string);
    }

    @Override
    public final SQLFragment parseOrderByExpression(String string) throws SQLQueryException {
        return this.parseOrderByExpression(string, null);
    }

    protected SQLFragment parseOrderByExpression(String string, OrderByObject orderByObject) throws SQLQueryException {
        return this.parseSelectExpression(string, null);
    }

    @Override
    public void setHavingObject(WhereObject whereObject) {
        GroupByObject groupByObject = this.m_query.getGroupByObject();
        groupByObject.getHaving();
        this.unloadObject(groupByObject);
        groupByObject.setHaving(whereObject);
        if (whereObject != null) {
            this.loadObject(whereObject);
        }
    }

    @Override
    public void addOrderByObject(OrderByObject orderByObject) {
        this.m_query.addOrderByObject(orderByObject);
        this.loadObject(orderByObject);
        this.checkUsageQualifications();
    }

    @Override
    public void addOrderByObject(int n, OrderByObject orderByObject) {
        this.m_query.addOrderByObject(n, orderByObject);
        this.loadObject(orderByObject);
        this.checkUsageQualifications();
    }

    @Override
    public boolean removeOrderByObject(OrderByObject orderByObject) {
        if (this.m_query.removeOrderByObject(orderByObject)) {
            this.unloadObject(orderByObject);
            return true;
        }
        return false;
    }

    @Override
    public void replaceOrderByObject(OrderByObject orderByObject, OrderByObject orderByObject2) {
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2 = orderByObject.getExpression();
        if (ModelUtil.areDifferent((Object)sQLFragment2, (Object)(sQLFragment = orderByObject2.getExpression()))) {
            this.unloadObject(orderByObject);
            orderByObject2.copyTo(orderByObject);
            this.loadObject(sQLFragment);
        }
        this.checkUsageQualifications();
    }

    @Override
    public void setOrderByObjects(OrderByObject[] orderByObjectArray) {
        OrderByObject[] orderByObjectArray2 = this.m_query.getOrderByObjects();
        for (int i = 0; orderByObjectArray2 != null && i < orderByObjectArray2.length; ++i) {
            this.unloadObject(orderByObjectArray2[i]);
        }
        this.m_query.setOrderByObjects(orderByObjectArray);
        this.loadObjects(orderByObjectArray);
    }

    @Override
    @Deprecated
    public void syncViewColumns() throws AliasInUseException {
    }

    public String getColumnName(SelectObject selectObject) {
        String string = null;
        if (ModelUtil.hasLength((String)selectObject.getAlias())) {
            string = selectObject.getAlias();
        } else {
            SQLFragment sQLFragment = selectObject.getExpression();
            if (sQLFragment != null) {
                string = selectObject.getUsableAlias();
            }
            if (sQLFragment instanceof AbstractFromObjectUsage && string != null && string.contains(".")) {
                string = string.substring(string.indexOf(".") + 1);
            }
        }
        string = this.getInternalName(string);
        return string;
    }

    public void checkUsageQualifications() {
        QueryCache queryCache = this.getCache();
        if (queryCache.m_fromDeps.size() > 0) {
            for (Map.Entry<FromObject, Collection<SQLFragment>> entry : queryCache.m_fromDeps.entrySet()) {
                for (SQLFragment sQLFragment : entry.getValue()) {
                    if (!(sQLFragment instanceof FromObjectUsage)) continue;
                    FromObjectUsage fromObjectUsage = (FromObjectUsage)sQLFragment;
                    boolean bl = this.isUsedInUsing(fromObjectUsage) || this.isUsedInNatural(fromObjectUsage);
                    boolean bl2 = fromObjectUsage.getParent() instanceof UsingJoinCondition;
                    if (fromObjectUsage.isQualified() && bl || bl2) {
                        fromObjectUsage.setQualified(false);
                        continue;
                    }
                    if (fromObjectUsage.isQualified() || bl) continue;
                    String string = fromObjectUsage.getColumnName();
                    try {
                        this.findColumnInFromObjects(string, false, null, new FromObject[0]);
                    }
                    catch (AmbiguousColumnException ambiguousColumnException) {
                        fromObjectUsage.setQualified(true);
                    }
                    catch (SQLQueryException sQLQueryException) {
                        this.getLogger().warning("couldn't check usages: " + sQLQueryException.getMessage());
                    }
                }
            }
        }
    }

    private boolean isUsedInUsing(FromObjectUsage fromObjectUsage) {
        DBObjectID dBObjectID;
        boolean bl = false;
        QueryCache queryCache = this.getCache();
        if (queryCache.m_usings.size() > 0 && fromObjectUsage instanceof DBObjectUsage && (dBObjectID = ((DBObjectUsage)((Object)fromObjectUsage)).getObjectID()) != null) {
            for (UsingJoinCondition usingJoinCondition : queryCache.m_usings) {
                FromObjectUsage[] fromObjectUsageArray = usingJoinCondition.getColumns();
                for (int i = 0; i < fromObjectUsageArray.length; ++i) {
                    if (!(fromObjectUsageArray[i] instanceof DBObjectUsage)) continue;
                    DBObjectID dBObjectID2 = ((DBObjectUsage)((Object)fromObjectUsageArray[i])).getObjectID();
                    if (dBObjectID.equals(dBObjectID2, false)) {
                        bl = true;
                        continue;
                    }
                    JoinObject joinObject = (JoinObject)usingJoinCondition.getParent();
                    String string = fromObjectUsageArray[i].getColumnName();
                    bl = this.isPresentInFrom(dBObjectID, string, joinObject.getLeftExpression()) || this.isPresentInFrom(dBObjectID, string, joinObject.getRightExpression());
                }
            }
        }
        return bl;
    }

    private boolean isPresentInFrom(DBObjectID dBObjectID, String string, FromObject fromObject) {
        boolean bl = false;
        try {
            DBObjectID dBObjectID2;
            FromObjectUsage fromObjectUsage = this.findColumnInFromObjects(string, false, new FromObject[]{fromObject}, true, false, null);
            if (fromObjectUsage != null && fromObjectUsage instanceof DBObjectUsage && dBObjectID.equals(dBObjectID2 = ((DBObjectUsage)((Object)fromObjectUsage)).getObjectID(), false)) {
                bl = true;
            }
        }
        catch (SQLQueryException sQLQueryException) {
            // empty catch block
        }
        return bl;
    }

    private boolean isUsedInNatural(FromObjectUsage fromObjectUsage) {
        QueryCache queryCache = this.getCache();
        if (queryCache.m_naturalJoins.size() > 0 && fromObjectUsage instanceof DBObjectUsage) {
            DBObjectID dBObjectID = ((DBObjectUsage)((Object)fromObjectUsage)).getObjectID();
            String string = null;
            DBObject dBObject = this.resolveID(dBObjectID);
            if (dBObject instanceof Column) {
                string = dBObject.getName();
            }
            if (ModelUtil.hasLength(string)) {
                for (JoinObject joinObject : queryCache.m_naturalJoins) {
                    try {
                        FromObject fromObject;
                        FromObjectUsage fromObjectUsage2;
                        FromObject fromObject2 = joinObject.getLeftExpression();
                        FromObjectUsage fromObjectUsage3 = this.findColumnInFromObjects(string, false, new FromObject[]{fromObject2}, false, false, null);
                        if (fromObjectUsage3 == null || (fromObjectUsage2 = this.findColumnInFromObjects(string, false, new FromObject[]{fromObject = joinObject.getRightExpression()}, false, false, null)) == null) continue;
                        return true;
                    }
                    catch (SQLQueryException sQLQueryException) {
                        this.getLogger().warning("Error checking usages: " + sQLQueryException.getMessage());
                    }
                }
            }
        }
        return false;
    }

    private void checkSelectObject(SelectObject selectObject) throws SQLQueryException {
        SQLFragment sQLFragment = selectObject.getExpression();
        if (sQLFragment == null) {
            this.throwException(new SQLQueryException(selectObject, APIBundle.get("SQL_EMPTY_EXP")));
        }
        if (sQLFragment instanceof FromObjectUsage) {
            FromObjectUsage fromObjectUsage = (FromObjectUsage)sQLFragment;
            boolean bl = this.isUsedInUsing(fromObjectUsage);
            boolean bl2 = this.isUsedInNatural(fromObjectUsage);
            if (fromObjectUsage.isQualified() && (bl || bl2)) {
                fromObjectUsage.setQualified(false);
            }
        } else if (this.m_query.getParent() instanceof SQLQueryOwner) {
            if (!ModelUtil.hasLength((String)selectObject.getAlias())) {
                this.setAliasFromColumn(selectObject);
            }
            if (!ModelUtil.hasLength((String)selectObject.getAlias())) {
                this.throwException(new SQLQueryClauseException(selectObject, APIBundle.format("SQL_EXP_REQUIRE_ALIAS", sQLFragment.getSQLText())));
            }
        }
    }

    @Override
    public final SQLFragment parseFromExpression(String string) throws SQLQueryException {
        return this.parseFromExpression(string, null);
    }

    protected SQLFragment parseFromExpression(String string, FromObject fromObject) throws SQLQueryException {
        return null;
    }

    @Override
    public final SQLFragment parseSelectExpression(String string) throws SQLQueryException {
        return this.parseSelectExpression(string, null);
    }

    protected SQLFragment parseSelectExpression(String string, SelectObject selectObject) throws SQLQueryException {
        throw new SQLQueryException(APIBundle.get("SQL_QUERY_PARSE_NONE"));
    }

    @Override
    public final SQLFragment parseWhereExpression(String string) throws SQLQueryException {
        return this.parseWhereExpression(string, null);
    }

    public SQLFragment parseWhereExpression(String string, WhereObject whereObject) throws SQLQueryException {
        throw new SQLQueryException(APIBundle.get("SQL_QUERY_PARSE_NONE"));
    }

    @Override
    public Column[] getColumns() throws DBException {
        if (this.m_query == null) {
            throw new IllegalStateException("Must built a valid query first");
        }
        ArrayList<Column> arrayList = new ArrayList<Column>();
        if (this.m_query.getSQLText() != null) {
            try {
                boolean bl = this.containsAsterisk();
                if (bl) {
                    if (this.getProvider() instanceof Database && (this.m_extraObjects == null || this.m_extraObjects.isEmpty())) {
                        return this.getColumnsFromResultSet();
                    }
                    this.ensureComponent(this.m_query, "selectObjects");
                }
                int n = 0;
                if (this.m_query.isDeclarative() && !DBUtil.needsBuilding(this.m_query, "selectObjects")) {
                    List<SelectObject> list = bl ? SQLFragmentUtils.expandStarColumns(this.m_query) : Arrays.asList(this.m_query.getSelectObjects());
                    for (SelectObject selectObject : list) {
                        int n2;
                        String string = selectObject.getUsableAlias();
                        if (string != null && (n2 = string.lastIndexOf(".")) > -1) {
                            string = string.substring(n2 + 1);
                        }
                        string = this.getProvider().getInternalName(string);
                        arrayList.add(this.newViewColumn(string, n++));
                    }
                } else if (this.getProvider() instanceof Database) {
                    return this.getColumnsFromResultSet();
                }
                if (n == 0) {
                    for (QueryColumnInfo queryColumnInfo : this.getQueryColumnInfos()) {
                        arrayList.add(this.newViewColumn(queryColumnInfo.getName(), n++));
                    }
                }
            }
            catch (SQLQueryException sQLQueryException) {
                if (this.getProvider() instanceof Database && !this.matchesProvider()) {
                    return this.getColumnsFromResultSet();
                }
                throw sQLQueryException;
            }
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    protected Column[] getColumnsFromResultSet() throws DBException {
        return new Column[0];
    }

    private Column newViewColumn(String string, int n) {
        Column column = new Column();
        column.setName(string);
        column.setID(TemporaryObjectID.createID(column));
        this.getProvider().getObjectFactory().setDerivedPropertyBuilder(column, this.getDTUBuilder(n));
        return column;
    }

    protected abstract DerivedPropertyBuilder getDTUBuilder(int var1);

    protected abstract boolean containsAsterisk() throws SQLQueryException;

    public abstract List<QueryColumnInfo> getQueryColumnInfos() throws SQLQueryException;

    protected void setViewColDataType(Column column, SelectObject selectObject) {
        DataTypeUsage dataTypeUsage;
        DBObject dBObject;
        SQLFragment sQLFragment;
        SQLFragment sQLFragment2 = sQLFragment = selectObject == null ? null : selectObject.getExpression();
        if (sQLFragment instanceof ColumnUsage && (dBObject = this.resolveID(((ColumnUsage)sQLFragment).getObjectID())) instanceof Column && (dataTypeUsage = ((Column)dBObject).getDataTypeUsage()) != null) {
            DataTypeUsage dataTypeUsage2 = (DataTypeUsage)dataTypeUsage.copyTo(null);
            dataTypeUsage2.setID(null);
            column.setDataTypeUsage(dataTypeUsage2);
        }
    }

    public void setSingleRelation(Relation relation) {
        this.m_extraObjects = null;
        TemporaryObjectID.setID(relation, true);
        this.addExtraObject(relation);
    }

    public void setExtraObjects(Collection<? extends SystemObject> collection) {
        this.m_extraObjects = collection;
    }

    protected void addExtraObject(SystemObject systemObject) {
        if (systemObject != null) {
            ArrayList<SystemObject> arrayList = this.m_extraObjects == null ? new ArrayList<SystemObject>() : new ArrayList<SystemObject>(this.m_extraObjects);
            arrayList.add(systemObject);
            this.setExtraObjects(arrayList);
        }
    }

    private Relation findExtraRelation(DBObjectID dBObjectID) {
        if (this.m_extraObjects != null && dBObjectID != null) {
            for (SystemObject systemObject : this.m_extraObjects) {
                if (!(systemObject instanceof Relation) || !dBObjectID.equals(systemObject.getID())) continue;
                return (Relation)systemObject;
            }
        }
        return null;
    }

    protected SchemaObject getObjectForFrom(String string, String string2, String string3) throws DBException {
        Collection<String> collection;
        String string4;
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        Collection<String> collection2 = DBUtil.listSupportedTypes(abstractDBObjectProvider, Relation.class, Synonym.class);
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createTypeCriteria(collection2);
        dBObjectCriteria.setName(string2);
        dBObjectCriteria.setDatabaseName(string3);
        if (string == null && string3 == null) {
            dBObjectCriteria.setSchema(this.getDefaultSchema());
        } else {
            dBObjectCriteria.setSchemaName(string);
        }
        SchemaObject schemaObject = this.getObject(dBObjectCriteria);
        if (schemaObject == null && (string4 = abstractDBObjectProvider.getDescriptor().getPublicSchemaName()) != null && !(collection = DBUtil.listSupportedTypes(abstractDBObjectProvider, Synonym.class)).isEmpty()) {
            DBObjectCriteria<SystemObject> dBObjectCriteria2 = DBObjectCriteria.createTypeCriteria(collection);
            dBObjectCriteria2.setName(string2);
            dBObjectCriteria2.setDatabaseName(string3);
            dBObjectCriteria2.setSchemaName(string4);
            schemaObject = this.getObject(dBObjectCriteria2);
        }
        return schemaObject;
    }

    protected DBObject resolveID(DBObjectID dBObjectID) {
        DBObject dBObject = null;
        if (dBObjectID != null) {
            try {
                DBObjectID dBObjectID2 = dBObjectID.getParent();
                if (dBObjectID2 == null) {
                    if (this.m_extraObjects != null) {
                        for (DBObject dBObject2 : this.m_extraObjects) {
                            if (!dBObjectID.equals(dBObject2.getID())) continue;
                            dBObject = dBObject2;
                            break;
                        }
                    }
                    if (dBObject == null) {
                        dBObject = dBObjectID.resolveID();
                    }
                } else if (dBObjectID instanceof AbstractDBObjectID) {
                    DBObject dBObject3 = this.resolveID(dBObjectID2);
                    if (dBObject3 != null) {
                        dBObject = ((AbstractDBObjectID)dBObjectID).resolveInParentObject(dBObject3);
                    }
                } else {
                    dBObject = dBObjectID.resolveID();
                }
            }
            catch (DBException dBException) {
                this.logResolveIDException(dBException);
            }
        }
        return dBObject;
    }

    protected SchemaObject getObject(String string, Schema schema, String string2) throws DBException {
        return this.getObject(DBObjectCriteria.createSingleObjectCriteria(string, schema, string2));
    }

    protected SchemaObject getObject(DBObjectCriteria dBObjectCriteria) throws DBException {
        this.checkCancelled();
        SchemaObject schemaObject = null;
        AbstractDBObjectProvider abstractDBObjectProvider = this.getProvider();
        if (abstractDBObjectProvider != null) {
            dBObjectCriteria.setDatabaseDescriptor(abstractDBObjectProvider.getDescriptor());
        }
        if (this.m_extraObjects != null && dBObjectCriteria.getDatabaseName() == null) {
            String string = dBObjectCriteria.getTypeArray()[0];
            Schema schema = new Schema(dBObjectCriteria.getSchemaName());
            for (SystemObject systemObject : this.m_extraObjects) {
                if (!dBObjectCriteria.accept(systemObject)) continue;
                schemaObject = (SchemaObject)systemObject;
                break;
            }
        }
        if (schemaObject == null && abstractDBObjectProvider != null) {
            schemaObject = (SchemaObject)abstractDBObjectProvider.getObject(dBObjectCriteria);
        }
        return schemaObject;
    }

    @Override
    public void registerSQLFragmentFactory(SQLFragmentFactory sQLFragmentFactory) {
        this.m_sqlFragFactories.add(0, sQLFragmentFactory);
    }

    protected void registerAllSQLFragmentFactories(AbstractSQLQueryBuilder abstractSQLQueryBuilder) {
        this.m_sqlFragFactories.clear();
        this.m_sqlFragFactories.addAll(abstractSQLQueryBuilder.m_sqlFragFactories);
    }

    public final SQLFragment createFromFactory(SQLFragment sQLFragment, String string, Integer n) {
        SQLFragment sQLFragment2 = null;
        for (SQLFragmentFactory sQLFragmentFactory : this.m_sqlFragFactories) {
            sQLFragment2 = sQLFragmentFactory.createFragment(this, sQLFragment, string);
            if (sQLFragment2 == null) continue;
            if (!(sQLFragment2 instanceof AbstractSQLFragment) || n == null || n == -1) break;
            ((AbstractSQLFragment)sQLFragment2).setStartOffset(n);
            break;
        }
        return sQLFragment2;
    }

    private void setAliasFromColumn(SelectObject selectObject) {
        Relation relation;
        if (selectObject.getAlias() == null && this.getProvider() instanceof Database && this.getQuery().getParent() instanceof Relation && this.getQuery().getParent().getID() instanceof TemporaryObjectID && (relation = (Relation)TemporaryObjectID.findOriginalObject(this.getQuery().getParent())) != null) {
            String string = selectObject.getSQLText();
            try {
                SQLQuery sQLQuery = ((SQLQueryOwner)((Object)relation)).getSQLQuery();
                DBUtil.ensureDerivedPropertiesBuilt(sQLQuery, this.getProvider());
                SelectObject[] selectObjectArray = sQLQuery.getSelectObjects();
                for (int i = 0; i < selectObjectArray.length; ++i) {
                    String string2 = selectObjectArray[i].getSQLText();
                    if (!string.equals(string2)) continue;
                    selectObject.setAlias(relation.getColumns()[i].getName());
                    break;
                }
            }
            catch (Exception exception) {
                DBLog.getLogger(this).warning("failed looking for usable alias for " + selectObject.getSQLText() + ":" + exception.getMessage());
            }
        }
    }

    @Override
    @Deprecated
    public FunctionDefinition[] getBuiltInFunctions() {
        throw new UnsupportedOperationException("Get BuiltInFunction definitions from the descriptor");
    }

    static boolean isBuilding(SQLQuery sQLQuery) {
        return s_currentQueries.contains(sQLQuery);
    }

    public static class QueryColumnInfo {
        private final String m_name;
        private final String m_expression;

        public QueryColumnInfo(String string, String string2) {
            this.m_name = string;
            this.m_expression = string2;
        }

        public String getName() {
            return this.m_name;
        }

        public String getExpression() {
            return this.m_expression;
        }
    }

    private class QueryCache {
        private final Map<FromObject, Collection<SQLFragment>> m_fromDeps = new IdentityHashMap<FromObject, Collection<SQLFragment>>();
        private final Map<SQLFragment, FromObject> m_rFromDeps = new IdentityHashMap<SQLFragment, FromObject>();
        private Collection<UsingJoinCondition> m_usings = new IdentitySet<UsingJoinCondition>();
        private Collection<JoinObject> m_naturalJoins = new IdentitySet<JoinObject>();

        private QueryCache() {
        }
    }

    private class SQLQueryObjectSetImpl
    implements SQLQueryBuilder.SQLQueryObjectSet {
        private AbstractSQLFragment m_object;
        private SelectObject[] m_selectObjs;
        private FromObject[] m_fromObjs;

        public SQLQueryObjectSetImpl(SelectObject[] selectObjectArray, FromObject[] fromObjectArray) {
            this.m_selectObjs = selectObjectArray == null ? new SelectObject[]{} : selectObjectArray;
            this.m_fromObjs = fromObjectArray == null ? new FromObject[]{} : fromObjectArray;
        }

        public SQLQueryObjectSetImpl(SelectObject[] selectObjectArray, FromObject[] fromObjectArray, SQLFragment sQLFragment) {
            this(selectObjectArray, fromObjectArray);
            this.m_object = (AbstractSQLFragment)sQLFragment;
        }

        @Override
        public SQLFragment getObject() {
            return this.m_object;
        }

        @Override
        public SelectObject[] getSelectObjects() {
            return this.m_selectObjs;
        }

        @Override
        public FromObject[] getFromObjects() {
            return this.m_fromObjs;
        }
    }
}

