/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;

public abstract class AbstractSQLFragment
extends AbstractChildBuildableObject
implements SQLFragment {
    protected static final SQLFragment[] EMPTY_ARRAY = new SQLFragment[0];
    protected static final String DEFAULT_SEPARATOR = ", ";
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";
    protected static final String NEWLINE = "\n";
    protected static final String INDENT = "    ";
    protected static final String COMMA = ",";
    protected static final String AS = "AS";
    protected static final String LEFT_PAREN = "(";
    protected static final String RIGHT_PAREN = ")";
    private Integer m_startOffset = null;

    protected AbstractSQLFragment() {
    }

    @Override
    public String getType() {
        return "SQLFragment";
    }

    protected String getTextOrNull(SQLFragment sQLFragment) {
        return this.getTextOrNull(sQLFragment, false);
    }

    protected String getTextOrNull(SQLFragment sQLFragment, boolean bl) {
        String string = null;
        if (sQLFragment != null && (string = sQLFragment.getSQLText()) != null) {
            if (sQLFragment instanceof SQLQuery) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(LEFT_PAREN).append(NEWLINE);
                this.appendToBuffer(stringBuilder, string, INDENT);
                stringBuilder.append(NEWLINE).append(RIGHT_PAREN);
                string = stringBuilder.toString();
            } else if (bl) {
                string = this.surroundWithBrackets(string.trim());
            }
        }
        return string;
    }

    protected String argsToString(Collection collection, boolean bl, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (collection != null) {
            boolean bl2 = !bl && collection.size() > 1 && string != DEFAULT_SEPARATOR;
            int n2 = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SQLFragment sQLFragment = (SQLFragment)iterator.next();
                if (n2++ < n) continue;
                boolean bl3 = bl2 && (sQLFragment == null || sQLFragment.getClass().equals(this.getClass()));
                String string2 = this.getTextOrNull(sQLFragment, bl3);
                stringBuilder.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected String surroundWithBrackets(String string) {
        return this.surroundWithBrackets(string, false);
    }

    protected String surroundWithBrackets(String string, boolean bl) {
        boolean bl2 = true;
        String string2 = string.trim();
        if (!bl && string2.length() > 0 && string2.charAt(0) == '(') {
            bl2 = false;
            int n = 1;
            for (int i = 1; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == ')') {
                    --n;
                } else if (c == '(') {
                    ++n;
                }
                if (n > 0 || i >= string2.length() - 1) continue;
                bl2 = true;
                break;
            }
            if (n != 0) {
                bl2 = true;
            }
        }
        return bl2 ? LEFT_PAREN + string + RIGHT_PAREN : string;
    }

    protected void appendToBuffer(StringBuilder stringBuilder, Collection collection, String string) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SQLFragment sQLFragment = (SQLFragment)iterator.next();
                this.appendToBuffer(stringBuilder, sQLFragment.getSQLText(), string);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", \n");
            }
        }
    }

    protected final void appendToBuffer(StringBuilder stringBuilder, String string, String string2) {
        if (string != null) {
            if (string2 != null) {
                stringBuilder.append(string2);
                string = string.replaceAll(NEWLINE, NEWLINE + string2);
            }
            stringBuilder.append(string);
        }
    }

    @Override
    public String toString() {
        return this.getSQLText();
    }

    @Override
    @Internal
    public Integer getStartOffset() {
        return (Integer)this.getProperty("startOffset");
    }

    public void setStartOffset(Integer n) {
        this.setProperty("startOffset", n);
    }

    @Override
    @Internal
    public String getName() {
        return super.getName();
    }
}

