/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MetadataGenerator;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

class MetadataImpl {
    static final String LIST_FILE_NAME = "beans.bin";
    private final Collection<Class<? extends Copyable>> m_beans = new ArrayList<Class<? extends Copyable>>();
    private boolean m_beansLoaded;
    private final MultiMap<String, PropertyInfo> m_extraProps = new MultiMap();
    private Collection<Iterable<? extends PropertyInfo>> m_lazyExtraProps = new ArrayList<Iterable<? extends PropertyInfo>>();
    private boolean m_extraPropsLoaded;
    private Map<String, Class<? extends DBObject>> m_typeMap;
    private MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_implementations;

    MetadataImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<? extends Copyable>> getBeans() {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            if (!this.m_beansLoaded) {
                for (String string : Property.BEANS) {
                    try {
                        Class<?> clazz = Class.forName(string);
                        this.m_beans.add(clazz);
                    }
                    catch (Throwable throwable) {
                        MetadataImpl.getLogger().severe("Could not load " + string + " : " + throwable.getMessage());
                    }
                }
                this.m_beansLoaded = true;
            }
        }
        return this.m_beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerExtraProperty(PropertyInfo propertyInfo) {
        if (propertyInfo instanceof PropertyDefinition) {
            propertyInfo = ((PropertyDefinition)propertyInfo).clone();
        }
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            this.m_extraProps.add((Object)propertyInfo.getPropertyName(), (Object)propertyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerExtraProperties(Iterable<? extends PropertyInfo> iterable) {
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            if (this.m_extraPropsLoaded) {
                for (PropertyInfo propertyInfo : iterable) {
                    this.registerExtraProperty(propertyInfo);
                }
            } else {
                this.m_lazyExtraProps.add(iterable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Collection<PropertyInfo>> getExtraProps() {
        MultiMap<String, PropertyInfo> multiMap = this.m_extraProps;
        synchronized (multiMap) {
            if (!this.m_extraPropsLoaded) {
                long l = System.currentTimeMillis();
                for (Class<? extends Copyable> object : this.getBeans()) {
                    try {
                        MetadataGenerator.findExtendedProperties(object, this.m_extraProps);
                    }
                    catch (Exception exception) {
                        MetadataImpl.getLogger().log(Level.SEVERE, "Couldn't load properties for {0}: {1}", new Object[]{object.getSimpleName(), exception.getMessage()});
                    }
                }
                for (Iterable iterable : this.m_lazyExtraProps) {
                    for (PropertyInfo propertyInfo : iterable) {
                        this.registerExtraProperty(propertyInfo);
                    }
                }
                this.m_lazyExtraProps.clear();
                this.timeStop(l, "Reading extra properties");
                this.m_extraPropsLoaded = true;
            }
        }
        return this.m_extraProps;
    }

    public Map<String, Class<? extends DBObject>> getTypeMap() {
        this.initProps();
        return this.m_typeMap;
    }

    public Collection<Class<? extends DBObject>> getImplementations(Class<? extends DBObject> clazz) {
        this.initProps();
        return this.m_implementations.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProps() {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            if (this.m_typeMap == null) {
                long l = System.currentTimeMillis();
                this.m_typeMap = new TreeMap<String, Class<? extends DBObject>>();
                this.m_implementations = new MultiMap(HashSet.class);
                for (Class<? extends Copyable> clazz : this.getBeans()) {
                    this.registerClassProperties(clazz);
                }
                this.timeStop(l, "Registering all properties");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerClass(Class<? extends Copyable> clazz) {
        Collection<Class<? extends Copyable>> collection = this.m_beans;
        synchronized (collection) {
            this.m_beans.add(clazz);
            if (this.m_typeMap != null) {
                this.registerClassProperties(clazz);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerClassProperties(Class<? extends Copyable> clazz) {
        if (DBObject.class.isAssignableFrom(clazz)) {
            Object object;
            Object object2 = null;
            if (DataType.class.equals(clazz)) {
                object = null;
                Iterator<Class<? extends Copyable>> iterator = null;
            } else if (PredefinedDataType.class.equals(clazz)) {
                object = "DATATYPE";
                String string = "DATATYPE";
            } else {
                object = Metadata.getType(clazz);
                try {
                    Field field = clazz.getDeclaredField("TYPE");
                    if (field != null) {
                        String string = (String)field.get(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ModelUtil.hasLength(object)) {
                void var3_7;
                if (ModelUtil.hasLength((String)var3_7)) {
                    if (this.m_typeMap.containsKey(object)) {
                        DBLog.getLogger(this).log(Level.WARNING, "Type \"{0}\" is already registered to \"{1}\"", new Object[]{object, this.m_typeMap.get(object)});
                    } else {
                        this.m_typeMap.put((String)object, clazz);
                    }
                } else {
                    DBLog.getLogger(this).log(Level.FINE, "Type \"{0}\" is not declared on {1}", new Object[]{object, clazz});
                }
            }
            for (Class clazz2 : this.getBeans()) {
                if (!clazz2.isAssignableFrom(clazz) || !DBObject.class.isAssignableFrom(clazz2)) continue;
                this.m_implementations.add((Object)clazz2, clazz);
            }
        }
        if (!Metadata.isRealBean(clazz) && DBObject.class.isAssignableFrom(clazz)) {
            for (Class clazz3 : this.getBeans()) {
                if (clazz == clazz3 || !clazz.isAssignableFrom(clazz3)) continue;
                this.m_implementations.add(clazz, (Object)clazz3);
            }
        }
    }

    private void timeStop(long l, String string) {
        long l2 = System.currentTimeMillis();
        MetadataImpl.getLogger().log(Level.FINE, string + " took {0}ms", l2 - l);
    }

    private static Logger getLogger() {
        return DBLog.getLogger(MetadataImpl.class);
    }

    static BeanInfo getBeanInfo(Class clazz) {
        if (clazz != null && !clazz.isPrimitive() && clazz != String.class) {
            try {
                return Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
        return null;
    }

    static boolean isValidForPropertyInfo(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        Method method2 = propertyDescriptor.getWriteMethod();
        return method != null && method2 != null;
    }
}

