/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Maps;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.deferred.Thunk;

public final class Metadata {
    private MetadataImpl m_impl;
    private final MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_ownerMap = new MultiMap();
    private Map<String, Thunk<Class<? extends DBObject>>> m_extendedTypes;
    private final Map<Class<?>, Map<String, PropertyInfo>> m_descriptorInfos = new Maps.SoftHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata getInstance() {
        DBCore dBCore = DBCore.getInstance();
        Class<Metadata> clazz = Metadata.class;
        synchronized (Metadata.class) {
            Metadata metadata = dBCore.get(Metadata.class);
            if (metadata == null) {
                metadata = new Metadata();
                dBCore.put(metadata);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return metadata;
        }
    }

    private Metadata() {
    }

    private synchronized MetadataImpl getMetadata() {
        if (this.m_impl == null) {
            this.m_impl = new MetadataImpl();
        }
        return this.m_impl;
    }

    public Collection<Class<? extends DBObject>> getAllDBObjectClasses() {
        return Collections.unmodifiableCollection(this.getMetadata().getImplementations(DBObject.class));
    }

    public Map<String, Class<? extends DBObject>> getDBObjectClasses() {
        return Collections.unmodifiableMap(this.getMetadata().getTypeMap());
    }

    public boolean isSchemaObject(String string) {
        return this.isTypeOf(SchemaObject.class, string);
    }

    public boolean isTypeOf(Class<? extends DBObject> clazz, String string) {
        Class<? extends DBObject> clazz2;
        this.checkLoaded(string);
        boolean bl = false;
        if (string != null && (clazz2 = this.getMetadata().getTypeMap().get(string)) != null) {
            bl = clazz.isAssignableFrom(clazz2);
        }
        return bl;
    }

    public DBObject newDBObject(String string, String string2) {
        Class<? extends DBObject> clazz = this.getObjectClass(string);
        if (clazz != null) {
            try {
                DBObject dBObject = clazz.newInstance();
                dBObject.setName(string2);
                return dBObject;
            }
            catch (Exception exception) {
                DBLog.getLogger(this).log(Level.FINE, "Couldn't create new " + string, exception);
            }
        }
        return null;
    }

    public Class<? extends DBObject> getObjectClass(String string) {
        Class<? extends DBObject> clazz = null;
        if (string != null) {
            this.checkLoaded(string);
            clazz = this.getMetadata().getTypeMap().get(string);
        }
        return clazz;
    }

    private synchronized void checkLoaded(String string) {
        Class clazz;
        Thunk<Class<? extends DBObject>> thunk;
        if (this.m_extendedTypes != null && string != null && (thunk = this.m_extendedTypes.remove(string)) != null && (clazz = (Class)thunk.get()) != null) {
            this.registerObjectClass(string, clazz);
        }
    }

    private void checkLoaded(Class<?> clazz) {
        if (DBObject.class.isAssignableFrom(clazz)) {
            String string = Metadata.getType(clazz);
            this.checkLoaded(string);
        }
    }

    public synchronized void registerObjectClass(String string, Thunk<Class<? extends DBObject>> thunk) {
        if (this.m_extendedTypes == null) {
            this.m_extendedTypes = new HashMap<String, Thunk<Class<? extends DBObject>>>();
        }
        this.m_extendedTypes.put(string, thunk);
    }

    public synchronized void registerObjectClass(String string, Class<? extends DBObject> clazz) {
        Class<? extends DBObject> clazz2 = this.getObjectClass(string);
        if (clazz2 == null) {
            this.getMetadata().registerClass(clazz);
        } else if (clazz2 != clazz) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot register class {0}: type {1} is registered as class {2}", clazz.getName(), string, clazz2.getName()));
        }
    }

    public Collection<String> getAllTypes(Class<? extends DBObject> clazz) {
        Collection<Class<? extends DBObject>> collection;
        HashSet<String> hashSet = new HashSet<String>();
        String string = Metadata.getType(clazz);
        if (string != null) {
            hashSet.add(string);
            this.checkLoaded(string);
        }
        if ((collection = this.getMetadata().getImplementations(clazz)) != null) {
            for (Class<? extends DBObject> clazz2 : collection) {
                String string2 = Metadata.getType(clazz2);
                if (string2 == null) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public DBObject newInstance(String string) {
        Class<? extends DBObject> clazz = this.getObjectClass(string);
        if (clazz != null) {
            if (Constraint.class.equals(clazz)) {
                clazz = UniqueConstraint.class;
            }
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                DBLog.logStackTrace("Error instantiating new DBObject", exception);
            }
        }
        return null;
    }

    @Deprecated
    public Collection<String> getSupportedProperties(Class<?> clazz, Class<? extends DBObjectProvider> clazz2) {
        return this.getSupportedProperties(clazz, clazz2, true, true);
    }

    @Deprecated
    public Collection<String> getSupportedProperties(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, boolean bl, boolean bl2) {
        PropertyCriteria propertyCriteria = new PropertyCriteria();
        propertyCriteria.setIncludeBean(bl);
        propertyCriteria.setIncludeExtra(bl2);
        return this.getSupportedPropertiesMap(clazz, clazz2, propertyCriteria).keySet();
    }

    Map<String, PropertyInfo> getSupportedPropertiesMap(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, PropertyCriteria propertyCriteria) {
        HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
        this.populateSupportedPropertiesMap(clazz, clazz2, propertyCriteria, hashMap, false);
        return hashMap;
    }

    public boolean hasSupportedProperty(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, Predicate<PropertyInfo> predicate) {
        boolean bl;
        if (predicate == null) {
            DBLog.logIllegalState("Must provide a predicate");
            bl = false;
        } else {
            HashMap<String, PropertyInfo> hashMap = new HashMap<String, PropertyInfo>();
            this.populateSupportedPropertiesMap(clazz, clazz2, predicate, hashMap, true);
            bl = !hashMap.isEmpty();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSupportedPropertiesMap(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, Predicate<PropertyInfo> predicate, Map<String, PropertyInfo> map, boolean bl) {
        if (clazz == null) {
            DBLog.logIllegalState("Must provide an object class");
        } else {
            Object object;
            Object object2;
            if (!(predicate instanceof PropertyCriteria) || ((PropertyCriteria)predicate).isIncludeBean()) {
                this.populateBeanProperties(clazz, clazz2, predicate, map, bl);
                if (bl && !map.isEmpty()) {
                    return;
                }
                object2 = this.getDefaultImplClasses(clazz).iterator();
                while (object2.hasNext()) {
                    object = (Class)object2.next();
                    this.populateBeanProperties((Class<?>)object, clazz2, predicate, map, bl);
                    if (!bl || map.isEmpty()) continue;
                    return;
                }
            }
            if ((!(predicate instanceof PropertyCriteria) || ((PropertyCriteria)predicate).isIncludeExtra()) && DBObject.class.isAssignableFrom(clazz)) {
                object = object2 = this.getMetadata().getExtraProps();
                synchronized (object) {
                    for (Map.Entry entry : object2.entrySet()) {
                        for (PropertyInfo propertyInfo : (Collection)entry.getValue()) {
                            if (!propertyInfo.isSupported(clazz2, clazz) || !this.testPredicateImpl(predicate, propertyInfo)) continue;
                            map.put((String)entry.getKey(), propertyInfo);
                            if (!bl) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    private void populateBeanProperties(Class<?> clazz, Class<? extends DBObjectProvider> clazz2, Predicate<PropertyInfo> predicate, Map<String, PropertyInfo> map, boolean bl) {
        this.checkLoaded(clazz);
        BeanInfo beanInfo = MetadataImpl.getBeanInfo(clazz);
        if (beanInfo != null) {
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                String string;
                PropertyInfo propertyInfo;
                if (this.weDoNotLike(propertyDescriptor, clazz) || !this.testPredicateImpl(predicate, propertyInfo = this.findOrCreatePropertyInfo(clazz, string = propertyDescriptor.getName(), propertyDescriptor))) continue;
                map.put(string, propertyInfo);
                if (!bl) continue;
                return;
            }
        }
    }

    private boolean testPredicateImpl(Predicate<PropertyInfo> predicate, PropertyInfo propertyInfo) {
        boolean bl = predicate instanceof PropertyCriteria ? ((PropertyCriteria)predicate).testImpl(propertyInfo) : (predicate == null ? true : predicate.test(propertyInfo));
        return bl;
    }

    private boolean weDoNotLike(PropertyDescriptor propertyDescriptor, Class clazz) {
        boolean bl = false;
        if ("parent".equals(propertyDescriptor.getName()) && DBObject.class.isAssignableFrom(clazz)) {
            bl = true;
        } else if (!MetadataImpl.isValidForPropertyInfo(propertyDescriptor)) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyInfo getSupportedProperty(Class<?> clazz, String string, Class<? extends DBObjectProvider> clazz2) {
        Object object;
        Object object2;
        PropertyInfo propertyInfo = this.findOrCreatePropertyInfo(clazz, string, null);
        if (propertyInfo == null) {
            object2 = this.getDefaultImplClasses(clazz).iterator();
            while (object2.hasNext() && (propertyInfo = this.findOrCreatePropertyInfo((Class<?>)(object = object2.next()), string, null)) == null) {
            }
        }
        if (propertyInfo == null && DBObject.class.isAssignableFrom(clazz)) {
            object = object2 = this.getMetadata().getExtraProps();
            synchronized (object) {
                Collection collection = (Collection)object2.get(string);
                if (collection != null) {
                    for (PropertyInfo propertyInfo2 : collection) {
                        if (propertyInfo2 == null || !propertyInfo2.isSupported(clazz2, clazz)) continue;
                        propertyInfo = propertyInfo2;
                        break;
                    }
                }
            }
        }
        return propertyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyInfo findOrCreatePropertyInfo(Class<?> clazz, String string, PropertyDescriptor propertyDescriptor) {
        PropertyInfo propertyInfo = null;
        Map<Class<?>, Map<String, PropertyInfo>> map = this.m_descriptorInfos;
        synchronized (map) {
            Map<String, PropertyInfo> map2 = this.m_descriptorInfos.get(clazz);
            if (map2 == null) {
                map2 = new HashMap<String, PropertyInfo>();
                this.m_descriptorInfos.put(clazz, map2);
            } else {
                propertyInfo = map2.get(string);
            }
            if (propertyInfo == null) {
                BeanInfo beanInfo;
                if (propertyDescriptor == null && (beanInfo = MetadataImpl.getBeanInfo(clazz)) != null) {
                    for (PropertyDescriptor propertyDescriptor2 : beanInfo.getPropertyDescriptors()) {
                        if (!propertyDescriptor2.getName().equals(string)) continue;
                        if (this.weDoNotLike(propertyDescriptor2, clazz)) break;
                        propertyDescriptor = propertyDescriptor2;
                        break;
                    }
                }
                if (propertyDescriptor != null) {
                    propertyInfo = PropertyInfo.createPropertyInfo(propertyDescriptor);
                    map2.put(string, propertyInfo);
                }
            }
        }
        return propertyInfo;
    }

    Iterable<Class<? extends DBObject>> getDefaultImplClasses(Class<?> clazz) {
        List<Class<? extends DBObject>> list;
        if (DBObject.class.isAssignableFrom(clazz)) {
            Collection<Class<? extends DBObject>> collection;
            list = new ArrayList();
            String string = Metadata.getType(clazz);
            if (Modifier.isAbstract(clazz.getModifiers()) && (collection = this.getMetadata().getImplementations(clazz)) != null) {
                for (Class<? extends DBObject> clazz2 : collection) {
                    String string2 = Metadata.getType(clazz2);
                    if (clazz2 == clazz || string2 == null || string != null && !ModelUtil.areEqual((Object)string2, (Object)string)) continue;
                    list.add(clazz2);
                }
            }
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public void registerProperty(String string, Class clazz, Class<? extends DBObjectProvider> clazz2, Class<? extends DBObject> ... classArray) {
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, clazz, clazz2, classArray);
        this.registerProperty(propertyDefinition);
    }

    public void registerBooleanProperty(String string, Nullable.NullBehaviour nullBehaviour, Class<? extends DBObjectProvider> clazz, Class<? extends DBObject> ... classArray) {
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, Boolean.class, clazz, classArray);
        propertyDefinition.setNullBehaviour(nullBehaviour);
        this.registerProperty(propertyDefinition);
    }

    public void registerStringProperty(String string, boolean bl, Class<? extends DBObjectProvider> clazz, Class<? extends DBObject> ... classArray) {
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, String.class, clazz, classArray);
        propertyDefinition.setTextPropertyInfo(bl, false, false);
        this.registerProperty(propertyDefinition);
    }

    public void registerIDProperty(String string, boolean bl, Class<? extends DBObjectProvider> clazz, Class<? extends DBObject> ... classArray) {
        this.registerIDProperty(string, bl, (Class<? extends DBObject>)null, (String[])null, clazz, classArray);
    }

    public void registerIDProperty(String string, boolean bl, Class<? extends DBObject> clazz, String[] stringArray, Class<? extends DBObjectProvider> clazz2, Class<? extends DBObject> ... classArray) {
        if (clazz == null) {
            clazz = DBObject.class;
        }
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, DBObjectID.class, clazz2, classArray);
        propertyDefinition.setReferencesInfo(bl, clazz, stringArray);
        this.registerProperty(propertyDefinition);
    }

    public void registerProperty(PropertyInfo propertyInfo) {
        if (propertyInfo != null) {
            String string = propertyInfo.getPropertyName();
            if (!ModelUtil.hasLength((String)string)) {
                throw new IllegalArgumentException("Property must have a valid name");
            }
            this.getMetadata().registerExtraProperty(propertyInfo);
        }
    }

    public void registerProperties(Iterable<? extends PropertyInfo> iterable) {
        if (iterable != null) {
            this.getMetadata().registerExtraProperties(iterable);
        }
    }

    public boolean isStaticReferenceProperty(String string) {
        boolean bl = false;
        Map<String, Collection<PropertyInfo>> map = this.getMetadata().getExtraProps();
        Collection<PropertyInfo> collection = map.get(string);
        if (collection != null) {
            for (PropertyInfo propertyInfo : collection) {
                if (!propertyInfo.isStaticReference()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isBeanProperty(Class<? extends DBObject> clazz, String string) {
        return this.findOrCreatePropertyInfo(clazz, string, null) != null;
    }

    public Collection<String> getOwnerTypes(String string) {
        this.checkLoaded(string);
        Class<? extends DBObject> clazz = this.getObjectClass(string);
        Collection<Class<? extends DBObject>> collection = this.getOwnerClasses(clazz);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Class<? extends DBObject> clazz2 : collection) {
            treeSet.add(Metadata.getType(clazz2));
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<? extends DBObject>> getOwnerClasses(Class<? extends DBObject> clazz) {
        MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> multiMap = this.m_ownerMap;
        synchronized (multiMap) {
            ArrayList<Class<? extends DBObject>> arrayList = new ArrayList<Class<? extends DBObject>>();
            Collection collection = this.m_ownerMap.get(clazz);
            if (collection == null) {
                if (clazz != null) {
                    for (Class<? extends Copyable> clazz2 : this.getMetadata().getBeans()) {
                        if (!DBObject.class.isAssignableFrom(clazz2) || !Metadata.isRealBean(clazz2)) continue;
                        PropertyCriteria propertyCriteria = new PropertyCriteria();
                        propertyCriteria.addPredicate(propertyInfo -> clazz.isAssignableFrom(DBUtil.decodeArrayClass(propertyInfo.getPropertyClass())));
                        if (!this.hasSupportedProperty(clazz2, null, propertyCriteria)) continue;
                        arrayList.add(clazz2);
                        this.m_ownerMap.add(clazz, clazz2);
                    }
                }
            } else {
                arrayList.addAll(collection);
            }
            return arrayList;
        }
    }

    public static boolean isRealBean(Class<?> clazz) {
        int n;
        return clazz != null && Modifier.isPublic(n = clazz.getModifiers()) && !Modifier.isAbstract(n) && !clazz.isInterface();
    }

    public static String getType(Class<? extends DBObject> clazz) {
        String string = null;
        if (clazz != null) {
            try {
                Field field = clazz.getField("TYPE");
                if (field != null) {
                    string = (String)field.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

