/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.XMLSchemaElement;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.References;

public class XMLTypeColumnProperties
extends AbstractChildDBObject {
    public static final String TYPE = "XMLTypeColumnProperties";

    public XMLTypeColumnProperties() {
        this.setStoreAs(StoreAs.CLOB);
        this.setAllowAnySchema(false);
        this.setAllowNonSchema(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setStoreAs(StoreAs storeAs) {
        this.setProperty("storeAs", (Object)storeAs);
    }

    public StoreAs getStoreAs() {
        return (StoreAs)((Object)this.getProperty("storeAs"));
    }

    public void setElementID(DBObjectID dBObjectID) {
        this.setProperty("elementID", dBObjectID);
    }

    @References(value=XMLSchemaElement.class)
    public DBObjectID getElementID() {
        return (DBObjectID)this.getProperty("elementID");
    }

    public void setAllowAnySchema(boolean bl) {
        this.setProperty("allowAnySchema", bl);
    }

    public boolean isAllowAnySchema() {
        return (Boolean)this.getProperty("allowAnySchema", false);
    }

    public void setAllowNonSchema(boolean bl) {
        this.setProperty("allowNonSchema", bl);
    }

    public boolean isAllowNonSchema() {
        return (Boolean)this.getProperty("allowNonSchema", false);
    }

    public static boolean isXMLType(DataType dataType) {
        Type type;
        Schema schema;
        boolean bl = false;
        if (dataType instanceof Type && (schema = (type = (Type)dataType).getSchema()) != null) {
            bl = ("SYS".equals(schema.getName()) || "PUBLIC".equals(schema.getName())) && "XMLTYPE".equalsIgnoreCase(type.getName());
        }
        return bl;
    }

    public static enum StoreAs {
        OBJECT_RELATIONAL("OBJECT RELATIONAL"),
        CLOB("CLOB"),
        BINARY_XML("BINARY XML");

        private String _value;

        private StoreAs(String string2) {
            this._value = string2;
        }

        public String toString() {
            return this._value;
        }
    }
}

