/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.util.ModelUtil;

public class OracleInMemoryColumnProperties
extends AbstractChildDBObject {
    public static final String TYPE = "OracleInMemoryColumnProperties";
    @PropertyKey(value=OracleInMemoryColumnProperties[].class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String CLAUSE_KEY = "OracleInMemoryColumnProperties";

    public OracleInMemoryColumnProperties() {
        this.setInMemory(true);
    }

    @Override
    public String getType() {
        return "OracleInMemoryColumnProperties";
    }

    public boolean isInMemory() {
        return (Boolean)this.getProperty("inMemory", true);
    }

    public void setInMemory(boolean bl) {
        this.setProperty("inMemory", bl);
    }

    public OracleInMemoryProperties.InMemoryCompression getInMemoryCompression() {
        return (OracleInMemoryProperties.InMemoryCompression)((Object)this.getProperty("inMemoryCompression"));
    }

    public void setInMemoryCompression(OracleInMemoryProperties.InMemoryCompression inMemoryCompression) {
        this.setProperty("inMemoryCompression", (Object)inMemoryCompression);
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getColumnIDs() {
        return (DBObjectID[])this.getProperty("columnIDs");
    }

    public void setColumnIDs(DBObjectID[] dBObjectIDArray) {
        this.setProperty("columnIDs", dBObjectIDArray);
    }

    @Override
    @Internal
    public String getName() {
        Table table;
        String string = null;
        DBObjectID[] dBObjectIDArray = this.getColumnIDs();
        if (dBObjectIDArray != null && (table = DBUtil.findParentOfType(this.getParent(), Table.class)) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DBObjectID dBObjectID : this.getColumnIDs()) {
                DBObject dBObject;
                String string2 = null;
                if (dBObjectID instanceof BaseObjectID) {
                    string2 = ((BaseObjectID)dBObjectID).getName();
                }
                if (!ModelUtil.hasLength(string2) && (dBObject = table.findOwnedObject(dBObjectID)) != null) {
                    string2 = dBObject.getName();
                }
                if (!ModelUtil.hasLength((String)string2)) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string2);
            }
            string = stringBuilder.toString();
        }
        return string;
    }
}

