/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.util.ModelUtil;

public class IndexPartition
extends AbstractChildDBObject {
    public static final String TYPE = "INDEX PARTITION";

    public IndexPartition() {
        this((OracleIndexPartitions)null);
    }

    public IndexPartition(OracleIndexPartitions oracleIndexPartitions) {
        this(null, oracleIndexPartitions);
    }

    public IndexPartition(String string, OracleIndexPartitions oracleIndexPartitions) {
        super(string, oracleIndexPartitions);
        this.setUseKeyCompression(Boolean.FALSE);
    }

    @Deprecated
    public Boolean getKeyCompression() {
        return this.getUseKeyCompression();
    }

    public Boolean getUseKeyCompression() {
        return (Boolean)this.getProperty("useKeyCompression");
    }

    public Object[] getValuesLessThan() {
        return this.getChildSupport("valuesLessThan").getChildArray(Object.class);
    }

    public OracleStorageProperties getSegmentAttributes() {
        return (OracleStorageProperties)this.getProperty("segmentAttributes");
    }

    public OracleIndexPartitions getSubpartitions() {
        return (OracleIndexPartitions)this.getProperty("subpartitions");
    }

    @TextProperty(multiLine=true)
    public String getDomainParameters() {
        return (String)this.getProperty("domainParameters");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Deprecated
    public void setKeyCompression(Boolean bl) {
        this.setUseKeyCompression(bl);
    }

    public void setUseKeyCompression(Boolean bl) {
        this.setProperty("useKeyCompression", bl);
    }

    public void setValuesLessThan(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray == null) {
            objectArray2 = null;
        } else {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = this.normaliseValue(objectArray[i]);
            }
        }
        this.getChildSupport("valuesLessThan").setChildArray(objectArray2);
    }

    public void setValuesLessThan(String string) {
        if (ModelUtil.hasLength((String)string)) {
            List<String> list = TablePartition.splitValues(string);
            this.setValuesLessThan(list.toArray(new String[list.size()]));
        }
    }

    public void setSegmentAttributes(OracleStorageProperties oracleStorageProperties) {
        this.setProperty("segmentAttributes", oracleStorageProperties);
    }

    public void setSubpartitions(OracleIndexPartitions oracleIndexPartitions) {
        this.setProperty("subpartitions", oracleIndexPartitions);
    }

    public void setDomainParameters(String string) {
        this.setProperty("domainParameters", string);
    }

    public void addValue(Object object) {
        if (object != null) {
            this.getChildSupport("valuesLessThan").addChild(this.normaliseValue(object));
        }
    }

    private Object normaliseValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (TablePartition.RangeValue.MAXVALUE.toString().equalsIgnoreCase(string)) {
                object = TablePartition.RangeValue.MAXVALUE;
            }
        }
        return object;
    }
}

