/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.plsql.PlSqlSourceObject;

public abstract class AbstractResourceCache {
    private final DatabaseDescriptor m_desc;
    private final String m_resourceDir;

    public AbstractResourceCache(DatabaseDescriptor databaseDescriptor, String string) {
        this.m_desc = databaseDescriptor;
        this.m_resourceDir = string;
    }

    protected final DatabaseDescriptor getDatabaseDescriptor() {
        return this.m_desc;
    }

    protected ClassLoader getResourceClassLoader() {
        return this.getDatabaseDescriptor().getClass().getClassLoader();
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected DBObjectHandler getHandler(DBObject dBObject) {
        String string = dBObject instanceof PlSqlSourceObject ? "plsql" : "xml";
        return DBCore.getInstance().getRegisteredFactory(DBObjectHandler.class, string);
    }

    protected final String getResourceRoot() {
        return this.m_resourceDir;
    }

    protected void markForLazyInit(AbstractBuildableObject abstractBuildableObject, String string) {
        ClassLoader classLoader = this.getResourceClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            this.lazyObjectBuilt(abstractBuildableObject);
        } else {
            new LazyObjectBuilder(abstractBuildableObject, string);
        }
    }

    protected final String getResourcePath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(this.getResourceRoot());
        for (String string : stringArray) {
            stringBuilder.append("/").append(string);
        }
        return stringBuilder.toString();
    }

    protected void lazyObjectBuilt(DBObject dBObject) {
    }

    private class LazyObjectBuilder
    extends AbstractDBObjectBuilder {
        private final String m_resource;

        LazyObjectBuilder(AbstractBuildableObject abstractBuildableObject, String string) {
            super(null, abstractBuildableObject.getType());
            this.setBuilder(abstractBuildableObject);
            this.m_resource = string;
        }

        @Override
        protected boolean canBuildComponents() {
            return false;
        }

        protected void fillInObject(AbstractBuildableObject abstractBuildableObject) throws DBException {
            InputStream inputStream = null;
            try {
                DBObject dBObject;
                inputStream = AbstractResourceCache.this.getResourceClassLoader().getResourceAsStream(this.m_resource);
                DBObjectHandler dBObjectHandler = AbstractResourceCache.this.getHandler(abstractBuildableObject);
                List<DBObject> list = dBObjectHandler.read(inputStream, null, DBUtil.getSchema(abstractBuildableObject));
                if (list != null && list.size() == 1 && (dBObject = list.get(0)) instanceof AbstractBuildableObject) {
                    DBObjectID dBObjectID = abstractBuildableObject.getID();
                    dBObject.copyTo((DBObject)abstractBuildableObject, new IDPolicy.SameIDPolicy());
                    if (dBObjectID != null) {
                        abstractBuildableObject.setID(dBObjectID);
                    }
                    AbstractResourceCache.this.lazyObjectBuilt(abstractBuildableObject);
                }
            }
            catch (IOException iOException) {
                throw new DBException(abstractBuildableObject, iOException.getMessage(), iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

