/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyInfo;

public final class DelegateDDLGenerator
implements DDLGenerator {
    private final DDLGenerator m_base;
    private final DatabaseDescriptor m_desc;
    private final Class<? extends Database> m_databaseClass;
    private final DBObjectProvider m_pro;
    private Map<String, DDLGenerator> m_extras;

    public DelegateDDLGenerator(DDLGenerator dDLGenerator, DatabaseDescriptor databaseDescriptor, Class<? extends Database> clazz, DBObjectProvider dBObjectProvider) {
        if (dDLGenerator == null || databaseDescriptor == null || clazz == null) {
            throw new IllegalArgumentException("must provide a base generator, database descriptor and class");
        }
        this.m_base = dDLGenerator;
        this.m_desc = databaseDescriptor;
        this.m_databaseClass = clazz;
        this.m_pro = dBObjectProvider;
    }

    public DDLGenerator getBaseGenerator() {
        return this.m_base;
    }

    private DDLGenerator getDelegate(Difference difference) {
        return this.getDelegate((DBObject)difference.getOriginalObject(), (DBObject)difference.getUpdatedObject());
    }

    private DDLGenerator getDelegate(DBObject dBObject, DBObject dBObject2) {
        String string = null;
        if (dBObject != null) {
            string = dBObject.getType();
        } else if (dBObject2 != null) {
            string = dBObject2.getType();
        }
        return this.getDelegate(string);
    }

    private DDLGenerator getDelegate(String string) {
        DDLGenerator dDLGenerator;
        Object object;
        if (this.m_extras == null && DBObjectRegistry.isActive()) {
            object = DBObjectRegistry.getInstance();
            this.m_extras = ((DBObjectRegistry)object).getDDLGenerators(this.m_desc.getDatabaseType(), this.m_desc.getDatabaseVersion(), this.m_databaseClass, this.m_pro);
        }
        object = this.m_base;
        if (string != null && (dDLGenerator = this.m_extras.get(string)) != null) {
            object = dDLGenerator;
        }
        return object;
    }

    @Override
    public boolean canCreateProperty(SystemObject systemObject, String string) {
        return this.getDelegate(null, systemObject).canCreateProperty(systemObject, string);
    }

    public DDL getCreateDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        if (dBObjectArray != null) {
            for (DBObject dBObject : dBObjectArray) {
                DDL dDL2 = this.getDelegate(dBObject, null).getCreateDDL(dDLOptions, dBObject);
                if (dDL2 == null) continue;
                if (dDL == null) {
                    dDL = dDL2;
                    continue;
                }
                dDL.append(dDL2);
            }
        }
        return dDL;
    }

    public DDL getDeleteDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        if (dBObjectArray != null) {
            for (DBObject dBObject : dBObjectArray) {
                DDL dDL2 = this.getDelegate(dBObject, null).getDeleteDDL(dDLOptions, dBObject);
                if (dDL2 == null) continue;
                if (dDL == null) {
                    dDL = dDL2;
                    continue;
                }
                dDL.append(dDL2);
            }
        }
        return dDL;
    }

    public DDL getUndeleteDDL(DDLOptions dDLOptions, DBObject ... dBObjectArray) {
        DDL dDL = null;
        if (dBObjectArray != null) {
            for (DBObject dBObject : dBObjectArray) {
                DDL dDL2 = this.getDelegate(dBObject, null).getUndeleteDDL(dDLOptions, dBObject);
                if (dDL2 == null) continue;
                if (dDL == null) {
                    dDL = dDL2;
                    continue;
                }
                dDL.append(dDL2);
            }
        }
        return dDL;
    }

    public DDL getUpdateDDL(DDLOptions dDLOptions, Difference difference) {
        DDL dDL = new DDL();
        if ((difference.isMap() || difference.isLeaf()) && SystemObject.class.isAssignableFrom(difference.getDifferenceClass())) {
            this.processDifference(dDLOptions, difference, dDL);
        } else if (difference.isList()) {
            for (Difference difference2 : difference.getChildren()) {
                this.processDifference(dDLOptions, difference2, dDL);
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return dDL;
    }

    private void processDifference(DDLOptions dDLOptions, Difference difference, DDL dDL) {
        DDL dDL2 = this.getDelegate(difference).getUpdateDDL(dDLOptions, difference);
        if (dDL2 != null) {
            dDL.append(dDL2);
        }
    }

    @Override
    public boolean supportsAction(String string, PropertyAction.Type type) {
        return this.getDelegate(string).supportsAction(string, type);
    }

    @Override
    public boolean supportsProperty(String string, String string2) {
        return this.getDelegate(string).supportsProperty(string, string2);
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> clazz, String string) {
        return this.getDelegate(Metadata.getType(clazz)).supportsProperty(clazz, string);
    }

    @Override
    public PropertyInfo findPropertyInfo(Class<? extends DBObject> clazz, String string) {
        return this.getDelegate(Metadata.getType(clazz)).findPropertyInfo(clazz, string);
    }

    @Override
    public Map<String, PropertyInfo> getPropertyInfos(Class<? extends DBObject> clazz, PropertyCriteria propertyCriteria) {
        return this.getDelegate(Metadata.getType(clazz)).getPropertyInfos(clazz, propertyCriteria);
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject dBObject, DBObject dBObject2, String string) {
        return this.getDelegate(dBObject, dBObject2).getAllowedPropertyValues(dBObject, dBObject2, string);
    }

    @Override
    public Collection<String> getRestrictingProperties(Class<? extends SystemObject> clazz, String string) {
        String string2 = Metadata.getType(clazz);
        return this.getDelegate(string2).getRestrictingProperties(clazz, string);
    }

    @Override
    public Collection<String> getAllowedReferenceParentTypes(DBObject dBObject, String string) {
        return this.getDelegate(null, dBObject).getAllowedReferenceParentTypes(dBObject, string);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(DBObject dBObject, String string) {
        return this.getDelegate(null, dBObject).getAllowedReferenceTypes(dBObject, string);
    }

    @Override
    public boolean canAlterProperty(SystemObject systemObject, SystemObject systemObject2, String string) {
        return this.getDelegate(systemObject, systemObject2).canAlterProperty(systemObject, systemObject2, string);
    }

    @Override
    public PropertyAction canChangeProperty(SystemObject systemObject, SystemObject systemObject2, String string) {
        return this.getDelegate(systemObject, systemObject2).canChangeProperty(systemObject, systemObject2, string);
    }

    @Override
    public PropertyAction canUpdateObject(Difference difference) {
        return this.getDelegate(difference).canUpdateObject(difference);
    }

    @Override
    public PropertyAction canUpdateObject(SystemObject systemObject, SystemObject systemObject2) {
        return this.getDelegate(systemObject, systemObject2).canUpdateObject(systemObject, systemObject2);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(String string, String string2) {
        return this.getDelegate(string).getAllowedReferenceTypes(string, string2);
    }

    @Override
    public Collection<String> getAllowedReferenceTypes(PropertyInfo propertyInfo) {
        return propertyInfo == null ? null : propertyInfo.getAllowedReferenceTypes();
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> clazz, String string) {
        PropertyAction propertyAction = null;
        String string2 = Metadata.getType(clazz);
        DDLGenerator dDLGenerator = this.getDelegate(string2);
        if (dDLGenerator != null) {
            propertyAction = dDLGenerator.supportsPropertyChange(clazz, string);
        }
        return propertyAction;
    }

    @Override
    public Object getImplicitDefaultValue(DBObject dBObject, String string) {
        Object object = null;
        DDLGenerator dDLGenerator = this.getDelegate(null, dBObject);
        if (dDLGenerator != null) {
            object = dDLGenerator.getImplicitDefaultValue(dBObject, string);
        }
        return object;
    }

    @Override
    public Nullable.NullBehaviour getNullBehaviour(DBObject dBObject, DBObject dBObject2, String string) {
        Nullable.NullBehaviour nullBehaviour = null;
        DDLGenerator dDLGenerator = this.getDelegate(null, dBObject2);
        if (dDLGenerator != null) {
            nullBehaviour = dDLGenerator.getNullBehaviour(dBObject, dBObject2, string);
        }
        return nullBehaviour;
    }
}

