/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import oracle.javatools.util.ModelUtil;

public class DatabaseMatcher {
    private final String m_type;
    private final int m_version;
    private final Comparison m_comparison;
    private String m_testSystemProperty;

    public DatabaseMatcher(String string) {
        this(string, -1, Comparison.MINIMUM);
    }

    public DatabaseMatcher(String string, int n, Comparison comparison) {
        this.m_type = string;
        this.m_version = n;
        this.m_comparison = comparison;
    }

    public String getDatabaseType() {
        return this.m_type;
    }

    protected boolean matchesType(String string) {
        return ModelUtil.areEqual((Object)string, (Object)this.m_type);
    }

    protected boolean matchesVersion(int n) {
        switch (this.m_comparison) {
            case EXACT: {
                return this.m_version == n;
            }
            case MAXIMUM: {
                return this.m_version >= n;
            }
            case MINIMUM: {
                return this.m_version <= n;
            }
        }
        return false;
    }

    public boolean matches(String string, int n) {
        boolean bl = this.m_testSystemProperty == null || Boolean.getBoolean(this.m_testSystemProperty);
        return bl && this.matchesType(string) && this.matchesVersion(n);
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseMatcher && this.equalsImpl((DatabaseMatcher)object);
    }

    private boolean equalsImpl(DatabaseMatcher databaseMatcher) {
        return ModelUtil.areEqual((Object)this.m_type, (Object)databaseMatcher.m_type) && this.m_version == databaseMatcher.m_version && ModelUtil.areEqual((Object)((Object)this.m_comparison), (Object)((Object)databaseMatcher.m_comparison));
    }

    public int hashCode() {
        return this.m_type == null ? 0 : this.m_type.hashCode();
    }

    public void setTestSystemProperty(String string) {
        this.m_testSystemProperty = string;
    }

    public static enum Comparison {
        EXACT,
        MINIMUM,
        MAXIMUM;

    }
}

