/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.diff.BuildableDBObjectDiffer;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DBObjectIDComparator;
import oracle.javatools.db.diff.DBObjectIDDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.GenericArrayDiffer;
import oracle.javatools.db.diff.GenericBeanDiffer;
import oracle.javatools.db.diff.GenericComparator;
import oracle.javatools.db.diff.GenericMapDiffer;
import oracle.javatools.db.diff.GenericNameDiffer;
import oracle.javatools.db.diff.GenericToStringDiffer;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.PlSqlFragmentSourceDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.diff.SQLFragmentComparator;
import oracle.javatools.db.diff.SQLFragmentDiffer;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;

public class GenericDiffEngine {
    public static DiffEngine getDiffEngine(boolean bl) {
        return GenericDiffEngine.getDiffEngine(bl, true);
    }

    public static DiffEngine getDiffEngine(boolean bl, boolean bl2) {
        return GenericDiffEngine.getDiffEngine(bl, bl, bl2);
    }

    public static DiffEngine getDiffEngine(boolean bl, boolean bl2, boolean bl3) {
        DiffEngine diffEngine = new DiffEngine(true);
        DiffEngine diffEngine2 = null;
        DiffEngine diffEngine3 = null;
        if (bl != bl2) {
            diffEngine2 = GenericDiffEngine.getDiffEngine(bl2, bl2, bl3);
        }
        if (!bl2) {
            diffEngine3 = bl3 ? GenericDiffEngine.getDiffEngine(false, false, false) : (bl ? diffEngine2 : diffEngine);
        }
        diffEngine.registerListDiffer(new ListDiffer(true), Object.class);
        diffEngine.registerListDiffer(new ListDiffer(false), Constraint.class);
        diffEngine.registerListDiffer(new ListDiffer(false), Index.class);
        diffEngine.registerListDiffer(new SingleMatchListDiffer(), SQLFragment.class);
        diffEngine.registerComparator(new DBObjectComparator(diffEngine), DBObject.class);
        diffEngine.registerComparator(new SQLFragmentComparator(diffEngine), SQLFragment.class);
        diffEngine.registerComparator(new DBObjectIDComparator(bl), DBObjectID.class);
        diffEngine.registerComparator(new GenericComparator(), Object.class);
        diffEngine.registerDiffer(new GenericToStringDiffer(), Object.class);
        diffEngine.registerDiffer(new GenericBeanDiffer(), Object.class);
        diffEngine.registerDiffer(new GenericArrayDiffer(), Object.class);
        diffEngine.registerDiffer(new GenericMapDiffer(), Map.class);
        diffEngine.registerDiffer(new GenericNameDiffer(), Schema.class);
        diffEngine.registerDiffer(new DBObjectIDDiffer(bl), DBObjectID.class);
        diffEngine.registerDiffer(new DBObjectDiffer(diffEngine2), AbstractDBObject.class);
        BuildableDBObjectDiffer buildableDBObjectDiffer = new BuildableDBObjectDiffer(diffEngine2, diffEngine3);
        diffEngine.registerDiffer(buildableDBObjectDiffer, AbstractBuildableObject.class);
        if (bl3) {
            diffEngine.registerDiffer(new SQLFragmentDiffer(buildableDBObjectDiffer), AbstractSQLFragment.class);
        }
        diffEngine.registerDiffer(new PlSqlFragmentSourceDiffer(), DBObjectPlSqlFragment.class);
        return diffEngine;
    }

    private static class SingleMatchListDiffer
    extends ListDiffer {
        SingleMatchListDiffer() {
            super(true);
        }

        @Override
        public boolean diff(Object object, Object object2, ResultSet resultSet, DiffContext diffContext) {
            boolean bl;
            if (object instanceof List && object2 instanceof List && ((List)object).size() == 1 && ((List)object2).size() == 1) {
                Object e = ((List)object).get(0);
                Object e2 = ((List)object2).get(0);
                ResultSet resultSet2 = new ResultSet(resultSet, e, e2, 0, 0, null, "MAP");
                diffContext.getEngine().diff(e, e2, resultSet2, diffContext);
                resultSet.setSame(resultSet2.isSame());
                bl = true;
            } else {
                bl = super.diff(object, object2, resultSet, diffContext);
            }
            return bl;
        }
    }
}

