/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

class BuildableDBObjectDiffer
extends DBObjectDiffer {
    private final PropertyHelper m_helper = new PropertyHelper();
    private final DiffEngine m_internalRefDerivedPropertyDelegate;

    BuildableDBObjectDiffer() {
        this(null, null);
    }

    BuildableDBObjectDiffer(DiffEngine diffEngine, DiffEngine diffEngine2) {
        super(diffEngine);
        this.m_internalRefDerivedPropertyDelegate = diffEngine2;
    }

    @Override
    protected ResultSet diffProperty(Object object, Object object2, ResultSet resultSet, DiffContext diffContext, PropertyInfo propertyInfo, Map<String, PropertyInfo> map) {
        ResultSet resultSet2;
        Object object3;
        String string = propertyInfo.getPropertyName();
        boolean bl = propertyInfo.isDerived();
        AbstractBuildableObject abstractBuildableObject = (AbstractBuildableObject)object;
        AbstractBuildableObject abstractBuildableObject2 = (AbstractBuildableObject)object2;
        boolean bl2 = false;
        Boolean bl3 = null;
        if (object != null || object2 != null) {
            Object object4;
            boolean bl4 = DBUtil.needsBuilding(abstractBuildableObject, string);
            boolean bl5 = DBUtil.needsBuilding(abstractBuildableObject2, string);
            object3 = abstractBuildableObject == null ? null : abstractBuildableObject.getID();
            Object object5 = object4 = abstractBuildableObject2 == null ? null : abstractBuildableObject2.getID();
            if (this.isTempCopy((DBObjectID)object3, (DBObjectID)object4) && bl4 || this.isTempCopy((DBObjectID)object4, (DBObjectID)object3) && bl5) {
                bl2 = true;
                if (!bl) {
                    bl3 = true;
                }
            } else if (!diffContext.isTreeRequired() && (bl4 || bl5)) {
                bl2 = true;
            }
        }
        if (bl2) {
            resultSet2 = new LazyResultSet(resultSet, abstractBuildableObject, abstractBuildableObject2, propertyInfo, diffContext);
            if (bl3 != null) {
                resultSet2.setSame(bl3);
            }
        } else {
            resultSet2 = super.diffProperty(object, object2, resultSet, diffContext, propertyInfo, map);
            if (!resultSet2.isSame()) {
                String string2;
                if (bl) {
                    if (this.isSourcePropertySame(abstractBuildableObject, abstractBuildableObject2, propertyInfo, resultSet)) {
                        resultSet2.setSame(true);
                    }
                } else if (this.m_internalRefDerivedPropertyDelegate != null && this.hasRenames(abstractBuildableObject, abstractBuildableObject2, string2 = this.getSourceInternalReferenceProperty(propertyInfo))) {
                    object3 = null;
                    for (PropertyInfo propertyInfo2 : map.values()) {
                        Difference difference;
                        if (!propertyInfo2.isDerived() || !string.equals(propertyInfo2.getDerivedSourceProperty())) continue;
                        Object object6 = propertyInfo2.getPropertyValue(object);
                        Object object7 = propertyInfo2.getPropertyValue(object2);
                        if (object6 == null || object7 == null || !Boolean.FALSE.equals(object3 = Boolean.valueOf((difference = this.m_internalRefDerivedPropertyDelegate.difference(object6, object7)).isSame()))) continue;
                        difference.print(DBLog.getLogger(this), Level.FINE);
                        break;
                    }
                    if (Boolean.TRUE.equals(object3)) {
                        resultSet2.setSame(true);
                    }
                }
            }
        }
        return resultSet2;
    }

    protected boolean isSourcePropertySame(AbstractBuildableObject abstractBuildableObject, AbstractBuildableObject abstractBuildableObject2, PropertyInfo propertyInfo, ResultSet resultSet) {
        Difference difference = resultSet.getChildDifference(propertyInfo.getDerivedSourceProperty());
        return difference != null && difference.isSame();
    }

    private String getSourceInternalReferenceProperty(PropertyInfo propertyInfo) {
        String string = propertyInfo.getPropertyName();
        String string2 = "expressionSource".equals(string) || "checkCondition".equals(string) || "virtualExpressionSource".equals(string) ? "columns" : null;
        return string2;
    }

    private boolean hasRenames(DBObject dBObject, DBObject dBObject2, String string) {
        boolean bl = false;
        if (string != null) {
            SystemObject systemObject = DBUtil.getSystemObject(dBObject);
            SystemObject systemObject2 = DBUtil.getSystemObject(dBObject2);
            if (systemObject != null && systemObject2 != null) {
                if (TemporaryObjectID.getOriginalObject(systemObject) == systemObject2) {
                    bl = this.hasRenames(systemObject, string);
                } else if (TemporaryObjectID.getOriginalObject(systemObject2) == systemObject) {
                    bl = this.hasRenames(systemObject2, string);
                }
            }
        }
        return bl;
    }

    private boolean hasRenames(DBObject dBObject, String string) {
        boolean bl = false;
        Object object = this.m_helper.getPropertyValue(dBObject, string);
        if (object instanceof DBObject) {
            bl = this.isRenamed((DBObject)object);
        } else if (object instanceof DBObject[]) {
            for (DBObject dBObject2 : (DBObject[])object) {
                if (!this.isRenamed(dBObject2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean isRenamed(DBObject dBObject) {
        DBObject dBObject2 = TemporaryObjectID.getOriginalObject(dBObject);
        return dBObject2 != null && ModelUtil.areDifferent((Object)dBObject.getName(), (Object)dBObject2.getName());
    }

    protected boolean isTempCopy(DBObjectID dBObjectID, DBObjectID dBObjectID2) {
        DBObjectID dBObjectID3;
        DBObject dBObject;
        boolean bl = false;
        if (dBObjectID instanceof TemporaryObjectID && (dBObject = ((TemporaryObjectID)dBObjectID).getOriginalObject()) != null && (dBObjectID3 = dBObject.getID()) != null) {
            bl = dBObjectID3.equals(dBObjectID2, true) || this.isTempCopy(dBObjectID3, dBObjectID2);
        }
        return bl;
    }

    private static String getResultSetType(PropertyInfo propertyInfo) {
        Class<?> clazz = propertyInfo.getPropertyClass();
        String string = clazz != null && clazz.isArray() ? "LIST" : (clazz != null && Copyable.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) ? "MAP" : "LEAF");
        return string;
    }

    static boolean isLazyDifference(Difference difference) {
        return difference instanceof LazyResultSet;
    }

    private class LazyResultSet
    extends ResultSet {
        private static final String LAZY = "<LAZY>";
        private DiffContext m_diffContext;
        private PropertyInfo m_prop;
        private AbstractBuildableObject m_parentA;
        private AbstractBuildableObject m_parentB;
        private Holder<Object> m_lazyA;
        private Holder<Object> m_lazyB;
        private Boolean m_lazySame;
        private ResultSet m_lazyDiff;

        private LazyResultSet() {
        }

        LazyResultSet(ResultSet resultSet, AbstractBuildableObject abstractBuildableObject, AbstractBuildableObject abstractBuildableObject2, PropertyInfo propertyInfo, DiffContext diffContext) {
            super(resultSet, null, null, propertyInfo.getPropertyName(), BuildableDBObjectDiffer.getResultSetType(propertyInfo));
            this.m_prop = propertyInfo;
            this.m_parentA = abstractBuildableObject;
            this.m_parentB = abstractBuildableObject2;
            this.m_diffContext = diffContext;
            String string = propertyInfo.getPropertyName();
            if (!DBUtil.needsBuilding(abstractBuildableObject, string)) {
                this.a();
            }
            if (!DBUtil.needsBuilding(abstractBuildableObject2, string)) {
                this.b();
            }
        }

        @Override
        public boolean isLoaded() {
            return this.m_lazyDiff != null;
        }

        private boolean stillNeedsBuilding(AbstractBuildableObject abstractBuildableObject) {
            return abstractBuildableObject != null && DBUtil.needsBuilding(abstractBuildableObject, this.m_prop.getPropertyName());
        }

        private ResultSet getLazyDiff(boolean bl) {
            if (this.m_lazyDiff == null && this.m_parentA != null && this.m_parentB != null) {
                boolean bl2 = true;
                if (!bl) {
                    boolean bl3 = bl2 = !this.stillNeedsBuilding(this.m_parentA) && !this.stillNeedsBuilding(this.m_parentB);
                }
                if (bl2) {
                    Object object = this.a();
                    Object object2 = this.b();
                    if (object != null || object2 != null) {
                        this.m_lazyDiff = this.m_diffContext.getEngine().diff(object, object2).getResult();
                        this.m_lazyDiff.setName(this.m_prop.getPropertyName());
                        this.m_lazyDiff.setParent(this.getParent());
                    }
                }
            }
            return this.m_lazyDiff;
        }

        @Override
        public boolean isSame() {
            boolean bl;
            if (this.m_lazySame != null) {
                bl = this.m_lazySame;
            } else {
                ResultSet resultSet = this.getLazyDiff(false);
                if (resultSet != null) {
                    this.m_lazySame = resultSet.isSame();
                    bl = this.m_lazySame;
                } else {
                    Boolean bl2 = this.guessIsSame();
                    if (bl2 != null) {
                        bl = bl2;
                    } else {
                        ResultSet resultSet2 = this.getLazyDiff(true);
                        this.m_lazySame = resultSet2 == null ? true : resultSet2.isSame();
                        bl = this.m_lazySame;
                    }
                }
            }
            return bl;
        }

        private Boolean guessIsSame() {
            Boolean bl = null;
            ResultSet resultSet = this.getParent();
            if (resultSet != null && this.m_prop.isDerived()) {
                Difference difference = resultSet.getChildDifference(this.m_prop.getDerivedSourceProperty(), true);
                bl = difference == null;
            }
            return bl;
        }

        @Override
        public void setSame(boolean bl) {
            this.m_lazySame = bl;
        }

        @Override
        public Collection<ResultSet> getChildren() {
            ResultSet resultSet;
            Collection<ResultSet> collection = null;
            if (!"LEAF".equals(this.getType()) && (resultSet = this.getLazyDiff(!Boolean.TRUE.equals(this.m_lazySame))) != null) {
                collection = resultSet.getChildren();
            }
            return collection == null ? Collections.emptyList() : collection;
        }

        @Override
        public Object a() {
            if (this.m_lazyA == null) {
                this.m_lazyA = new Holder();
                if (this.m_parentA != null) {
                    this.m_lazyA.set(BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentA, this.m_prop.getPropertyName()));
                }
            }
            return this.m_lazyA.get();
        }

        @Override
        public Object b() {
            if (this.m_lazyB == null) {
                this.m_lazyB = new Holder();
                if (this.m_parentB != null) {
                    this.m_lazyB.set(BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentB, this.m_prop.getPropertyName()));
                }
            }
            return this.m_lazyB.get();
        }

        @Override
        protected String getOriginalObjectForLog() {
            return this.m_lazyA == null ? LAZY : super.getOriginalObjectForLog();
        }

        @Override
        protected String getUpdatedObjectForLog() {
            return this.m_lazyB == null ? LAZY : super.getUpdatedObjectForLog();
        }

        @Override
        protected Collection<? extends Difference> getChildrenForLog() {
            return this.m_lazyDiff == null ? Collections.emptyList() : super.getChildrenForLog();
        }

        @Override
        protected String getSameTextForLog() {
            return this.m_lazySame == null ? LAZY : super.getSameTextForLog();
        }

        @Override
        protected PropertyInfo getPropertyInfo() {
            return this.m_prop;
        }

        @Override
        public Class getResultSetClass() {
            Object object;
            Class<?> clazz = null;
            if (this.m_lazyA != null && (object = this.m_lazyA.get()) != null) {
                clazz = object.getClass();
            }
            if (clazz == null && this.m_lazyB != null && (object = this.m_lazyB.get()) != null) {
                clazz = object.getClass();
            }
            if (clazz == null && (clazz = this.m_prop.getPropertyClass()) == null) {
                clazz = super.getResultSetClass();
            }
            return clazz;
        }

        @Override
        public LazyResultSet copyTo(Object object) {
            LazyResultSet lazyResultSet = object == null ? new LazyResultSet() : (LazyResultSet)object;
            super.copyToImpl(lazyResultSet);
            lazyResultSet.m_lazyA = this.m_lazyA;
            lazyResultSet.m_lazyB = this.m_lazyB;
            lazyResultSet.m_parentA = this.m_parentA;
            lazyResultSet.m_parentB = this.m_parentB;
            lazyResultSet.m_prop = this.m_prop;
            lazyResultSet.m_lazySame = this.m_lazySame;
            lazyResultSet.m_lazyDiff = this.m_lazyDiff == null ? null : this.m_lazyDiff.copyTo(null);
            lazyResultSet.m_diffContext = this.m_diffContext;
            return lazyResultSet;
        }

        @Override
        protected boolean hasChildren() {
            return this.m_lazyDiff == null ? !"LEAF".equals(this.getType()) : this.m_lazyDiff.hasChildren();
        }
    }
}

