/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.text.MessageFormat;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.resource.APIBundle;

public class UnsupportedDDLException
extends UnsupportedOperationException {
    private DBObject m_obj;

    public UnsupportedDDLException(String string, DBObject dBObject) {
        super(MessageFormat.format(string, dBObject.getType(), dBObject.getName()));
        this.m_obj = dBObject;
    }

    public DBObject getObject() {
        return this.m_obj;
    }

    void throwDBException() throws DBException {
        throw new DBException(this.m_obj, this.getMessage(), this);
    }

    static UnsupportedDDLException updateNotSupported(DBObject dBObject) {
        return new UnsupportedDDLException(APIBundle.get("DDL_UPDATE_NOT_SUPPORTED"), dBObject);
    }

    static UnsupportedDDLException createNotSupported(DBObject dBObject) {
        return new UnsupportedDDLException(APIBundle.get("DDL_CREATE_NOT_SUPPORTED"), dBObject);
    }

    static UnsupportedDDLException deleteNotSupported(DBObject dBObject) {
        return new UnsupportedDDLException(APIBundle.get("DDL_DELETE_NOT_SUPPORTED"), dBObject);
    }

    static UnsupportedDDLException undeleteNotSupported(DBObject dBObject) {
        return new UnsupportedDDLException(APIBundle.get("DDL_UNDELETE_NOT_SUPPORTED"), dBObject);
    }
}

