/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.diff.Difference;

public class DDLOptions
extends HashStructureAdapter {
    private static final String REPLACE = "replace";
    private static final String CASCADE = "cascadeDelete";
    private static final String PROMPTS = "sqlPlus";
    private static final String PREFIX = "schemaNames";
    private static final String SPOOL = "spoolCommands";
    private static final String SQLBLANKLINES = "SQLBLANKLINES";
    private Difference m_contextDiff;

    protected DDLOptions(HashStructure hashStructure) {
        super(hashStructure);
    }

    public DDLOptions() {
        super(HashStructure.newInstance());
    }

    public DDLOptions(boolean bl, boolean bl2) {
        this();
        this.setReplace(bl);
        this.setCascade(bl2);
    }

    public void setReplace(boolean bl) {
        this._hash.putBoolean(REPLACE, bl);
    }

    public final boolean isReplace() {
        return this._hash.getBoolean(REPLACE, false);
    }

    public void setCascade(boolean bl) {
        this._hash.putBoolean(CASCADE, bl);
    }

    public final boolean isCascade() {
        return this._hash.getBoolean(CASCADE, false);
    }

    public void setPrefixSchemaName(boolean bl) {
        this._hash.putBoolean(PREFIX, bl);
    }

    public boolean isPrefixSchemaName() {
        return this._hash.getBoolean(PREFIX, false);
    }

    public void setIncludePrompts(boolean bl) {
        this._hash.putBoolean(PROMPTS, bl);
    }

    public boolean isIncludePrompts() {
        return this._hash.getBoolean(PROMPTS, false);
    }

    public String getSpoolFile() {
        return this._hash.getString(SPOOL);
    }

    public void setSpoolFile(String string) {
        this._hash.putString(SPOOL, string);
    }

    public boolean isSqlBlankLines() {
        return this._hash.getBoolean(SQLBLANKLINES, false);
    }

    public void setSqlBlankLines(boolean bl) {
        this._hash.putBoolean(SQLBLANKLINES, bl);
    }

    Difference getContextDifference() {
        return this.m_contextDiff;
    }

    static DDLOptions copyForUpdate(DDLOptions dDLOptions, Difference difference) {
        DDLOptions dDLOptions2 = (DDLOptions)((Object)dDLOptions.copyTo(null));
        boolean bl = false;
        if (dDLOptions.m_contextDiff != null) {
            for (Difference difference2 = difference; difference2 != null; difference2 = difference2.getParent()) {
                if (difference2 != dDLOptions.m_contextDiff) continue;
                bl = true;
                break;
            }
        }
        dDLOptions2.m_contextDiff = bl ? dDLOptions.m_contextDiff : difference;
        return dDLOptions2;
    }
}

