/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Internal;
import oracle.javatools.util.ModelUtil;

public final class DataTypeID
implements DBObjectID {
    private static final String s_stringPrefix = "DataTypeID:";
    private String m_typeName;
    private String m_schemaName;
    private DatabaseDescriptor m_desc;

    public DataTypeID() {
    }

    public DataTypeID(String string, DatabaseDescriptor databaseDescriptor) {
        this(string, null, databaseDescriptor);
    }

    public DataTypeID(String string, String string2, DatabaseDescriptor databaseDescriptor) {
        this.m_schemaName = string2;
        this.m_typeName = string;
        this.m_desc = databaseDescriptor;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String string) {
        this.m_typeName = string;
    }

    public DatabaseDescriptor getDatabaseDescriptor() {
        return this.m_desc;
    }

    @Deprecated
    @Internal
    public Class getProviderClass() {
        return null;
    }

    @Deprecated
    public void setProviderClass(Class clazz) {
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public boolean equals(DBObjectID dBObjectID) {
        return this.equals(dBObjectID, true);
    }

    @Override
    public boolean equals(DBObjectID dBObjectID, boolean bl) {
        return dBObjectID instanceof DataTypeID && this.equalsImpl((DataTypeID)dBObjectID);
    }

    protected boolean equalsImpl(DataTypeID dataTypeID) {
        return ModelUtil.areEqual((Object)this.m_typeName, (Object)dataTypeID.m_typeName) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)dataTypeID.m_schemaName) && this.isSameDescriptor(dataTypeID.m_desc);
    }

    private boolean isSameDescriptor(DatabaseDescriptor databaseDescriptor) {
        boolean bl = this.m_desc == databaseDescriptor ? true : (this.m_desc == null || databaseDescriptor == null ? false : ModelUtil.areEqual((Object)this.m_desc.getDatabaseType(), (Object)databaseDescriptor.getDatabaseType()) && this.m_desc.getDatabaseVersion() == databaseDescriptor.getDatabaseVersion());
        return bl;
    }

    public Object copyTo(Object object) {
        DataTypeID dataTypeID = object == null ? new DataTypeID() : (DataTypeID)object;
        this.copyToImpl(dataTypeID);
        return dataTypeID;
    }

    protected void copyToImpl(DataTypeID dataTypeID) {
        dataTypeID.m_desc = this.m_desc;
        dataTypeID.m_schemaName = this.m_schemaName;
        dataTypeID.m_typeName = this.m_typeName;
    }

    @Override
    public String getType() {
        return this.m_schemaName == null ? "DATATYPE" : "TYPE";
    }

    @Override
    public DBObject resolveID() throws DBException {
        return this.resolveIDImpl(false);
    }

    private DataType resolveIDImpl(boolean bl) {
        DataType dataType = null;
        if (this.m_desc != null && ModelUtil.hasLength((String)this.m_typeName)) {
            if (this.m_schemaName != null) {
                DBObjectCriteria<Type> dBObjectCriteria = new DBObjectCriteria<Type>(Type.class, new String[0]);
                dBObjectCriteria.setName(this.m_typeName);
                dBObjectCriteria.setSchemaName(this.m_schemaName);
                Collection<Type> collection = this.m_desc.listBuiltInObjects(dBObjectCriteria);
                if (collection.size() == 1) {
                    dataType = collection.iterator().next();
                }
            } else {
                dataType = this.m_desc.getDataType(this.m_typeName);
            }
            if (dataType == null) {
                DBLog.getLogger(this).log(bl ? Level.FINE : Level.WARNING, "DataTypeID: DataType {0} not found for {1}", new String[]{this.m_typeName, this.m_desc.getDatabaseType()});
            }
        }
        return dataType;
    }

    public void ensureProvider(DBObjectProvider dBObjectProvider) {
        if (dBObjectProvider != null && this.m_typeName != null) {
            DBObjectID dBObjectID;
            this.m_desc = dBObjectProvider.getDescriptor();
            DataType dataType = this.resolveIDImpl(true);
            if (dataType != null && (dBObjectID = dataType.getID()) instanceof DataTypeID) {
                this.m_desc = ((DataTypeID)dBObjectID).getDatabaseDescriptor();
            }
        }
    }

    @Override
    public DBObjectID getParent() {
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof DBObjectID && this.equals((DBObjectID)object);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(s_stringPrefix);
        if (this.m_schemaName != null) {
            stringBuilder.append(this.m_schemaName).append(":");
        }
        stringBuilder.append(this.m_typeName);
        if (this.m_desc != null) {
            stringBuilder.append(":").append(this.m_desc.getDatabaseType()).append(":").append(this.m_desc.getDatabaseVersion());
        }
        return stringBuilder.toString();
    }

    public static final boolean isIDType(String string) {
        return string.startsWith(s_stringPrefix);
    }

    public static DataTypeID createFromString(String string) {
        DataTypeID dataTypeID = null;
        if (DataTypeID.isIDType(string)) {
            String string2 = null;
            String string3 = null;
            String[] stringArray = string.split(":");
            if (stringArray.length == 4) {
                string3 = stringArray[2];
                string2 = stringArray[3];
            } else if (stringArray.length == 3) {
                string3 = stringArray[1];
                string2 = stringArray[2];
            } else if (stringArray.length == 2) {
                string2 = stringArray[1];
            }
            if (string2 != null) {
                dataTypeID = new DataTypeID(string2, string3, null);
            }
        }
        return dataTypeID;
    }
}

