/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.ora.XMLTypeColumnProperties;
import oracle.javatools.db.plsql.PlSqlReference;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.token.Token;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.util.ModelUtil;

public class DataTypeHelper {
    private static Logger getLogger() {
        return DBLog.getLogger(DataTypeHelper.class);
    }

    public static DataType getDataType(DataTypeUsage dataTypeUsage) throws DBException {
        return DataTypeHelper.getDataType(dataTypeUsage, true);
    }

    public static DataType getDataType(DataTypeUsage dataTypeUsage, boolean bl) throws DBException {
        DataType dataType = null;
        if (dataTypeUsage != null) {
            DBObject dBObject;
            DBObjectID dBObjectID = dataTypeUsage.getDataTypeID();
            if (dBObjectID == null) {
                throw new DBException((DBObject)dataTypeUsage, "Column's DataTypeUsage has no DataTypeID to resolve.");
            }
            if (dBObjectID instanceof ReferenceID && "DATATYPE".equals(dBObjectID.getType())) {
                if (((ReferenceID)dBObjectID).getSchemaName() == null) {
                    dBObjectID = (DBObjectID)dBObjectID.copyTo(null);
                    ((ReferenceID)dBObjectID).setSchema(DBUtil.getSchema(dataTypeUsage));
                }
                dBObject = DataTypeHelper.resolveDataTypeReferenceID((ReferenceID)dBObjectID);
            } else {
                dBObject = dBObjectID.resolveID();
            }
            if (dBObject instanceof Synonym) {
                dBObject = DBUtil.getSynonymReference((Synonym)dBObject);
            }
            DataType dataType2 = dataType = dBObject instanceof DataType ? (DataType)dBObject : null;
            if (dataType == null && bl && dBObjectID instanceof BaseObjectID) {
                BaseObjectID baseObjectID = (BaseObjectID)dBObjectID;
                String string = baseObjectID.getName();
                String string2 = baseObjectID.getType();
                if (string != null && ("DATATYPE".equals(string2) || "TYPE".equals(string2))) {
                    DBObjectProvider dBObjectProvider = baseObjectID.getProvider();
                    String string3 = baseObjectID.getSchemaName();
                    if ((dBObjectProvider == null || dBObjectProvider.supportsObjectType("TYPE")) && ("TYPE".equals(string2) || string3 != null)) {
                        if (string3 != null) {
                            Schema schema;
                            try {
                                schema = dBObjectProvider == null ? null : dBObjectProvider.getSchema(string3);
                            }
                            catch (DBException dBException) {
                                schema = null;
                            }
                            if (schema == null) {
                                schema = new Schema(string3);
                            }
                            if (dBObjectProvider == null) {
                                dataType = new Type();
                                dataType.setName(string);
                                ((Type)dataType).setSchema(schema);
                            } else {
                                dataType = dBObjectProvider.getObjectFactory().newObject(Type.class, schema, string, false, false);
                            }
                        }
                    } else {
                        dataType = DataTypeRegistry.getInstance().createUserDataType(string, dBObjectProvider);
                    }
                }
            }
        }
        return dataType;
    }

    public static DBObject resolveDataTypeReferenceID(ReferenceID referenceID) throws DBException {
        Object object;
        Synonym synonym = null;
        DBObjectProvider dBObjectProvider = referenceID.getProvider();
        if (dBObjectProvider == null) {
            throw new MissingProviderException();
        }
        String string = referenceID.getName();
        String string2 = referenceID.getSchemaName();
        if (string2 == null && (object = dBObjectProvider.getDefaultSchema()) != null) {
            string2 = ((AbstractDBObject)object).getName();
        }
        if (string != null && string2 != null) {
            object = new DBObjectCriteria<Type>(Type.class, new String[0]);
            ((DBObjectCriteria)object).setName(string);
            ((DBObjectCriteria)object).setSchemaName(string2);
            synonym = (Synonym)dBObjectProvider.getDescriptor().getBuiltInObject(object);
            if (synonym == null && (synonym = (Synonym)dBObjectProvider.getObject(object)) == null && dBObjectProvider.supportsObjectType("SYNONYM")) {
                String string3;
                DBObjectCriteria<Synonym> dBObjectCriteria = new DBObjectCriteria<Synonym>(Synonym.class, new String[0]);
                dBObjectCriteria.setName(string);
                dBObjectCriteria.setSchemaName(string2);
                synonym = dBObjectProvider.getObject(dBObjectCriteria);
                if (synonym == null && (string3 = dBObjectProvider.getDescriptor().getPublicSchemaName()) != null) {
                    dBObjectCriteria.setSchemaName(string3);
                    synonym = dBObjectProvider.getObject(dBObjectCriteria);
                }
            }
        }
        return synonym;
    }

    public static Long getLongAttributeValue(DataTypeUsage dataTypeUsage, String string) {
        return DataTypeHelper.toLong(dataTypeUsage.getAttributeValue(string));
    }

    public static String getStringAttributeValue(DataTypeUsage dataTypeUsage, String string) {
        return DataTypeHelper.toString(dataTypeUsage.getAttributeValue(string));
    }

    public static String getStringAttributeDefaultValue(DataTypeUsage dataTypeUsage, String string) {
        String string2 = null;
        try {
            Object object;
            DataTypeAttribute dataTypeAttribute;
            DataType dataType = DataTypeHelper.getDataType(dataTypeUsage, false);
            if (dataType != null && (dataTypeAttribute = dataType.getDataTypeAttribute(string)) != null && (object = dataTypeAttribute.getDefaultValue()) != null) {
                string2 = object.toString();
            }
        }
        catch (DBException dBException) {
            DataTypeHelper.getLogger().warning(dBException.getMessage());
        }
        return string2;
    }

    public static Long toLong(Object object) {
        try {
            String string = object == null ? null : ModelUtil.nullifyIfEmpty((String)object.toString());
            return string == null ? null : Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long toLongOrError(Object object) throws NumberFormatException {
        String string = object == null ? null : ModelUtil.nullifyIfEmpty((String)object.toString());
        return string == null ? null : Long.valueOf(string);
    }

    public static String toString(Object object) {
        return object == null ? null : object.toString();
    }

    @Deprecated
    public static String getNameFromLabel(int n) {
        return null;
    }

    @Deprecated
    public static String getNameFromLabel(String string) {
        return string;
    }

    public static Object getAttributeValue(Object object, DataType dataType, String string) {
        DataTypeAttribute dataTypeAttribute;
        if (object instanceof String && !ModelUtil.hasLength((String)((String)object))) {
            object = null;
        }
        Object object2 = null;
        if (dataType == null || dataType instanceof UserDataType) {
            object2 = object;
        } else if (object != null && (dataTypeAttribute = dataType.getDataTypeAttribute(string)) != null) {
            int n = dataTypeAttribute.getValueType();
            if (n == 1) {
                object2 = DataTypeHelper.toLong(object);
            } else if (n == 2) {
                List<String> list;
                String string2 = DataTypeHelper.toString(object);
                String[] stringArray = dataTypeAttribute.getValues();
                if (stringArray != null && (list = Arrays.asList(stringArray)).contains(string2)) {
                    object2 = string2;
                }
                if (object2 == null) {
                    object2 = DataTypeHelper.toLong(object);
                }
            } else {
                object2 = DataTypeHelper.toString(object);
            }
        }
        return object2;
    }

    @Deprecated
    public static String getDDL(DataTypeUsage dataTypeUsage) {
        return DataTypeHelper.getDDL(dataTypeUsage, null);
    }

    public static String getDDL(DataTypeUsage dataTypeUsage, DBObjectProvider dBObjectProvider) {
        DBObjectID dBObjectID;
        String string = null;
        if (dataTypeUsage != null && (dBObjectID = dataTypeUsage.getDataTypeID()) != null) {
            if (dBObjectID instanceof BaseObjectID) {
                String string2 = DataTypeHelper.getTypeStringFromID(dBObjectID, null, dBObjectProvider);
                string = DataTypeHelper.getTypeDDL(dataTypeUsage, string2);
            } else {
                try {
                    DataType dataType = DataTypeHelper.getDataType(dataTypeUsage, false);
                    string = dataType != null ? dataType.getDDL(dataTypeUsage) : DataTypeHelper.getTypeStringFromID(dBObjectID, null, dBObjectProvider);
                }
                catch (DBException dBException) {
                    DataTypeHelper.getLogger().warning("Couldn't resolve datatype ID for DDL: " + dBException.getMessage());
                }
            }
        }
        return string;
    }

    public static boolean canGetTypeStringFromID(DBObjectID dBObjectID) {
        DBObject dBObject = null;
        try {
            dBObject = dBObjectID.resolveID();
        }
        catch (DBException dBException) {
            dBObject = null;
        }
        if (dBObject instanceof DataType) {
            return true;
        }
        if (dBObjectID instanceof ReferenceID) {
            return "DATATYPE".equals(dBObjectID.getType());
        }
        return false;
    }

    @Deprecated
    public static String getTypeStringFromID(DBObjectID dBObjectID, Schema schema) {
        return DataTypeHelper.getTypeStringFromID(dBObjectID, schema, null);
    }

    public static String getTypeStringFromUsage(DataTypeUsage dataTypeUsage, Schema schema, DBObjectProvider dBObjectProvider) {
        String string = dataTypeUsage == null ? null : DataTypeHelper.getTypeStringFromID(dataTypeUsage.getDataTypeID(), schema, dBObjectProvider);
        return string;
    }

    public static String getTypeStringFromID(DBObjectID dBObjectID, Schema schema, DBObjectProvider dBObjectProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = dBObjectProvider == null ? null : dBObjectProvider.getDescriptor().getPublicSchemaName();
        String string2 = schema == null ? null : schema.getName();
        DBObject dBObject = null;
        if (dBObjectProvider != null && dBObjectID instanceof BaseObjectID && "UNSPECIFIED_TYPE".equals(dBObjectID.getType())) {
            dBObject = dBObjectProvider.getDataType(((BaseObjectID)dBObjectID).getName());
        }
        if (dBObjectID != null && dBObject == null) {
            try {
                dBObject = dBObjectID.resolveID();
            }
            catch (DBException dBException) {
                DataTypeHelper.getLogger().warning(dBException.getMessage());
            }
        }
        if (dBObject != null) {
            stringBuilder.append(DataTypeHelper.getExternalName(dBObject, dBObjectProvider));
            DBObject dBObject2 = dBObject;
            while (dBObject2.getParent() != null) {
                dBObject2 = dBObject2.getParent();
                stringBuilder.insert(0, ".");
                stringBuilder.insert(0, DataTypeHelper.getExternalName(dBObject2, dBObjectProvider));
            }
            if (dBObject2 instanceof SchemaObject) {
                String string3;
                Schema schema2 = ((SchemaObject)dBObject2).getSchema();
                String string4 = string3 = schema2 == null ? null : schema2.getName();
                if (ModelUtil.hasLength((String)string3) && ModelUtil.areDifferent((Object)string3, (Object)string2) && ModelUtil.areDifferent((Object)string3, (Object)string)) {
                    stringBuilder.insert(0, ".");
                    stringBuilder.insert(0, DataTypeHelper.getExternalName(string3, "SCHEMA", dBObjectProvider));
                }
            }
        } else if (dBObjectID instanceof BaseObjectID) {
            String string5;
            DBObjectID dBObjectID2 = dBObjectID;
            boolean bl = false;
            while (dBObjectID2 instanceof BaseObjectID) {
                if (bl) {
                    stringBuilder.insert(0, ".");
                }
                stringBuilder.insert(0, DataTypeHelper.getExternalName((BaseObjectID)dBObjectID2, dBObjectProvider));
                bl = true;
                if (dBObjectID2.getParent() == null) break;
                dBObjectID2 = dBObjectID2.getParent();
            }
            if (dBObjectID2 instanceof BaseObjectID && ModelUtil.hasLength((String)(string5 = ((BaseObjectID)dBObjectID2).getSchemaName())) && ModelUtil.areDifferent((Object)string5, (Object)string2) && ModelUtil.areDifferent((Object)string5, (Object)string)) {
                stringBuilder.insert(0, ".");
                stringBuilder.insert(0, DataTypeHelper.getExternalName(string5, "SCHEMA", dBObjectProvider));
            }
        }
        return stringBuilder.toString();
    }

    private static String getExternalName(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        String string = dBObject instanceof PredefinedDataType ? dBObject.getName() : DataTypeHelper.getExternalName(dBObject.getName(), dBObject.getType(), dBObjectProvider);
        return string;
    }

    private static String getExternalName(BaseObjectID baseObjectID, DBObjectProvider dBObjectProvider) {
        return DataTypeHelper.getExternalName(baseObjectID.getName(), baseObjectID.getType(), dBObjectProvider);
    }

    private static String getExternalName(String string, String string2, DBObjectProvider dBObjectProvider) {
        String string3 = string;
        if (dBObjectProvider != null) {
            string3 = dBObjectProvider.getExternalName(string3, string2);
        }
        return string3;
    }

    public static String getTypeDDL(DataTypeUsage dataTypeUsage, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (dataTypeUsage.hasAttributeValue("ref")) {
            stringBuilder.append("REF ");
        }
        stringBuilder.append(string);
        Object object = dataTypeUsage.getAttributeValue("ref_scope");
        if (object instanceof BaseObjectID) {
            String string2;
            DBObjectProvider dBObjectProvider = ((BaseObjectID)object).getProvider();
            stringBuilder.append(" SCOPE IS ");
            String string3 = ((BaseObjectID)object).getSchemaName();
            if (ModelUtil.hasLength((String)string3)) {
                if (dBObjectProvider != null) {
                    string3 = dBObjectProvider.getExternalName(string3);
                }
                stringBuilder.append(string3).append(".");
            }
            if ((string2 = ((BaseObjectID)object).getName()) != null && dBObjectProvider != null) {
                string2 = dBObjectProvider.getExternalName(string2);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public static String getTypeStringFromRef(PlSqlReference plSqlReference, Schema schema) {
        return DataTypeHelper.getTypeStringFromRef(plSqlReference, schema, null);
    }

    public static String getTypeStringFromRef(PlSqlReference plSqlReference, Schema schema, DBObjectProvider dBObjectProvider) {
        StringBuilder stringBuilder = new StringBuilder(DataTypeHelper.getTypeStringFromID(plSqlReference.getReferenceID(), schema, dBObjectProvider));
        if (plSqlReference.getReferenceType() == PlSqlReference.ReferenceType.PCT_ROWTYPE) {
            stringBuilder.append("%ROWTYPE");
        }
        if (plSqlReference.getReferenceType() == PlSqlReference.ReferenceType.PCT_TYPE) {
            stringBuilder.append("%TYPE");
        }
        if (plSqlReference.getReferenceType() == PlSqlReference.ReferenceType.REF) {
            stringBuilder.insert(0, "REF ");
        }
        return stringBuilder.toString();
    }

    public static PlSqlReference getDataTypeRefForString(DBObjectProvider dBObjectProvider, Schema schema, String string) {
        PlSqlReference plSqlReference = dBObjectProvider != null ? dBObjectProvider.getObjectFactory().newObject(PlSqlReference.class) : new PlSqlReference();
        PlSqlReference.ReferenceType referenceType = PlSqlReference.ReferenceType.DIRECT;
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        if (plSqlToken.matches("ref")) {
            referenceType = PlSqlReference.ReferenceType.REF;
            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
        }
        PlSqlToken plSqlToken2 = plSqlToken;
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        if ((plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken()).matches("TYPE") && ((PlSqlToken)plSqlToken2.getPrevCodeToken()).matches("%")) {
            referenceType = PlSqlReference.ReferenceType.PCT_TYPE;
            plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        } else if (plSqlToken2.matches("ROWTYPE") && ((PlSqlToken)plSqlToken2.getPrevCodeToken()).matches("%")) {
            referenceType = PlSqlReference.ReferenceType.PCT_ROWTYPE;
            plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        }
        String string2 = plSqlToken.getSource(true, (Token)plSqlToken2);
        plSqlReference.setName("datatype");
        plSqlReference.setDataTypeUsageSource(string2);
        if (dBObjectProvider == null) {
            DataTypeUsage dataTypeUsage = DataTypeHelper.getDataTypeUsageForString(dBObjectProvider, schema, string2);
            if (referenceType == PlSqlReference.ReferenceType.REF) {
                dataTypeUsage.putAttributeValue("ref", Boolean.TRUE);
            }
            plSqlReference.setDataTypeUsage(dataTypeUsage);
        }
        plSqlReference.setReferenceType(referenceType);
        return plSqlReference;
    }

    public static DBObjectID findOrCreateIDForTypeString(DBObjectProvider dBObjectProvider, Schema schema, String string) {
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        DBObjectID dBObjectID = DataTypeHelper.findIDForTypeString(dBObjectProvider, schema, string);
        if (dBObjectID == null) {
            dBObjectID = DataTypeHelper.createReferenceIDForTypeString(dBObjectProvider, schema, string);
        }
        return dBObjectID;
    }

    public static DBObjectID createReferenceIDForTypeString(DBObjectProvider dBObjectProvider, Schema schema, String string) {
        PlSqlToken plSqlToken;
        Object object = null;
        PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        PlSqlToken plSqlToken3 = null;
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        plSqlToken3 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        try {
            Object object2;
            String string2 = dBObjectProvider.getInternalName(plSqlToken.getSource(true));
            Schema schema2 = dBObjectProvider.getSchema(string2);
            boolean bl = ((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".");
            if (schema2 != null && bl) {
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
            } else {
                if (schema2 == null) {
                    schema2 = schema;
                }
                if (schema2 == null) {
                    schema2 = dBObjectProvider.getDefaultSchema();
                }
            }
            String string3 = ((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER ? dBObjectProvider.getInternalName(plSqlToken.getSource(true)) : plSqlToken.getSource(true, (Token)plSqlToken3);
            if (dBObjectProvider != null && schema2 != null) {
                object2 = schema2.getName();
                DBObjectCriteria<Type> dBObjectCriteria = new DBObjectCriteria<Type>(Type.class, new String[0]);
                dBObjectCriteria.setName(string3);
                dBObjectCriteria.setSchemaName((String)object2);
                Type type = dBObjectProvider.getDescriptor().getBuiltInObject(dBObjectCriteria);
                if (type != null) {
                    object = type.getID();
                }
            }
            if (object == null) {
                object2 = new ReferenceID("DATATYPE", bl ? schema2 : null, string3);
                ((BaseObjectID)object2).setProvider(dBObjectProvider);
                object = object2;
            }
        }
        catch (DBException dBException) {
            DataTypeHelper.getLogger().warning(dBException.getMessage());
        }
        return object;
    }

    public static DBObjectID findIDForTypeString(DBObjectProvider dBObjectProvider, Schema schema, String string) {
        PlSqlToken plSqlToken;
        DataType dataType = null;
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        DBObjectID dBObjectID = null;
        PlSqlToken plSqlToken2 = plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
        PlSqlToken plSqlToken3 = null;
        while (plSqlToken2.getType() != Token.Type.END_MARKER) {
            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
        }
        plSqlToken3 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        DataType dataType2 = dBObjectProvider.getDataType(plSqlToken.getSource(true, (Token)plSqlToken3));
        if (dataType2 != null) {
            if (dataType2 instanceof UserDataType) {
                dataType = dataType2;
            } else {
                return dataType2.getID();
            }
        }
        if (plSqlToken.matches("REF")) {
            throw new IllegalArgumentException("refs not done like this any more");
        }
        if (dataType != null) {
            return dataType.getID();
        }
        if (dBObjectProvider.supportsObjectType("PROCEDURE") || dBObjectProvider.supportsObjectType("TYPE")) {
            Schema schema2 = schema;
            try {
                if (schema2 == null) {
                    schema2 = dBObjectProvider.getDefaultSchema();
                }
            }
            catch (DBException dBException) {
                DataTypeHelper.getLogger().warning(dBException.getMessage());
            }
            if (schema2 != null) {
                dBObjectID = DataTypeHelper.findObjectID(dBObjectProvider, schema2, plSqlToken);
            }
            if (dBObjectID == null) {
                try {
                    schema2 = dBObjectProvider.getSchema(dBObjectProvider.getInternalName(plSqlToken.getSource(true)));
                    if (schema2 != null && ((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                        dBObjectID = DataTypeHelper.findObjectID(dBObjectProvider, schema2, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                    }
                }
                catch (DBException dBException) {
                    DataTypeHelper.getLogger().warning(dBException.getMessage());
                }
            }
        }
        return dBObjectID;
    }

    public static DataTypeUsage getDataTypeUsage(DBObjectProvider dBObjectProvider, Schema schema, String string, int n, int n2, int n3) {
        DataTypeUsage dataTypeUsage = null;
        DataType dataType = dBObjectProvider.getDataType(string);
        if (dataType == null) {
            DBObjectID dBObjectID = DataTypeHelper.findIDForTypeString(dBObjectProvider, schema, string);
            if (dBObjectID != null) {
                dataTypeUsage = new DataTypeUsage();
                dataTypeUsage.setDataTypeID(dBObjectID);
            }
        } else {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", string);
            hashMap.put("size", DataTypeHelper.getAttributeValue(n, dataType, "size"));
            hashMap.put("precision", DataTypeHelper.getAttributeValue(n2, dataType, "precision"));
            hashMap.put("scale", DataTypeHelper.getAttributeValue(n3, dataType, "scale"));
            dataTypeUsage = dataType.createUsage(hashMap);
        }
        return dataTypeUsage;
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider dBObjectProvider, Schema schema, String string) {
        return DataTypeHelper.getDataTypeUsageForString(dBObjectProvider, schema, string, false);
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider dBObjectProvider, Schema schema, String string, boolean bl) {
        Object object;
        DataTypeUsage dataTypeUsage = null;
        if (ModelUtil.hasLength((String)string)) {
            object = dBObjectProvider.listSupportedDataTypes();
            int n = ((DataType[])object).length;
            for (int i = 0; i < n; ++i) {
                DataType dataType = object[i];
                if (!dataType.matches(string)) continue;
                dataTypeUsage = dataType.createUsage(string);
                break;
            }
        }
        if (!(dataTypeUsage != null || (object = bl ? DataTypeHelper.findIDForTypeString(dBObjectProvider, schema, string) : DataTypeHelper.findOrCreateIDForTypeString(dBObjectProvider, schema, string)) == null || object instanceof DataTypeID && !ModelUtil.hasLength((String)((DataTypeID)object).getSchemaName()) && bl)) {
            dataTypeUsage = new DataTypeUsage();
            dataTypeUsage.setDataTypeID((DBObjectID)object);
        }
        return dataTypeUsage;
    }

    private static DBObjectID findObjectID(DBObjectProvider dBObjectProvider, DBObject dBObject, PlSqlToken plSqlToken) {
        String string = dBObjectProvider.getInternalName(plSqlToken.getSource(true));
        if (dBObject instanceof Schema) {
            for (String string2 : DataTypeHelper.getOrderedTypes(dBObjectProvider, "TYPE", "TABLE")) {
                SchemaObject schemaObject = null;
                try {
                    schemaObject = dBObjectProvider.getObject(string2, (Schema)dBObject, string);
                }
                catch (DBException dBException) {
                    schemaObject = null;
                }
                if (schemaObject == null) continue;
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return schemaObject.getID();
                }
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                    return DataTypeHelper.findObjectID(dBObjectProvider, schemaObject, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                }
                return null;
            }
        } else {
            for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
                if (dBObject2.getName() == null || !dBObject2.getName().equals(string)) continue;
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).getType() == Token.Type.END_MARKER) {
                    return dBObject2.getID();
                }
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                    return DataTypeHelper.findObjectID(dBObjectProvider, dBObject2, (PlSqlToken)plSqlToken.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    private static String[] getOrderedTypes(DBObjectProvider dBObjectProvider, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : dBObjectProvider.listObjectTypes()) {
            arrayList.add(string);
        }
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!arrayList.contains(stringArray[i])) continue;
            arrayList.remove(stringArray[i]);
            arrayList.add(0, stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static TokenPattern buildSearch(String string, DataTypeAttribute[] dataTypeAttributeArray) {
        TokenPattern tokenPattern = null;
        HashMap<String, DataTypeAttribute> hashMap = new HashMap<String, DataTypeAttribute>();
        for (DataTypeAttribute dataTypeAttribute : dataTypeAttributeArray) {
            hashMap.put(dataTypeAttribute.getName(), dataTypeAttribute);
        }
        try {
            String[] stringArray;
            DataTypeAttribute dataTypeAttribute;
            String string2 = string.replace("\\<", " \\< ");
            String string3 = string2.replaceAll("([^\\\\])\\>", "$1?>");
            String string4 = string2;
            dataTypeAttribute = new TokenPattern(string3);
            for (String string5 : stringArray = dataTypeAttribute.getNames()) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<").append(string5).append(">");
                StringBuffer stringBuffer2 = new StringBuffer();
                DataTypeAttribute dataTypeAttribute2 = (DataTypeAttribute)hashMap.get(string5);
                String[] stringArray2 = dataTypeAttribute2.getValues();
                if (dataTypeAttribute2 != null && stringArray2 != null && stringArray2.length > 0) {
                    stringBuffer2.append("<").append(string5).append(" {");
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringBuffer2.append(stringArray2[n]);
                        if (n >= stringArray2.length - 1) continue;
                        stringBuffer2.append("|");
                    }
                    stringBuffer2.append("}>");
                } else {
                    n = dataTypeAttribute2.getValueType();
                    String string6 = n == 1 || n == 2 ? " [{-|+}]?>" : (n == 3 ? " {?}...>" : " ?>");
                    stringBuffer2.append("<").append(string5).append(string6);
                }
                string4 = string4.replace(stringBuffer.toString(), stringBuffer2.toString());
            }
            tokenPattern = new TokenPattern(DataTypeHelper.addTail(string4));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DataTypeHelper.getLogger().severe("Cannot create PlSqlSearch based on PredefinedDataType definition " + string + " - " + illegalArgumentException.getMessage());
        }
        return tokenPattern;
    }

    static DataTypeUsage getUsageFromString(DataType dataType, TokenPattern tokenPattern, String string) {
        DataTypeUsage dataTypeUsage = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TokenPattern.PatternResult patternResult = DataTypeHelper.matches(tokenPattern, string);
        if (patternResult != null) {
            for (String string2 : tokenPattern.getNames()) {
                DataTypeAttribute dataTypeAttribute = dataType.getDataTypeAttribute(string2);
                if (dataTypeAttribute == null) continue;
                String string3 = patternResult.getNamedMatch(string2, false);
                Object object = string3;
                if (string3 != null) {
                    object = DataTypeHelper.getAttributeValue(string3, dataType, string2);
                }
                hashMap.put(string2, object);
            }
            dataTypeUsage = dataType.createUsage(hashMap);
        }
        return dataTypeUsage;
    }

    static TokenPattern.PatternResult matches(TokenPattern tokenPattern, String string) {
        return tokenPattern == null ? null : tokenPattern.getResult(DataTypeHelper.addTail(string));
    }

    private static String addTail(String string) {
        return string + " \\";
    }

    @Deprecated
    public static boolean isXMLType(DataType dataType) {
        return XMLTypeColumnProperties.isXMLType(dataType);
    }

    public static boolean isTableType(DataType dataType) {
        PlSqlSearch plSqlSearch;
        boolean bl = false;
        if (dataType instanceof Type && (plSqlSearch = new PlSqlSearch("[create [ or replace] ] type ?. [oid ?] {is|as} table of")).matches(((Type)dataType).getSource())) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTypeOf(DataType dataType, Class<? extends DataType> clazz) {
        return DataTypeHelper.unwrapDataType(dataType, clazz) != null;
    }

    public static <D extends DataType> D unwrapDataType(DataType dataType, Class<D> clazz) {
        while (dataType instanceof DataTypeSynonym) {
            dataType = ((DataTypeSynonym)dataType).getBaseType();
        }
        DataType dataType2 = null;
        if (dataType != null && clazz.isAssignableFrom(dataType.getClass())) {
            dataType2 = (DataType)clazz.cast(dataType);
        }
        return (D)dataType2;
    }

    public static PredefinedDataType.ValueType getValueType(DataType dataType) {
        PredefinedDataType predefinedDataType = DataTypeHelper.unwrapDataType(dataType, PredefinedDataType.class);
        return predefinedDataType == null ? null : predefinedDataType.getValueType();
    }

    public static boolean isNumericType(DataType dataType) {
        return PredefinedDataType.ValueType.isNumericType(DataTypeHelper.getValueType(dataType));
    }
}

