/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractSystemObject;
import oracle.javatools.db.FileSpecification;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;

public class Tablespace
extends AbstractSystemObject {
    public static final String TYPE = "TABLESPACE";
    @PropertyKey(value=TablespaceType.class, childOf={Tablespace.class})
    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public static final String TABLESPACE_TYPE_KEY = "TablespaceType";

    public Tablespace() {
        this(null);
    }

    public Tablespace(String string) {
        this.setName(string);
        this.setProperty(TABLESPACE_TYPE_KEY, (Object)TablespaceType.PERMANENT);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setFileType(FileType fileType) {
        this.setProperty("fileType", (Object)fileType);
    }

    public FileType getFileType() {
        return (FileType)((Object)this.getProperty("fileType"));
    }

    public void setFileSpecifications(FileSpecification[] fileSpecificationArray) {
        this.getChildSupport("fileSpecifications").setChildArray(fileSpecificationArray);
    }

    public FileSpecification[] getFileSpecifications() {
        return this.getChildSupport("fileSpecifications").getChildArray(FileSpecification.class);
    }

    public void addFileSpecification(FileSpecification fileSpecification) {
        this.getChildSupport("fileSpecifications").addChild(fileSpecification);
    }

    public void addFileSpecification(int n, FileSpecification fileSpecification) {
        this.getChildSupport("fileSpecifications").addChild(n, fileSpecification);
    }

    public FileSpecification getFileSpecification(String string) {
        return (FileSpecification)this.getChildSupport("fileSpecifications").findChild(string);
    }

    public void removeFileSpecification(FileSpecification fileSpecification) {
        this.getChildSupport("fileSpecifications").removeChild(fileSpecification);
    }

    public static enum FileType {
        SMALLFILE,
        BIGFILE;

    }

    public static enum TablespaceType {
        PERMANENT,
        TEMPORARY,
        UNDO;

    }
}

