/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.math.BigDecimal;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public class IdentifierBasedID
extends BaseObjectID {
    private Object m_id;

    public IdentifierBasedID() {
    }

    public IdentifierBasedID(String string, Object object) {
        this(string, object, null);
    }

    public IdentifierBasedID(String string, Object object, AbstractDBObjectProvider abstractDBObjectProvider) {
        super(string, abstractDBObjectProvider);
        this.m_id = object;
    }

    public IdentifierBasedID(DBObject dBObject, Object object, AbstractDBObjectProvider abstractDBObjectProvider) {
        super(dBObject, abstractDBObjectProvider);
        this.m_id = object;
    }

    @Override
    public void construct(String string) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        this.setType(string2);
        this.m_id = string3;
        try {
            BigDecimal bigDecimal = new BigDecimal(string3);
            this.m_id = bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (stringArray.length > 2) {
            int n = string2.length() + ":".length() + string3.length() + ":".length();
            this.setParent(BaseObjectID.createFromString(string.substring(n)));
        }
    }

    @Override
    protected boolean equalsImpl(DBObjectID dBObjectID, boolean bl) {
        if (bl) {
            return dBObjectID instanceof IdentifierBasedID && this.equalsImpl((IdentifierBasedID)dBObjectID);
        }
        if (dBObjectID instanceof IdentifierBasedID && this.equalsImpl((IdentifierBasedID)dBObjectID)) {
            return true;
        }
        if (dBObjectID instanceof BaseObjectID) {
            String string = this.getName();
            if (string != null) {
                return this.hasSameObjectName((BaseObjectID)dBObjectID);
            }
            if (((BaseObjectID)dBObjectID).getName() == null && ModelUtil.areEqual((Object)this.getType(), (Object)dBObjectID.getType())) {
                DBObjectID dBObjectID2 = this.getParent();
                return dBObjectID2 != null && dBObjectID2.equals(dBObjectID.getParent(), bl);
            }
        }
        return false;
    }

    public final Object getIdentifier() {
        return this.m_id;
    }

    public final void setIdentifier(Object object) {
        this.clearToString();
        this.m_id = object;
    }

    public Object copyTo(Object object) {
        if (object instanceof BaseObjectID && !(object instanceof IdentifierBasedID)) {
            this.copyToImpl((BaseObjectID)object);
            return object;
        }
        IdentifierBasedID identifierBasedID = object == null ? new IdentifierBasedID() : (IdentifierBasedID)object;
        this.copyToImpl(identifierBasedID);
        return identifierBasedID;
    }

    protected void copyToImpl(IdentifierBasedID identifierBasedID) {
        super.copyToImpl(identifierBasedID);
        identifierBasedID.m_id = this.m_id;
    }

    private boolean equalsImpl(IdentifierBasedID identifierBasedID) {
        return ModelUtil.areEqual((Object)identifierBasedID.m_id, (Object)this.m_id) && ModelUtil.areEqual((Object)identifierBasedID.getType(), (Object)this.getType()) && ModelUtil.areEqual((Object)identifierBasedID.getDatabaseName(), (Object)this.getDatabaseName());
    }

    @Override
    protected String toStringImpl() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getType());
        stringBuilder.append(":").append(this.m_id);
        if (this.getParent() instanceof BaseObjectID) {
            stringBuilder.append(":").append(this.getParent().toString());
        }
        return stringBuilder.toString();
    }

    @Override
    protected boolean canEquateWithNullParent(DBObjectID dBObjectID) {
        return this.m_id != null && dBObjectID instanceof IdentifierBasedID;
    }

    @Override
    public DBObject resolveID() throws DBException {
        DBObject dBObject = null;
        dBObject = this.m_id != null && Metadata.getInstance().isTypeOf(SystemObject.class, this.getType()) ? this.resolveFromProvider() : super.resolveID();
        return dBObject;
    }
}

