/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;

public abstract class Constraint
extends AbstractChildBuildableObject {
    public static final String TYPE = "CONSTRAINT";

    protected Constraint() {
        this((String)null, (Relation)null);
    }

    protected Constraint(String string, Relation relation) {
        super(string, relation);
        this.setEnabled(true);
    }

    public void setEnabled(boolean bl) {
        this.setProperty("enabled", bl);
    }

    public boolean isEnabled() {
        return (Boolean)this.getProperty("enabled", true);
    }

    public void setDeferrableState(DeferrableState deferrableState) {
        this.setProperty("deferrableState", (Object)deferrableState);
    }

    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public DeferrableState getDeferrableState() {
        return (DeferrableState)((Object)this.getProperty("deferrableState"));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public abstract String getConstraintType();

    @Internal
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    public static Collection<Constraint> getConstraints(Relation relation, String ... stringArray) {
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        if (stringArray != null) {
            Arrays.sort(stringArray);
            for (Constraint constraint : relation.getConstraints()) {
                if (Arrays.binarySearch(stringArray, constraint.getConstraintType()) < 0) continue;
                arrayList.add(constraint);
            }
        }
        return arrayList;
    }

    public static Collection<String> getConstraintTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("UniqueConstraint");
        arrayList.add("PKConstraint");
        arrayList.add("FKConstraint");
        arrayList.add("CheckConstraint");
        return arrayList;
    }

    public static enum DeferrableState {
        DEFER_INIT_IMMEDIATE,
        DEFER_INIT_DEFERRED;

    }
}

