/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.References;
import oracle.javatools.db.refactoring.CascadeAction;
import oracle.javatools.db.resource.APIBundle;

public abstract class ColumnConstraint
extends Constraint {
    ColumnConstraint() {
    }

    ColumnConstraint(String string, Relation relation) {
        super(string, relation);
    }

    @Internal
    public Column[] getColumns() throws IllegalStateException {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        DBObjectID[] dBObjectIDArray = this.getColumnIDs();
        if (dBObjectIDArray.length > 0) {
            Relation relation = this.getRelation();
            if (relation == null) {
                throw new IllegalStateException(APIBundle.get("CONSTRAINT_ERROR_ORPHANED_CONSTRAINT"));
            }
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                if (dBObjectIDArray[i] == null) {
                    throw new IllegalStateException(APIBundle.format("CONSTRAINT_ERROR_MISSING_COLUMN_INDEX", i));
                }
                Column column = (Column)relation.findOwnedObject(dBObjectIDArray[i]);
                if (column == null) {
                    throw new IllegalStateException(APIBundle.format("CONSTRAINT_ERROR_MISSING_COLUMN", DBUtil.getDBObjectName(dBObjectIDArray[i])));
                }
                arrayList.add(column);
            }
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    public void setColumns(Column[] columnArray) {
        this.getChildSupport("columnIDs").clearChildren();
        if (columnArray != null) {
            for (int i = 0; i < columnArray.length; ++i) {
                this.addColumn(columnArray[i]);
            }
        }
    }

    private Column checkColumn(Column column, Relation relation) {
        String string;
        if (relation == null) {
            throw new IllegalArgumentException("need a relation set to add columns to constraint " + this.getName());
        }
        if (column.getRelation() != relation && (column = relation.getColumn(string = column.getName())) == null) {
            throw new IllegalArgumentException("cannot add column " + string + " to constraint " + this.getName() + " - column doesn't exist on this relation");
        }
        return column;
    }

    public void addColumn(Column column) {
        if (column != null) {
            this.addColumnImpl(column, this.getRelation());
        }
    }

    protected void addColumnImpl(Column column, Relation relation) {
        DBObjectID dBObjectID = (column = this.checkColumn(column, relation)).getID();
        if (dBObjectID == null) {
            dBObjectID = TemporaryObjectID.createID(column);
            column.setID(dBObjectID);
        }
        this.getChildSupport("columnIDs").addChild(dBObjectID);
    }

    public boolean removeColumn(Column column) {
        DBObjectID dBObjectID;
        boolean bl = false;
        if (column != null && (dBObjectID = column.getID()) != null) {
            bl = this.getChildSupport("columnIDs").removeChild(dBObjectID);
        }
        return bl;
    }

    @References(value=Column.class, internal=true, cascade=CascadeAction.DELETE)
    public DBObjectID[] getColumnIDs() {
        return this.getChildSupport("columnIDs").getChildArray(DBObjectID.class);
    }

    public void setColumnIDs(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("columnIDs").setChildArray(dBObjectIDArray);
    }

    public static boolean isConstrained(Column column, String ... stringArray) {
        if (stringArray != null) {
            DBObjectID dBObjectID = column.getID();
            Relation relation = column.getRelation();
            if (relation != null && dBObjectID != null) {
                for (Constraint constraint : ColumnConstraint.getConstraints(relation, stringArray)) {
                    if (!(constraint instanceof ColumnConstraint)) continue;
                    for (DBObjectID dBObjectID2 : ((ColumnConstraint)constraint).getColumnIDs()) {
                        if (!dBObjectID.equals(dBObjectID2, true)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

