/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.MLEConstants;

public class ModuleMetadata
extends PropertiesObject {
    List<ExpNode> imports = new ArrayList<ExpNode>();
    List<ExpNode> exports = new ArrayList<ExpNode>();
    List<ExpNode> notResolved = new ArrayList<ExpNode>();

    public boolean hasExportedOwnFunctions() {
        for (ExpNode node : this.exports) {
            if (!"function".equalsIgnoreCase(node.type) || node.module != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean isMinimumDefined() {
        return false;
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        PropertiesObject.CollectionDescriptor cd;
        ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
        if (this.exports.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "exports";
            cd.coll = this::getExports;
            list.add(cd);
        }
        if (this.imports.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "imports";
            cd.coll = this::getImports;
            list.add(cd);
        }
        if (this.notResolved.size() > 0) {
            cd = new PropertiesObject.CollectionDescriptor();
            cd.name = "notResolved";
            cd.coll = this::getNotResolved;
            list.add(cd);
        }
        if (list.size() > 0) {
            return list;
        }
        return super.getCollectionDescriptors();
    }

    @Override
    public PropertiesObject createObjectForCollection(String collName) {
        if (collName != null) {
            return new ExpNode();
        }
        return super.createObjectForCollection(collName);
    }

    public List<ExpNode> getImports() {
        return this.imports;
    }

    public List<ExpNode> getExports() {
        return this.exports;
    }

    public List<ExpNode> getNotResolved() {
        return this.notResolved;
    }

    public List<ExpNode> getNotResolvedByType(String type) {
        ArrayList<ExpNode> list = null;
        for (ExpNode exp : this.notResolved) {
            if (!type.equalsIgnoreCase(exp.type)) continue;
            if (list == null) {
                list = new ArrayList<ExpNode>();
            }
            list.add(exp);
        }
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public List<ExpNode> getNotResolvedImports() {
        if (this.notResolved.size() > 0) {
            ArrayList<ExpNode> res = new ArrayList<ExpNode>();
            for (ExpNode exp : this.notResolved) {
                if (exp.type == null || !exp.type.startsWith("import")) continue;
                res.add(exp);
            }
            return res;
        }
        return Collections.emptyList();
    }

    public List<ExpNode> getNotResolvedExports() {
        if (this.notResolved.size() > 0) {
            ArrayList<ExpNode> res = new ArrayList<ExpNode>();
            for (ExpNode exp : this.notResolved) {
                if (exp.type == null || !exp.type.startsWith("export")) continue;
                res.add(exp);
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public void addObject(String collName, PropertiesObject obj) {
        if (collName != null && "exports".equalsIgnoreCase(collName)) {
            this.exports.add((ExpNode)obj);
            return;
        }
        if (collName != null && "imports".equalsIgnoreCase(collName)) {
            this.imports.add((ExpNode)obj);
            return;
        }
        if (collName != null && "notResolved".equalsIgnoreCase(collName)) {
            this.notResolved.add((ExpNode)obj);
            return;
        }
        super.addObject(collName, obj);
    }

    public static class ModuleMetadataWrapper
    extends ModuleMetadata
    implements MLEConstants {
        public String module_name;
        public String module_owner;
        public String import_name;
        public ModuleMetadata metadata;

        @Override
        public void initPropsList() {
            this.propsList.add("IMPORT_NAME");
            this.propsList.add("MODULE_OWNER");
            this.propsList.add("MODULE_NAME");
        }

        @Override
        public void setProperty(String key, String value) {
            switch (key.toUpperCase()) {
                case "MODULE_OWNER": {
                    this.setModule_owner(value);
                    return;
                }
                case "MODULE_NAME": {
                    this.setModule_name(value);
                    return;
                }
                case "IMPORT_NAME": {
                    this.setImport_name(value);
                    return;
                }
            }
            super.setProperty(key, value);
        }

        @Override
        public String getProperty(String key) {
            return super.getProperty(key);
        }

        public String getModule_name() {
            return this.module_name;
        }

        public void setModule_name(String module_name) {
            this.module_name = module_name;
        }

        public String getModule_owner() {
            return this.module_owner;
        }

        public void setModule_owner(String module_owner) {
            this.module_owner = module_owner;
        }

        public String getImport_name() {
            return this.import_name;
        }

        public void setImport_name(String import_name) {
            this.import_name = import_name;
        }

        @Override
        public String toJSONString(boolean excludeNulls) {
            ExpNode.StringAdd s = new ExpNode.StringAdd();
            s.addText("{");
            if (this.module_owner != null) {
                s.addNL().addTabs("\"module_owner\":\"" + this.module_owner + "\",", 1);
            } else {
                s.addNL().addTabs("\"module_owner\":null,", 1);
            }
            s.addNL().addTabs("\"module_name\":\"" + this.module_name + "\",", 1);
            if (this.import_name != null) {
                s.addNL().addTabs("\"import_name\":\"" + StringUtilities.encodeAttributeValueJSON(this.import_name) + "\",", 1);
            } else {
                s.addNL().addTabs("\"import_name\":null,", 1);
            }
            s.addNL().addTabs("\"metadata\":" + this.metadata.toJSONString(excludeNulls), 1);
            s.addNL().addText("}");
            return s.toString();
        }
    }
}

