/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReaderFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.Value;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptParser;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptParserBaseVisitor;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

public class ImpExpVisitor
extends JavaScriptParserBaseVisitor<Value> {
    public static final String EXPORT_ITEMS_FROM_MODULE = "exportItemsFromModule";
    public static final String EXPORT_NAMESPACE_FROM_MODULE = "exportNamespaceFromModule";
    static final String EXPORT_ITEMS = "exportItems";
    public static final String IMPORT_NAMESPACE = "importNamespace";
    public static final String IMPORT_ITEMS = "importItems";
    public static final String EXPORT_POSSIBLE_IMPORT = "exportPossibleImport";
    List<ParseTree> imports = new ArrayList<ParseTree>();
    List<ParseTree> exports = new ArrayList<ParseTree>();
    List<ErrorNode> errors = new ArrayList<ErrorNode>();
    List<ParseTree> functions = new ArrayList<ParseTree>();
    List<ParseTree> classes = new ArrayList<ParseTree>();
    List<ParseTree> varFunctions = new ArrayList<ParseTree>();
    List<ParseTree> varClasses = new ArrayList<ParseTree>();
    Set<ParseTree> used = new HashSet<ParseTree>();
    public static JsonReaderFactory JSF = Json.createReaderFactory(null);

    @Override
    public Value visitImportStatement(JavaScriptParser.ImportStatementContext ctx) {
        this.imports.add((ParseTree)ctx);
        return (Value)super.visitImportStatement(ctx);
    }

    @Override
    public Value visitExportDeclaration(JavaScriptParser.ExportDeclarationContext ctx) {
        this.exports.add((ParseTree)ctx);
        return (Value)super.visitExportDeclaration(ctx);
    }

    public Value visitErrorNode(ErrorNode node) {
        this.errors.add(node);
        return (Value)super.visitErrorNode(node);
    }

    public static ParserRuleContext getParentWithClass(ParserRuleContext ctx, String className) {
        for (ParserRuleContext parent = ctx.getParent(); parent != null; parent = parent.getParent()) {
            String sname = parent.getClass().getSimpleName();
            if (!sname.endsWith(className)) continue;
            return parent;
        }
        return null;
    }

    @Override
    public Value visitFunctionDeclaration(JavaScriptParser.FunctionDeclarationContext ctx) {
        ParserRuleContext exp = ImpExpVisitor.getParentWithClass(ctx, "ExportDeclarationContext");
        ParserRuleContext var = ImpExpVisitor.getParentWithClass(ctx, "VariableDeclarationContext");
        if (exp != null) {
            this.exports.remove(exp);
            if (var != null) {
                this.exports.add((ParseTree)var);
            } else {
                this.exports.add((ParseTree)ctx);
            }
            return Value.FALSE;
        }
        if (var == null) {
            String sname = ctx.parent.getClass().getSimpleName();
            if (sname.endsWith("StatementContext")) {
                this.functions.add((ParseTree)ctx);
            }
        } else if (exp == null) {
            this.functions.add((ParseTree)var);
        }
        return Value.FALSE;
    }

    @Override
    public Value visitFunctionExpression(JavaScriptParser.FunctionExpressionContext ctx) {
        ParserRuleContext exp = ImpExpVisitor.getParentWithClass(ctx, "ExportDeclarationContext");
        ParserRuleContext var = ImpExpVisitor.getParentWithClass(ctx, "VariableDeclarationContext");
        if (exp != null) {
            this.exports.remove(exp);
            if (var != null) {
                this.exports.add((ParseTree)var);
            } else {
                this.exports.add((ParseTree)ctx);
            }
            return Value.FALSE;
        }
        if (var == null) {
            RuleContext p = (RuleContext)ctx.getChild(0);
            boolean added = false;
            if (p != null) {
                String sname;
                ParseTree n = p.getChild(0);
                boolean isrule = n instanceof RuleContext;
                if (n != null && isrule && (sname = n.getClass().getSimpleName()).endsWith("FunctionDeclarationContext")) {
                    this.functions.add(n);
                    added = true;
                }
            }
            if (!added) {
                this.functions.add((ParseTree)ctx);
            }
        } else if (exp == null) {
            this.functions.add((ParseTree)var);
        }
        return Value.FALSE;
    }

    @Override
    public Value visitClassExpression(JavaScriptParser.ClassExpressionContext ctx) {
        ParserRuleContext exp = ImpExpVisitor.getParentWithClass(ctx, "ExportDeclarationContext");
        ParserRuleContext var = ImpExpVisitor.getParentWithClass(ctx, "VariableDeclarationContext");
        if (exp != null) {
            this.exports.remove(exp);
            if (var != null) {
                this.exports.add((ParseTree)var);
            } else {
                this.exports.add((ParseTree)ctx);
            }
            return Value.FALSE;
        }
        if (var == null) {
            String sname = ctx.parent.getClass().getSimpleName();
            if (sname.endsWith("StatementContext")) {
                this.classes.add((ParseTree)ctx);
            }
        } else if (exp == null) {
            this.classes.add((ParseTree)var);
        }
        return Value.FALSE;
    }

    @Override
    public Value visitClassDeclaration(JavaScriptParser.ClassDeclarationContext ctx) {
        ParserRuleContext exp = ImpExpVisitor.getParentWithClass(ctx, "ExportDeclarationContext");
        ParserRuleContext var = ImpExpVisitor.getParentWithClass(ctx, "VariableDeclarationContext");
        if (exp != null) {
            this.exports.remove(exp);
            if (var != null) {
                this.exports.add((ParseTree)var);
            } else {
                this.exports.add((ParseTree)ctx);
            }
            return Value.FALSE;
        }
        if (var == null) {
            String sname = ctx.parent.getClass().getSimpleName();
            if (sname.endsWith("StatementContext")) {
                this.classes.add((ParseTree)ctx);
            }
        } else if (exp == null) {
            this.classes.add((ParseTree)var);
        }
        return Value.FALSE;
    }

    public static Map<Long, Comment> getComments(CommonTokenStream tokens) {
        Hashtable<Long, Comment> map = new Hashtable<Long, Comment>();
        for (int index = 0; index < tokens.size(); ++index) {
            List hiddenTokensToLeft;
            Token token = tokens.get(index);
            int t_type = token.getType();
            if (t_type != 89 && t_type != 105 && t_type != 100 || (hiddenTokensToLeft = tokens.getHiddenTokensToLeft(index)) == null || hiddenTokensToLeft.size() <= 0) continue;
            for (int i = 0; i < hiddenTokensToLeft.size(); ++i) {
                int type = ((Token)hiddenTokensToLeft.get(i)).getType();
                if (!ImpExpVisitor.isCommentType(type)) continue;
                Token tok = (Token)hiddenTokensToLeft.get(i);
                Comment comment = new Comment();
                comment.comment = tok.getText();
                comment.startLine = tok.getLine();
                comment.lines = comment.comment.lines().count();
                long last = comment.startLine + comment.lines - 1L;
                map.put(last, comment);
            }
        }
        return map;
    }

    static boolean isCommentType(int type) {
        switch (type) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static void resolveExportImportedItems(List<ExpNode> exps, List<ExpNode> imps, Map<String, String> names) {
        for (ExpNode n : imps) {
            try {
                String rname;
                String name;
                if (n.name == null || (name = names.get(rname = MLEJS_Util.getName(n.name))) == null) continue;
                ExpNode x = (ExpNode)n.clone();
                if (!n.name.equals(name)) {
                    x.name = name;
                    x.name_in_code = n.name;
                }
                exps.add(x);
                names.remove(rname);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public static JsonObject getJsonObject(String str) {
        JsonObject jdoc = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8.name()));){
            jdoc = JSF.createReader((InputStream)stream).readObject();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return jdoc;
    }

    static String getCode(List<String> lines, int start, int stop) {
        Object res = "";
        for (int i = start - 1; i < stop; ++i) {
            if (i >= lines.size()) continue;
            res = (String)res + lines.get(i);
        }
        return res;
    }

    public static Map<String, Object> toMap(ParseTree tree) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        ImpExpVisitor.traverse(tree, map);
        return map;
    }

    public static void traverse(ParseTree tree, Map<String, Object> map) {
        if (tree instanceof TerminalNodeImpl) {
            Token token = ((TerminalNodeImpl)tree).getSymbol();
            map.put("type", token.getType());
            map.put("text", token.getText());
        } else {
            ArrayList<LinkedHashMap<String, Object>> children = new ArrayList<LinkedHashMap<String, Object>>();
            String name = tree.getClass().getSimpleName().replaceAll("Context$", "");
            map.put(Character.toLowerCase(name.charAt(0)) + name.substring(1), children);
            for (int i = 0; i < tree.getChildCount(); ++i) {
                LinkedHashMap<String, Object> nested = new LinkedHashMap<String, Object>();
                children.add(nested);
                ImpExpVisitor.traverse(tree.getChild(i), nested);
            }
        }
    }

    public static Map<String, Object> toMap(List<ParseTree> imports, List<ParseTree> exports) {
        LinkedHashMap<String, Object> nested;
        ArrayList<LinkedHashMap<String, Object>> imps = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> exps = new ArrayList<LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("imports", imps);
        map.put("exports", exps);
        for (ParseTree node : imports) {
            nested = new LinkedHashMap<String, Object>();
            imps.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        for (ParseTree node : exports) {
            nested = new LinkedHashMap();
            exps.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        return map;
    }

    public static Map<String, Object> toMap(List<ParseTree> imports, List<ParseTree> exports, List<ParseTree> functions, List<ParseTree> classes) {
        LinkedHashMap<String, Object> nested;
        ArrayList<LinkedHashMap<String, Object>> imps = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> exps = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> funcs = new ArrayList<LinkedHashMap<String, Object>>();
        ArrayList<LinkedHashMap<String, Object>> classesList = new ArrayList<LinkedHashMap<String, Object>>();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("imports", imps);
        map.put("exports", exps);
        map.put("functions", funcs);
        map.put("classes", classesList);
        for (ParseTree node : imports) {
            nested = new LinkedHashMap<String, Object>();
            imps.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        for (ParseTree node : exports) {
            nested = new LinkedHashMap();
            exps.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        for (ParseTree node : functions) {
            nested = new LinkedHashMap();
            funcs.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        for (ParseTree node : classes) {
            nested = new LinkedHashMap();
            classesList.add(nested);
            ImpExpVisitor.traverseAndCut(node, nested);
        }
        return map;
    }

    public static void traverseAndCut(ParseTree tree, Map<String, Object> map) {
        block4: {
            String name;
            block3: {
                name = tree.getClass().getSimpleName().replaceAll("Context$", "");
                if (("classElement".equalsIgnoreCase(name) || "exportFromBlock".equalsIgnoreCase(name)) && tree instanceof ParserRuleContext) {
                    map.put("start", ((ParserRuleContext)tree).start.getLine());
                    map.put("stop", ((ParserRuleContext)tree).stop.getLine());
                }
                if (!(tree instanceof TerminalNodeImpl)) break block3;
                Token token = ((TerminalNodeImpl)tree).getSymbol();
                map.put("type", token.getType());
                map.put("text", token.getText());
                if (!(tree.getParent() instanceof ParserRuleContext)) break block4;
                ParserRuleContext prc = (ParserRuleContext)tree.getParent();
                if (89 != token.getType() && 100 != token.getType() && 60 != token.getType()) break block4;
                map.put("start", prc.start.getLine());
                map.put("stop", prc.stop.getLine());
                break block4;
            }
            ArrayList<LinkedHashMap<String, Object>> children = new ArrayList<LinkedHashMap<String, Object>>();
            if (!"FunctionBody".equalsIgnoreCase(name)) {
                map.put(Character.toLowerCase(name.charAt(0)) + name.substring(1), children);
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    LinkedHashMap<String, Object> nested = new LinkedHashMap<String, Object>();
                    children.add(nested);
                    ImpExpVisitor.traverseAndCut(tree.getChild(i), nested);
                }
            }
        }
    }

    public static class Comment {
        public String comment;
        public long startLine;
        public long lines;
    }
}

