/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.logging;

import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Level;

public class Logger {
    private static boolean initialized = false;
    private static String configurationFile = "log4j.xml";
    private static Long watchDelay = null;
    private Class component;

    public Logger(Class component) {
        this.component = component;
    }

    private static String getExtensionDir() {
        return "../";
    }

    private static synchronized void init() {
    }

    public static void configure(String configFile, Long wDelay) {
        if (configurationFile != null) {
            configurationFile = configFile;
        }
        if (watchDelay != null) {
            watchDelay = wDelay;
        }
        initialized = false;
        Logger.init();
    }

    public void debug(Object o) {
    }

    public void debug(Object o, Throwable e) {
    }

    public void error(Object o) {
        Logger.getLoggerInstance().severe(o.toString());
    }

    public void error(Object o, Throwable e) {
        StackTraceElement[] st;
        Object t;
        String cl = Logger.class.getName();
        if (this.component != null) {
            cl = this.component.getName();
        }
        if ((t = e.getMessage()) == null) {
            try {
                t = e.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (t == null) {
            t = "";
        }
        if ((st = e.getStackTrace()) != null && st.length > 0) {
            t = (String)t + "\n" + st[0].toString();
        }
        Logger.getLoggerInstance().logp(Level.SEVERE, cl, o.toString(), (String)t);
    }

    public void info(Object o) {
        Logger.getLoggerInstance().info(o.toString());
    }

    public void info(Object o, Throwable e) {
        String cl = Logger.class.getName();
        if (this.component != null) {
            cl = this.component.getName();
        }
        Logger.getLoggerInstance().logp(Level.INFO, cl, o.toString(), e.getMessage());
    }

    public void warn(Object o) {
        Logger.getLoggerInstance().warning(o.toString());
    }

    public void finer(Object o) {
        Logger.getLoggerInstance().finer(o.toString());
    }

    public void fine(Object o) {
        Logger.getLoggerInstance().fine(o.toString());
    }

    public void fine(StackTraceElement element) {
        Logger.getLoggerInstance().logp(Level.FINE, element.getClassName(), element.getMethodName(), "line - " + element.getLineNumber());
    }

    public void info(StackTraceElement element) {
        Logger.getLoggerInstance().logp(Level.INFO, element.getClassName(), element.getMethodName(), "line - " + element.getLineNumber());
    }

    public void error(StackTraceElement element, String message) {
        if (message != null && !message.isEmpty()) {
            Logger.getLoggerInstance().logp(Level.SEVERE, element.getClassName(), element.getMethodName(), "line - " + element.getLineNumber() + "\n" + message);
        } else {
            Logger.getLoggerInstance().logp(Level.SEVERE, element.getClassName(), element.getMethodName(), "line - " + element.getLineNumber());
        }
    }

    private static StackTraceElement getRelatedStackTraceElement(StackTraceElement element, StackTraceElement[] errorStackTraceElements) {
        for (StackTraceElement el : errorStackTraceElements) {
            if (!element.getClassName().equals(el.getClassName()) || !element.getMethodName().equals(el.getMethodName())) continue;
            return el;
        }
        return null;
    }

    public static void error(Throwable e) {
        Logger.error_(null, e);
    }

    public static void error_(Object obj, Throwable e) {
        try {
            StackTraceElement[] errorStackTraceElements;
            Object message = null;
            if (obj != null) {
                message = obj.toString();
                message = (String)message + "\n" + e.getMessage();
            } else {
                message = e.getMessage();
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                message = (String)message + "\n" + cause.toString();
            }
            if ((errorStackTraceElements = e.getStackTrace()).length >= 3) {
                StackTraceElement error = errorStackTraceElements[2];
                if (error != null) {
                    Logger.getLoggerInstance().logp(Level.SEVERE, error.getClassName(), error.getMethodName(), "line - " + error.getLineNumber() + "\n" + (String)message);
                } else {
                    Logger.getLoggerInstance().log(Level.SEVERE, (String)message);
                }
            } else {
                Logger.getLoggerInstance().log(Level.SEVERE, (String)message);
            }
        }
        catch (Exception e1) {
            Logger.getLoggerInstance().warning(e1.getMessage());
        }
    }

    public void warn(Object o, Throwable e) {
        String cl = Logger.class.getName();
        if (this.component != null) {
            cl = this.component.getName();
        }
        Logger.getLoggerInstance().logp(Level.WARNING, cl, o.toString(), e.getMessage());
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    private static URL getCustomLogDir() {
        try {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void update() {
    }

    public static java.util.logging.Logger getLoggerInstance() {
        java.util.logging.Logger loggerInstance = java.util.logging.Logger.getLogger("oracle.dbtools.osddm");
        loggerInstance.setLevel(Level.ALL);
        java.util.logging.Logger parent = loggerInstance.getParent();
        if (parent != null) {
            try {
                Filter filter = parent.getFilter();
                if (filter != null) {
                    loggerInstance.setFilter(filter);
                }
                loggerInstance.setLevel(parent.getLevel());
                if (!Logger.hasHandlerInTheChain(loggerInstance)) {
                    loggerInstance.addHandler(new ConsoleHandler());
                }
            }
            catch (Throwable e) {
                loggerInstance.log(Level.SEVERE, "error in getLoggerInstance()", e);
            }
        }
        return loggerInstance;
    }

    static boolean hasHandlerInTheChain(java.util.logging.Logger lg) {
        for (java.util.logging.Logger logger = lg; logger != null; logger = logger.getParent()) {
            if (logger.getHandlers().length <= 0) continue;
            return true;
        }
        return false;
    }
}

