/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.scheduling.Positioned;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerProgram
extends SchedulerObject {
    List<SchedulerArgument> arguments = new ArrayList<SchedulerArgument>();
    public static Comparator<Positioned> POSITION_COMPARATOR = Comparator.comparing(Positioned::getPosition);
    public static String ARGUMENTS = "arguments";

    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("PROGRAM_NAME");
        this.propsList.add("PROGRAM_TYPE");
        this.propsList.add("PROGRAM_ACTION");
        this.propsList.add("NUMBER_OF_ARGUMENTS");
        this.propsList.add("ENABLED");
        this.propsList.add("DETACHED");
        this.propsList.add("SCHEDULE_LIMIT");
        this.propsList.add("MAX_RUNS");
        this.propsList.add("MAX_FAILURES");
        this.propsList.add("MAX_RUN_DURATION");
        this.propsList.add("HAS_CONSTRAINTS");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("PROGRAM_NAME", "VARCHAR2");
        this.dataTypes.put("PROGRAM_TYPE", "VARCHAR2");
        this.dataTypes.put("PROGRAM_ACTION", "VARCHAR2");
        this.dataTypes.put("NUMBER_OF_ARGUMENTS", "NUMBER");
        this.dataTypes.put("ENABLED", "BOOLEAN");
        this.dataTypes.put("DETACHED", "BOOLEAN");
        this.dataTypes.put("SCHEDULE_LIMIT", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("MAX_RUNS", "NUMBER");
        this.dataTypes.put("MAX_FAILURES", "NUMBER");
        this.dataTypes.put("MAX_RUN_DURATION", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("HAS_CONSTRAINTS", "BOOLEAN");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public void initdefaults() {
        this.defaults.put("NUMBER_OF_ARGUMENTS", "0");
        this.defaults.put("ENABLED", "FALSE");
        this.defaults.put("PRIORITY", "3");
        this.defaults.put("DETACHED", "FALSE");
    }

    @Override
    public String getName() {
        return this.getProperty("PROGRAM_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("PROGRAM_ACTION");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("PROGRAM_TYPE");
        return value != null && !value.isEmpty();
    }

    public List<SchedulerArgument> getArguments() {
        return this.arguments;
    }

    public List<SchedulerArgument> getSortedArguments() {
        try {
            Collections.sort(this.arguments, POSITION_COMPARATOR);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.arguments;
    }

    public boolean addArgument(String name, int position, String type, String metadataAttribute, String defaultValue) {
        int num = this.getNumberOfArguments();
        if (num > 0 && position > 0 && position <= num) {
            SchedulerArgument arg = this.getArgumentByPosition(position);
            if (arg == null) {
                arg = new SchedulerArgument();
                this.arguments.add(arg);
            }
            arg.setProperty("ARGUMENT_NAME", name);
            arg.setProperty("ARGUMENT_POSITION", String.valueOf(position));
            arg.setProperty("METADATA_ATTRIBUTE", metadataAttribute);
            arg.setProperty("DEFAULT_VALUE", "DEFAULT_VALUE");
        }
        return false;
    }

    public int getNumberOfArguments() {
        String num = this.getProperty("NUMBER_OF_ARGUMENTS");
        if (num != null && !num.isEmpty()) {
            try {
                return Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public SchedulerArgument getArgumentByPosition(int position) {
        for (SchedulerArgument arg : this.arguments) {
            if (position != arg.getPosition()) continue;
            return arg;
        }
        return null;
    }

    public boolean addArgument(SchedulerArgument arg) {
        int num = this.getNumberOfArguments();
        int position = arg.getPosition();
        if (num > 0 && position > 0 && position <= num) {
            SchedulerArgument targ = this.getArgumentByPosition(position);
            if (targ == null) {
                targ = new SchedulerArgument();
                this.arguments.add(targ);
            }
            arg.copyProperties(targ);
        }
        return false;
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        if (this.arguments.size() > 0) {
            ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
            PropertiesObject.CollectionDescriptor cd = new PropertiesObject.CollectionDescriptor();
            cd.name = ARGUMENTS;
            cd.coll = this::getSortedArguments;
            list.add(cd);
            return list;
        }
        return super.getCollectionDescriptors();
    }

    @Override
    public SchedulerObject createObjectForCollection(String collName) {
        if (collName != null && ARGUMENTS.equalsIgnoreCase(collName)) {
            return new SchedulerArgument();
        }
        return super.createObjectForCollection(collName);
    }

    @Override
    public void addObject(String collName, SchedulerObject obj) {
        if (collName != null && ARGUMENTS.equalsIgnoreCase(collName) && obj instanceof SchedulerArgument) {
            this.addArgument((SchedulerArgument)obj);
            return;
        }
        super.addObject(collName, obj);
    }
}

