/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public abstract class RoleOracle
extends AbstractStorageObjectOracle {
    private String identified = "NO";
    private String password = "";
    public static final String NAME_SUBSTITUTION_TYPE = "Role";
    protected InlineList roleSet = null;
    protected InlineList rolesWithAdminOptionSet = null;
    protected InlineList systemPrivilegesSet = null;
    protected InlineList privilegesWithAdminOptionSet = null;
    protected String roles = "";
    protected String rolesWithAdminOption = "";
    protected String systemPrivileges = "";
    protected String privilegesWithAdminOption = "";
    protected String isPublic = "NO";
    protected String adminOption = "NO";
    public static final String TYPE_NAME = "Role";

    @Override
    public String getIDPrefix() {
        return "Role";
    }

    @Override
    public String getObjectTypeName() {
        return "Role";
    }

    public void setIdentified(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.identified = value;
            this.fireDataFieldChange();
        }
    }

    public String getIdentified() {
        return this.identified;
    }

    public abstract void setAuthType(String var1);

    public abstract String getAuthType();

    public String getPassword() {
        return this.password;
    }

    public String decodePassword() {
        String result = this.password;
        return result;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void encodePassword(String password) {
        this.password = password;
    }

    public void setAdminOption(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.adminOption = value;
            this.fireDataFieldChange();
        }
    }

    public String getAdminOption() {
        return this.adminOption;
    }

    public void setRoles(String role) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRoleSet(role);
        } else {
            this.addRole(role);
        }
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public String getRoles() {
        return this.roles;
    }

    private void addRole(String role) {
        if (!this.getRolesSet().contains(role)) {
            this.getRolesSet().add(role);
        }
    }

    public void recreateRoleSet(String rls) {
        this.getRolesSet().clear();
        StringTokenizer st = new StringTokenizer(rls, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            if (id.equals(this.getObjectID())) continue;
            this.getRolesSet().add(id);
        }
    }

    public InlineList getRolesSet() {
        if (this.roleSet == null) {
            this.roleSet = new InlineList();
        }
        return this.roleSet;
    }

    public void setRolesWithAdminOption(String role) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateRolesWithAdminOptionSet(role);
        } else {
            this.addRoleWithAdminOption(role);
        }
        this.rolesWithAdminOption = this.getRolesWithAdminOptionSet().toString();
        this.roles = this.getRolesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getRolesWithAdminOptionSet() {
        if (this.rolesWithAdminOptionSet == null) {
            this.rolesWithAdminOptionSet = new InlineList();
        }
        return this.rolesWithAdminOptionSet;
    }

    protected void recreateRolesWithAdminOptionSet(String roles) {
        this.getRolesWithAdminOptionSet().clear();
        StringTokenizer st = new StringTokenizer(roles, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            if (id.equals(this.getObjectID())) continue;
            this.getRolesWithAdminOptionSet().add(id);
        }
    }

    protected void addRoleWithAdminOption(String role) {
        if (!this.getRolesWithAdminOptionSet().contains(role)) {
            this.getRolesWithAdminOptionSet().add(role);
        }
    }

    public String getRolesWithAdminOption() {
        return this.rolesWithAdminOption;
    }

    public void setPrivileges(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateSystemPrivilegesSet(privilege);
        } else {
            this.addPrivilege(privilege);
        }
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesSet() {
        if (this.systemPrivilegesSet == null) {
            this.systemPrivilegesSet = new InlineList();
        }
        return this.systemPrivilegesSet;
    }

    public String getPrivileges() {
        return this.systemPrivileges;
    }

    public void recreateSystemPrivilegesSet(String privileges) {
        this.getPrivilegesSet().clear();
        StringTokenizer st = new StringTokenizer(privileges, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            this.getPrivilegesSet().add(id);
        }
    }

    protected void addPrivilege(String systemPrivilege) {
        if (!this.getPrivilegesSet().contains(systemPrivilege)) {
            this.getPrivilegesSet().add(systemPrivilege);
        }
    }

    public void setPrivilegesWithAdminOption(String privilege) {
        if (this.getStorageDesign().isLoading()) {
            this.recreatePrivilegesWithAdminOptionSet(privilege);
        } else {
            this.addPrivilegeWithAdminOption(privilege);
        }
        this.privilegesWithAdminOption = this.getPrivilegesWithAdminOptionSet().toString();
        this.systemPrivileges = this.getPrivilegesSet().toString();
        this.fireDataFieldChange();
    }

    public InlineList getPrivilegesWithAdminOptionSet() {
        if (this.privilegesWithAdminOptionSet == null) {
            this.privilegesWithAdminOptionSet = new InlineList();
        }
        return this.privilegesWithAdminOptionSet;
    }

    public String getPrivilegesWithAdminOption() {
        return this.privilegesWithAdminOption;
    }

    protected void recreatePrivilegesWithAdminOptionSet(String priv) {
        this.getPrivilegesWithAdminOptionSet().clear();
        StringTokenizer st = new StringTokenizer(priv, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            this.getPrivilegesWithAdminOptionSet().add(id);
        }
    }

    protected void addPrivilegeWithAdminOption(String privilege) {
        if (!this.getPrivilegesWithAdminOptionSet().contains(privilege)) {
            this.getPrivilegesWithAdminOptionSet().add(privilege);
        }
    }

    public void setPublic(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.isPublic = value;
            this.fireDataFieldChange();
        }
    }

    public String getPublic() {
        return this.isPublic;
    }

    public void clear() {
        this.getPrivilegesSet().removeAllElements();
        this.getPrivilegesWithAdminOptionSet().removeAllElements();
        this.getRolesSet().removeAllElements();
        this.getRolesWithAdminOptionSet().removeAllElements();
        this.roles = "";
        this.rolesWithAdminOption = "";
        this.systemPrivileges = "";
        this.privilegesWithAdminOption = "";
    }

    public String getRolesWithAdminOptionNames() {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle rs = sd.getRoleSet();
        Object result = "";
        boolean first = true;
        Object[] roles = this.getRolesWithAdminOptionSet().toArray();
        for (int i = 0; i < roles.length; ++i) {
            String id = (String)roles[i];
            RoleOracle role = (RoleOracle)rs.getById(id);
            if (role == null) continue;
            if (!first) {
                result = (String)result + "," + role.getName();
                continue;
            }
            result = role.getName();
            first = false;
        }
        return result;
    }

    public String getRolesNames() {
        StorageDesignOracle sd = (StorageDesignOracle)this.getStorageDesign();
        RoleSetOracle rs = sd.getRoleSet();
        Object result = "";
        boolean first = true;
        Object[] roles = this.getRolesSet().toArray();
        for (int i = 0; i < roles.length; ++i) {
            String id = (String)roles[i];
            RoleOracle role = (RoleOracle)rs.getById(id);
            if (role == null) continue;
            if (!first) {
                result = (String)result + "," + role.getName();
                continue;
            }
            result = role.getName();
            first = false;
        }
        return result;
    }

    public List getPermissions() {
        ArrayList<PermissionsOracle> perms = new ArrayList<PermissionsOracle>();
        for (PermissionsOracle permission : ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet()) {
            if (permission.getRole() != this) continue;
            perms.add(permission);
        }
        return perms;
    }

    public PermissionsOracle createPermission() {
        PermissionsOracle permission = ((StorageDesignOracle)this.getStorageDesign()).getPermissionsSet().createPermissions();
        permission.setRole(this);
        return permission;
    }

    public void applyPermissionsList(List newPermissions) {
        List allPermissions;
        if (newPermissions.size() > 0 && (allPermissions = this.getPermissions()).size() > newPermissions.size()) {
            for (PermissionsOracle permission : allPermissions) {
                if (newPermissions.contains(permission)) continue;
                for (PermissionsOracle newPermission : newPermissions) {
                    if (!(permission.getTable() != null && permission.getTable() == newPermission.getTable() || permission.getView() != null && permission.getView() == newPermission.getView() || permission.getSequence() != null && permission.getSequence() == newPermission.getSequence() || permission.getSnapshot() != null && permission.getSnapshot() == newPermission.getSnapshot() || permission.getProc() != null && permission.getProc() == newPermission.getProc() || permission.getPackage() != null && permission.getPackage() == newPermission.getPackage() || permission.getFunctionOracle() != null && permission.getFunctionOracle() == newPermission.getFunctionOracle() || permission.getDirectoryOracle() != null && permission.getDirectoryOracle() == newPermission.getDirectoryOracle() || permission.getStructuredTypeOracle() != null && permission.getStructuredTypeOracle() == newPermission.getStructuredTypeOracle() || permission.getCollectionTypeOracle() != null && permission.getCollectionTypeOracle() == newPermission.getCollectionTypeOracle()) && (permission.getExternalTableOracle() == null || permission.getExternalTableOracle() != newPermission.getExternalTableOracle())) continue;
                    permission.remove();
                }
            }
        }
    }

    @Override
    public void remove() {
        this.removePermissions();
        super.remove();
    }

    @Override
    public void remove(boolean force) {
        this.removePermissions();
        super.remove(force);
    }

    private void removePermissions() {
        for (PermissionsOracle perm : this.getPermissions()) {
            perm.clear();
            perm.remove();
        }
    }

    @Override
    public String getNameSubstitutionType() {
        return "Role";
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            return String.valueOf(one).compareTo(String.valueOf(two));
        }
    }
}

