/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ProxyDesignObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;

public abstract class TableViewProxySet
extends ProxyDesignObjectSet {
    public TableViewProxySet(StorageDesign storageDesign) {
        super(storageDesign);
    }

    @Override
    protected DesignObjectSet getPhysicalDesignObjectSet() {
        return this.getStorageDesign().getPhysicalDesign().getTableViewSet();
    }

    public TableViewProxy getBySchemaAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        TableViewProxy proxy = null;
        while (it.hasNext()) {
            proxy = (TableViewProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName())) continue;
            StorageObject userSchema = proxy.getUserSchema();
            if (userSchema != null && userSchema.getName().equalsIgnoreCase(schema)) {
                return proxy;
            }
            TableView table = (TableView)proxy.getObject();
            if (!table.getSchema().equalsIgnoreCase(schema)) continue;
            return proxy;
        }
        return null;
    }

    public TableViewProxy getBySchemaImplAndName(String schema, String name) {
        Iterator it = this.getElements().iterator();
        TableViewProxy proxy = null;
        while (it.hasNext()) {
            ModelIDObject userSchema;
            proxy = (TableViewProxy)it.next();
            if (!name.equalsIgnoreCase(proxy.getName()) || (userSchema = proxy.getSchemaImplementingObject()) == null || !userSchema.getName().equalsIgnoreCase(schema)) continue;
            return proxy;
        }
        return null;
    }
}

