/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.List;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.GlobalKeyObjectSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.TableSet;

public class GlobalIndexSet
extends GlobalKeyObjectSet {
    private static final Object[] PROTOARRAY = IndexSet.PROTOARRAY;

    public GlobalIndexSet(TableSet tableSet) {
        super(tableSet);
        this.setDesignPart(tableSet.getDesignPart());
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTOARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "IDX";
    }

    @Override
    public Object getParent() {
        return this.getDesignPart();
    }

    @Override
    public String toString() {
        return "All Indices";
    }

    public ModelObject getBySchemaAndName(String schema, String name) {
        if (name != null) {
            String trimedName = name.trim();
            for (Index mo : this.elements) {
                SchemaObject so;
                if (mo.getName() == null || !mo.getName().trim().equalsIgnoreCase(trimedName) || (so = mo.getSchemaObject()) == null || !so.getName().equalsIgnoreCase(schema)) continue;
                return mo;
            }
        }
        return null;
    }

    public ModelObject getByMatchingColumns(String schema, String table, List<String> columns) {
        if (schema != null && table != null && !columns.isEmpty()) {
            Object[] keys = this.getPKUK(schema, table);
            for (int i = 0; i < keys.length; ++i) {
                Column[] keyColumns;
                if (!(keys[i] instanceof Index) || (keyColumns = (Column[])((Index)keys[i]).getColumns()).length != columns.size()) continue;
                boolean mismatch = false;
                for (int j = 0; j < columns.size(); ++j) {
                    if (columns.get(j).equalsIgnoreCase(keyColumns[j].getName())) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) continue;
                return (Index)keys[i];
            }
        }
        return null;
    }
}

