/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBFKOraclev10g;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableViewProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;

public class CSSBTableViewOraclev10g
extends AbstractCSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CompareObjectSelection viewsel = (CompareObjectSelection)object;
        TableView view = null;
        TableViewProxyOraclev10g proxy = null;
        if (((CompareObjectSelection)object).getObject() instanceof TableView) {
            RDBMSSite site;
            view = (TableView)((CompareObjectSelection)object).getObject();
            Design design = view.getDesign();
            if (design.getStorageDesign(site = view.getSelectedRDBMSSite()) instanceof StorageDesignOraclev10g) {
                this.storageDesign = design.getStorageDesign(site);
                proxy = (TableViewProxyOraclev10g)this.storageDesign.getProxy(view);
            }
        } else if (((CompareObjectSelection)object).getObject() instanceof TableViewProxyOraclev10g) {
            proxy = (TableViewProxyOraclev10g)((CompareObjectSelection)object).getObject();
            view = (TableView)proxy.getObject();
            this.storageDesign = proxy.getStorageDesign();
        }
        Map pmap = this.getPropertiesMap((CompareObjectSelection)object);
        boolean hasComments = false;
        String comments = null;
        if (pmap.containsKey(PropertiesComparator.COMMENT_IN_RDBMS)) {
            hasComments = true;
            EngPropertyHolder ph = (EngPropertyHolder)pmap.remove(PropertiesComparator.COMMENT_IN_RDBMS);
            if (ph != null) {
                comments = ph.getLeftValue();
                ph.setModified(false);
                ph.setSelected(false);
            }
        }
        if (viewsel.canBeRename()) {
            if (proxy != null) {
                StorageDesignOracle tStorageDesign = null;
                List<MOHTableOracle.FKTemp> flist = null;
                CompareObjectSelection tviewsel = viewsel.getCorrespondentNode();
                TableView tview = null;
                if (tviewsel != null) {
                    tview = (TableView)tviewsel.getObject();
                }
                List list = null;
                HashMap<KeyObject, KeyObject> map = new HashMap<KeyObject, KeyObject>();
                if (tview != null) {
                    tStorageDesign = (StorageDesignOracle)this.getStorageDesign(tview);
                    list = tview.getPK_UKList();
                    ModelIdObjectSelection mtsel = tviewsel.getChildByType("PK_UK_Indexes");
                    for (ModelIdObjectSelection ms : mtsel.getChilds()) {
                        KeyObject tind;
                        if (ms == null || !(ms.getObject() instanceof KeyObject) || (tind = (KeyObject)ms.getObject()) == null) continue;
                        ModelIdObjectSelection ssel = ms.getCorrespondentObjectSelection();
                        if (ssel != null && ssel.getObject() instanceof KeyObject) {
                            KeyObject sind = (KeyObject)ssel.getObject();
                            if (sind == null || sind.getElementsCollection().size() != tind.getElementsCollection().size()) {
                                list.remove(tind);
                                continue;
                            }
                            map.put(tind, sind);
                            continue;
                        }
                        list.remove(tind);
                    }
                    flist = this.getFKDescriptorsForRestoreFKs(list, map, tStorageDesign, tview, false);
                    if (flist.size() > 0) {
                        StringBuffer dropbuffer = new StringBuffer();
                        CSSBTableViewOraclev10g.appendStringWithSpace(dropbuffer, "DROP");
                        CSSBTableViewOraclev10g.appendStringWithSpace(dropbuffer, "VIEW");
                        CSSBTableViewOraclev10g.appendStringWithSpace(dropbuffer, tStorageDesign.getFormatedLongNameDDL(tview));
                        String advancedComment = dropbuffer.toString();
                        CSSBTableViewOraclev10g.appendStringWithSpace(dropbuffer, "CASCADE CONSTRAINTS");
                        this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                        CSSBTableViewOraclev10g.appendNewLine(dropbuffer, prettyPrint, 0);
                        CSSBTableViewOraclev10g.appendLineFinisher(dropbuffer, prettyPrint);
                        this.appendToBuffer(oldbuffer, dropbuffer, advancedComment);
                        this.getStatus().incrementDropView();
                    }
                } else {
                    tStorageDesign = (StorageDesignOracle)this.storageDesign;
                }
                if (proxy.isCommentChanged()) {
                    this.appendComment(oldbuffer, proxy);
                } else {
                    this.appendComment(oldbuffer, view);
                }
                Object stmt = view.getBasedOnStructuredType() != null ? view.getUserDefinedSQL() : proxy.getDefinition();
                stmt = ((String)stmt).trim();
                if (((String)stmt).endsWith(";")) {
                    stmt = ((String)stmt).substring(0, ((String)stmt).length() - 1).trim();
                }
                if (!"".equalsIgnoreCase((String)stmt)) {
                    int index;
                    Object createViewPart = "";
                    boolean includesColumnList = false;
                    if (Token.getFirstToken((String)stmt).equalsIgnoreCase("CREATE") && (index = ((String)stmt).toUpperCase().indexOf("VIEW")) > -1) {
                        int viewNameIndex;
                        int dotIndex;
                        createViewPart = ((String)stmt).substring(0, index + 4);
                        String stmtWithoutNL = ((String)(stmt = ((String)stmt).substring(index + 4).trim())).replaceAll("[\t\n\f\r\u000b]+", " ");
                        String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                        int bracketIndex = oldViewName.indexOf(40);
                        if (bracketIndex > -1) {
                            oldViewName = oldViewName.substring(0, bracketIndex);
                        }
                        if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                            oldViewName = oldViewName.substring(dotIndex + 1);
                        }
                        if ((viewNameIndex = ((String)stmt).indexOf(oldViewName, dotIndex)) > -1 && ((String)(stmt = ((String)stmt).substring(viewNameIndex + oldViewName.length()))).startsWith("\"")) {
                            stmt = ((String)stmt).substring(1);
                        }
                        if (((String)(stmt = ((String)stmt).trim())).toUpperCase().startsWith("AS")) {
                            stmt = ((String)stmt).substring(2).trim();
                        } else if (((String)stmt).startsWith("(")) {
                            includesColumnList = true;
                        }
                    }
                    Object beforeView = "YES".equalsIgnoreCase(proxy.getForce()) ? "CREATE OR REPLACE FORCE" : (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL() ? "CREATE OR REPLACE NOFORCE" : "CREATE OR REPLACE");
                    if ("YES".equalsIgnoreCase(proxy.getEditioning()) && this.storageDesign instanceof StorageDesignOraclev11g) {
                        beforeView = (String)beforeView + " EDITIONING";
                    }
                    if (!Token.startsWithString((String)createViewPart, (String)beforeView)) {
                        createViewPart = (String)beforeView + " VIEW";
                    }
                    ModelIDObject viewObject = this.storageDesign.isOpen() ? proxy : view;
                    createViewPart = (String)createViewPart + " " + this.storageDesign.getFormatedLongNameDDL(viewObject);
                    if (view.getBasedOnStructuredType() != null) {
                        if (((String)stmt).toUpperCase().startsWith("OF")) {
                            createViewPart = (String)createViewPart + NEWLINE + " " + (String)stmt;
                            stmt = "";
                        } else {
                            createViewPart = (String)createViewPart + this.appendStructuredType(proxy);
                        }
                    }
                    if (((String)stmt).equals("")) {
                        stmt = createViewPart;
                    } else if (includesColumnList) {
                        stmt = (String)createViewPart + " " + (String)stmt;
                    } else {
                        String columnList = this.getColumnList(view, true);
                        stmt = (String)createViewPart + " " + columnList + " AS" + NEWLINE + (String)stmt;
                    }
                    this.appendBeforeCreateScript(oldbuffer, prettyPrint, view);
                    CSSBTableViewOraclev10g.appendStringWithSpace(buffer, (String)stmt);
                    this.appendWith(buffer, proxy);
                    this.appendToBuffer(oldbuffer, buffer, (String)createViewPart);
                    CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                    CSSBTableViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, (String)createViewPart);
                    this.getStatus().incrementCreateView();
                    this.appendPKDefinition(oldbuffer, view, proxy, prettyPrint);
                    this.appendUniqueDefinition(oldbuffer, view, proxy, prettyPrint);
                    this.appendAfterCreateScript(oldbuffer, prettyPrint, view);
                    if (proxy.getDesign().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendViewCommentOn(this.storageDesign, oldbuffer, view, proxy, prettyPrint);
                    }
                    SSBFKOraclev10g.appendFK_DDL(oldbuffer, flist, tStorageDesign, this.getStatus());
                    if (flist.size() > 0) {
                        this.appendPermissions(oldbuffer, proxy, prettyPrint);
                    }
                } else {
                    CSSBTableViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                    this.getStatus().incrementErrors();
                }
            }
        } else {
            if (hasComments && comments != null && comments != null) {
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "TABLE");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(view));
                String advancedComment = buffer.toString();
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "IS");
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBTableViewOraclev10g.appendString(buffer, '\'');
                CSSBTableViewOraclev10g.appendString(buffer, this.replaceSingleQuote(comments));
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, '\'');
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            ModelIdObjectSelection sel = viewsel.getChildByType("Columns");
            for (CompareObjectSelection csel : sel.getChilds()) {
                ModelIDObject col = csel.getObject();
                EngPropertyHolder phc = csel.getPropertiesComparator().getPropertyHolderByName(PropertiesComparator.COMMENT_IN_RDBMS);
                if (col == null || phc == null || !phc.isSelected() || !phc.isModified()) continue;
                comments = phc.getLeftValue();
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "COMMENT ON");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                CSSBTableViewOraclev10g.appendString(buffer, this.storageDesign.getFormatedLongNameDDL(view));
                CSSBTableViewOraclev10g.appendString(buffer, '.');
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(col));
                String advancedComment = buffer.toString();
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "IS");
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                CSSBTableViewOraclev10g.appendString(buffer, '\'');
                CSSBTableViewOraclev10g.appendString(buffer, this.replaceSingleQuote(comments));
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, '\'');
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
        }
    }

    private String appendStructuredType(TableViewProxyOraclev10g view) {
        StringBuffer forInsert = new StringBuffer();
        CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "\n");
        CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "OF");
        StructuredTypeProxy stp = (StructuredTypeProxy)this.storageDesign.getStructuredTypeProxySet().getProxy(((TableView)view.getObject()).getBasedOnStructuredType().getObjectID());
        CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(stp));
        TableViewProxy superView = view.getSuperView();
        if (superView != null) {
            CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "UNDER");
            CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, this.storageDesign.getFormatedLongNameDDL(superView));
        } else {
            String schemaElement = view.getXmlSchemaElement();
            if (!"".equalsIgnoreCase(schemaElement)) {
                String schemaUrl = view.getXmlSchemaUrl();
                if (!"".equalsIgnoreCase(schemaUrl)) {
                    CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "XMLSCHEMA");
                    forInsert.append('\"').append(schemaUrl).append('\"').append(' ');
                }
                CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "ELEMENT");
                forInsert.append('\"').append(schemaElement).append('\"').append(' ');
            }
            CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "WITH");
            CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "OBJECT");
            CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "IDENTIFIER");
            if (view.getOidAttributes() == null || "".equalsIgnoreCase(view.getOidAttributes())) {
                CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, "DEFAULT");
            } else {
                CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, '(');
                CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, view.getOidAttributes());
                CSSBTableViewOraclev10g.appendStringWithSpace(forInsert, ')');
            }
        }
        return forInsert.toString();
    }

    private void appendWith(StringBuffer buffer, TableViewProxyOraclev10g viewProxy) {
        if ("YES".equalsIgnoreCase(viewProxy.getReadOnly())) {
            if (buffer.indexOf("WITH READ ONLY") == -1) {
                buffer.append(NEWLINE).append("    ");
                buffer.append("WITH READ ONLY");
            }
        } else if (viewProxy.getCheckOption() && viewProxy.getDefinition() != null && viewProxy.getDefinition().trim().length() != 0) {
            int withCheckOptionIndex = buffer.lastIndexOf("WITH CHECK OPTION");
            if (withCheckOptionIndex == -1) {
                buffer.append(NEWLINE).append("    ");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "WITH CHECK OPTION");
            }
            if (!"".equalsIgnoreCase(viewProxy.getCheckOptionName())) {
                int constraintIndex = buffer.lastIndexOf("CONSTRAINT ");
                if (constraintIndex > withCheckOptionIndex && withCheckOptionIndex > -1) {
                    buffer.delete(constraintIndex, buffer.length());
                }
                buffer.append("CONSTRAINT ").append(viewProxy.getCheckOptionName());
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableViewProxyOraclev10g viewProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        Object advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)this.storageDesign).getPermissionsSet();
        for (PermissionsOraclev10g permissions : permissionsSet) {
            if (permissions.getView() != null && permissions.getView().equals(viewProxy) && !permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "GRANT");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions);
                this.appendTo(buffer, permissions, this.storageDesign);
                this.appendHierrarchyOption(buffer, permissions);
                advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
                CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
            }
            if (permissions.getView() == null || !permissions.getView().equals(viewProxy) || permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "GRANT");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions);
            this.appendTo(buffer, permissions, this.storageDesign);
            this.appendHierrarchyOption(buffer, permissions);
            this.appendGrantOption(buffer, permissions);
            advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
            this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            this.appendToBuffer(oldbuffer, buffer, (String)advancedComments);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getView() != null) {
            buffer.append(NEWLINE);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "ON");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getView()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            buffer.append(NEWLINE);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableView view, TableViewProxyOraclev10g viewProxy, boolean prettyPrint) {
        String columns;
        KeyObject pk = view.getPK();
        if (pk != null && pk.isMarkedGenerate() && !"".equalsIgnoreCase(columns = pk.getColumnsAsString(this.storageDesign))) {
            CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (!"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            }
            int maxConstraintNameLength = viewProxy.getMaxConstraintNameLength();
            String pkName = pk.getName();
            if (pkName.length() > maxConstraintNameLength) {
                CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + maxConstraintNameLength + ")");
                CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementErrors();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "VIEW");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(view));
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!pkName.startsWith("SYS_")) {
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            String advancedComment = buffer.toString();
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, columns);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBTableViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterView();
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableView view, TableViewProxyOraclev10g viewProxy, boolean prettyPrint) {
        List list = view.getUniqueKeysList();
        for (KeyObject unique : list) {
            if (!unique.isMarkedGenerate()) continue;
            CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            if (!"".equalsIgnoreCase(unique.getComment())) {
                this.appendComment(oldbuffer, unique);
            }
            int maxConstraintNameLength = viewProxy.getMaxConstraintNameLength();
            String uniqueName = unique.getName();
            if (uniqueName.length() > maxConstraintNameLength) {
                CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBTableViewOraclev10g.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + maxConstraintNameLength + ")");
                CSSBTableViewOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementErrors();
            }
            StringBuffer buffer = new StringBuffer();
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "ALTER");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "VIEW");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(view));
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "ADD");
            if (!uniqueName.startsWith("SYS_")) {
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBTableViewOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            }
            String advancedComment = buffer.toString();
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "UNIQUE");
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, unique.getColumnsAsString(this.storageDesign));
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, ')');
            CSSBTableViewOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBTableViewOraclev10g.appendLineFinisher(buffer, prettyPrint);
            CSSBTableViewOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterView();
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof TableView;
    }

    private String getPermissionsTO(PermissionsOraclev10g permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getLongName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getLongName();
        }
        return "";
    }

    private Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, EngPropertyHolder> propMap = new TreeMap<String, EngPropertyHolder>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected() || !ph.isModified() || !ph.isDDLHolder() || ph.isFiltered()) continue;
            propMap.put(ph.getName(), ph);
        }
        return propMap;
    }

    private String getPermissionsON(PermissionsOraclev10g permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongName();
        }
        if (permissions.getView() != null) {
            return permissions.getView().getLongName();
        }
        if (permissions.getSequence() != null) {
            return permissions.getSequence().getLongName();
        }
        if (permissions.getSnapshot() != null) {
            return permissions.getSnapshot().getLongName();
        }
        if (permissions.getProc() != null) {
            return permissions.getProc().getLongName();
        }
        if (permissions.getDirectoryOracle() != null) {
            return permissions.getDirectoryOracle().getLongName();
        }
        if (permissions.getStructuredTypeOracle() != null) {
            return permissions.getStructuredTypeOracle().getLongName();
        }
        if (permissions.getCollectionTypeOracle() != null) {
            return permissions.getCollectionTypeOracle().getLongName();
        }
        if (permissions.getExternalTableOracle() != null) {
            return permissions.getExternalTableOracle().getLongName();
        }
        return "";
    }
}

