/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBContextOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBContextOraclev9i;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropContextOracle;
import oracle.dbtools.crest.model.design.compare.storage.oracle.ContextComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.oracle.ContextOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ContextOraclev10g;

public class CSSBContextOracle
extends AbstractCSSBOracle {
    private SSBContextOraclev10g ssbContextOraclev10g = null;
    private SSBContextOraclev9i ssbContextOraclev9i = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceTypeSel = (CompareObjectSelection)object;
        boolean drop = false;
        boolean generate = false;
        if (sourceTypeSel.canBeCreate()) {
            generate = true;
        } else if (sourceTypeSel.isDDLModified()) {
            generate = true;
            EngPropertyHolder ph = sourceTypeSel.getPropertiesComparator().getPropertyHolderByName(ContextComparatorOracle.NAMESPACE);
            if (ph != null && ph.isSelected() && !ph.isFiltered()) {
                drop = true;
            }
        }
        if (generate) {
            ContextOracle context;
            if (drop) {
                CSSBDropContextOracle cssbDropContextOracle = new CSSBDropContextOracle();
                cssbDropContextOracle.doAppend(oldbuffer, object, prettyPrint);
            }
            if ((context = (ContextOracle)sourceTypeSel.getObject()) instanceof ContextOraclev10g) {
                if (this.ssbContextOraclev10g == null) {
                    this.ssbContextOraclev10g = new SSBContextOraclev10g();
                    this.ssbContextOraclev10g.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbContextOraclev10g.doAppend(oldbuffer, context, prettyPrint);
            } else {
                if (this.ssbContextOraclev9i == null) {
                    this.ssbContextOraclev9i = new SSBContextOraclev9i();
                    this.ssbContextOraclev9i.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbContextOraclev9i.doAppend(oldbuffer, context, prettyPrint);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof ContextOracle;
    }
}

