/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBCollectionTypeOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBCollectionTypeOraclev9i;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropType;
import oracle.dbtools.crest.model.design.compare.storage.oracle.CollectionTypeComparatorOracle;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;

public class CSSBCollectionType
extends AbstractCSSBOracle {
    private SSBCollectionTypeOraclev10g ssbCollectionTypeOraclev10g = null;
    private SSBCollectionTypeOraclev9i ssbCollectionTypeOraclev9i = null;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CollectionType sourceCollType;
        StorageDesign sourceSD;
        CollectionTypeProxyOracle sourceCTProxy;
        CompareObjectSelection sourceTypeSel = (CompareObjectSelection)object;
        boolean drop = false;
        boolean generate = false;
        if (sourceTypeSel.canBeCreate()) {
            generate = true;
        } else {
            for (EngPropertyHolder ph : sourceTypeSel.getPropertiesComparator().getPropertiesList()) {
                if (!ph.isSelected() || !ph.isDDLHolder()) continue;
                if (ph.getName().equals(PropertyNames.NAME)) {
                    drop = true;
                }
                generate = true;
            }
            for (EngPropertyHolder ph : sourceTypeSel.getPropertiesComparator().getPhysicalPropertiesList()) {
                if (!ph.isSelected() || !ph.isDDLHolder()) continue;
                if (ph.getName().equals(CollectionTypeComparatorOracle.OWNER)) {
                    if (!sourceTypeSel.getDesign().getSettings().isIncludeSchemaInDDL()) continue;
                    drop = true;
                    generate = true;
                    continue;
                }
                if (ph.getName().equals(PropertyNames.NAME)) {
                    drop = true;
                }
                generate = true;
            }
        }
        if (generate && (sourceCTProxy = (CollectionTypeProxyOracle)(sourceSD = this.getStorageDesign(sourceCollType = (CollectionType)sourceTypeSel.getObject())).getCollectionTypeProxySet().getProxy(sourceCollType.getObjectID())) != null) {
            if (drop) {
                CSSBDropType cssbDropType = new CSSBDropType();
                cssbDropType.doAppend(oldbuffer, object, prettyPrint);
            }
            if (sourceCTProxy instanceof CollectionTypeProxyOraclev10g) {
                if (this.ssbCollectionTypeOraclev10g == null) {
                    this.ssbCollectionTypeOraclev10g = new SSBCollectionTypeOraclev10g();
                    this.ssbCollectionTypeOraclev10g.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbCollectionTypeOraclev10g.doAppend(oldbuffer, sourceCTProxy, prettyPrint);
            } else {
                if (this.ssbCollectionTypeOraclev9i == null) {
                    this.ssbCollectionTypeOraclev9i = new SSBCollectionTypeOraclev9i();
                    this.ssbCollectionTypeOraclev9i.setDDLGenerator(this.getDDLGenerator());
                }
                this.ssbCollectionTypeOraclev9i.doAppend(oldbuffer, sourceCTProxy, prettyPrint);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof CollectionType;
    }
}

